#!/perl -w
# NAME: favfind.pl
# AIM: Read Favorites folder, and show a URL on find ...
# 16/02/2008 - Geoff McLane - http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
push(@INC, 'C:/GTools/perl');
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $def_fav_folder = "C:\\Documents and Settings\\Geoff McLane\\Favorites";
my $find = 'cvs';

my $favfolder = get_favorite_folder();
prt( "Processing folder [$favfolder] ...\n" );
my $basedir = quotemeta($favfolder);
# entries to EXCLUDE
my @fav_exclude = ( 'https://geoffmclane.com:2083/frontend/x/index.html' );

my @dirs = ($favfolder);	# start folder
my @fils = ();				# collection of files from folder
my @found = ();
my @warnings = ();
my @urls = ();
my $msg = '';

# DEBUG ONLY
my $dbg1 = 0;	# show 	"Processing $d ...
my $dbg2 = 0;	# show 	"Found $fcnt files, and $dcnt directories ...

my $file = '';
my $line = '';
### begin processing
while (@dirs) {
	my @dir2 = @dirs;	# copy array
	@dirs = ();			# and kill these
	foreach my $dn (@dir2) {
		process_dir($dn);	# prcess folder, which may yield more folders
	}
}
my $fcnt = scalar @fils;
prt( "Found $fcnt URL files ...\n" );

foreach $file (@fils) {
	my ($name,$dir,$suffix) = fileparse($file, qr/\.[^.]*/ );
	if ($name =~ /$find/i) {
		prt( "$file\n" );
		push(@found,$file);
	}
}
my $fndcnt = scalar @found;
prt( "Found $fndcnt, containing $find ...\n" );
foreach $file (@found) {
	if ( open( FH, $file ) ) {
		my @lns = <FH>; # slurp in the lines
		close FH;
		foreach $line (@lns) {
			chomp $line;
			if( $line =~ /^URL=/ ) {
				my $u = substr($line,4); ## ~ s/^URL=//;
				prt("$line\n");
				push(@urls,$u);
			}
		}
	} else {
		$msg = "WARNING: FAILED TO OPEN [$file]";
		prt( "$msg\n" );
		push(@warnings,$msg);
	}
}

foreach $line (@urls) {
	prt( "$line\n" );
}

close_log($outfile,1);
exit(0);
############################################

sub get_favorite_folder {
	my $ff = '';
	if( !defined( $ENV{'USERPROFILE'} ) ) {
		mydie( "ERROR: Can NOT locate USERPROFILE in ENVironment!\n" );
	}
	$ff = $ENV{'USERPROFILE'} . '\\Favorites';
	if( !( -d $ff ) ) {
		mydie( "ERROR: Folder $ff is NOT a directory!\n" );
	}
	return $ff;
}

sub get_file_list {
	my ($d, @fs) = @_;
	foreach my $fn (@fs) {
		next if ($fn eq '.');
		next if ($fn eq '..');
		my $ffn = $d . '\\' . $fn;
		if( -d $ffn ) {
			push(@dirs, $ffn);
		} else {
			if ($fn =~ /.+\.url$/i) {
				push(@fils, $ffn);
			} else {
				prt( "Discarding file $ffn ...\n" );
			}
		}
	}
	my $fcnt = scalar @fils;
	my $dcnt = scalar @dirs;
	prt( "Found $fcnt files, and $dcnt directories ...\n" ) if ($dbg2);
}

sub process_dir {
	my ($d) = shift;
	prt( "Processing $d ...\n" ) if ($dbg1);
	if (opendir(DIRH, $d)) {
		my @dfs = readdir(DIRH);
		closedir(DIRH);
		prt( "Found " . scalar @dfs . " entries ...\n" ) if ($dbg1);
		get_file_list($d, @dfs);
	} else {
		prt( "WARNING: Failed to open directory [$d]!...\n" );
	}
}

# eof
