#!/usr/bin/perl -w
# NAME: fg_coms.pl
# AIM: Get the current COM frequencies
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
require 'lib_fgio.pl' or die "Unable to load 'lib_fgio.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

my $set_com1 = 0;
my $set_com2 = 0;
my $set_nav1 = 0;
my $set_nav2 = 0;
my $set_adf  = 0;
my ($com1, $com2, $nav1, $nav2, $adf);

my $HOST = "localhost";
my $PORT = 5556;
my $TIMEOUT = 3;
my $DELAY = 5;

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub prtt($) {
    my $txt = shift;
    prt(lu_get_hhmmss_UTC(time()).": $txt");
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub get_fg_coms() {
    set_lib_fgio_verb(0);
    if (fgfs_connect($HOST,$PORT,$TIMEOUT)) {
        prt("Connection established... on host $HOST, port $PORT\n");
       	fgfs_send("data");  # switch exchange to data mode
        my $rc = fgfs_get_comms();
        show_comms($rc);
        fgfs_set_com1($com1) if ($set_com1);
        fgfs_set_com2($com2) if ($set_com2);
        fgfs_set_nav1($nav1) if ($set_nav1);
        fgfs_set_nav2($nav2) if ($set_nav2);
        fgfs_set_adf($adf) if ($set_adf);
        fgfs_disconnect();
    } else {
        prt("Connection FAILED on host $HOST, port $PORT!\n");
        pgm_exit(1,"");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
##process_in_file($in_file);
get_fg_coms();

pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } elsif ($sarg =~ /^c/) {
                if ($sarg eq 'com1') {
                    need_arg(@av);
                    shift @av;
                    $sarg = $av[0];
                    $set_com1 = 1;
                    $com1 = $sarg;
                } elsif ($sarg eq 'com2') {
                    need_arg(@av);
                    shift @av;
                    $sarg = $av[0];
                    $set_com2 = 1;
                    $com2 = $sarg;
                } else {
                    pgm_exit(1,"ERROR: Invalid argument [$arg]! Only -com1 or -com2\n");
                }
            } elsif ($sarg =~ /^n/) {
                if ($sarg eq 'nav1') {
                    need_arg(@av);
                    shift @av;
                    $sarg = $av[0];
                    $set_nav1 = 1;
                    $nav1 = $sarg;
                } elsif ($sarg eq 'nav2') {
                    need_arg(@av);
                    shift @av;
                    $sarg = $av[0];
                    $set_nav2 = 1;
                    $nav2 = $sarg;
                } else {
                    pgm_exit(1,"ERROR: Invalid argument [$arg]! Only -nav1 or -nav2\n");
                }
            } elsif ($sarg =~ /^adf$/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $set_adf = 1;
                $adf = $sarg;
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options]\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt(" -com1 freq         = Set COM1 to this frequency.");

}

# eof - template.pl
