#!/usr/bin/perl -w
# NAME: fg_httpd.pl
# AIM: Given a HOST and a PORT, query the property tree
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
use LWP::Simple;
use Term::ReadKey;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $temp_dir = '/tmp';
my $PATH_SEP = '/';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $PATH_SEP = "\\";
    $temp_dir = $perl_dir;
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
require 'lib_html.pl' or die "Unable to load 'lib_html.pl' Check location and paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-01-01";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_xml = $temp_dir.$PATH_SEP.'temp-url.htm';
my $show_all_text = 0;
my $got_esc = 0;

my $HOST = '';
my $PORT = '';

### program variables
my @warnings = ();
my $cwd = cwd();


# debug
my $debug_on = 1;
my $def_host = 'http://192.168.1.105';
my $def_port = '5050';

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub got_keyboard($) {
    my ($rc) = shift;   # -1 =  Perform a non-blocked read
    # when set to 'cbreak' mode (4)
    if (defined (my $char = ReadKey(-1)) ) {
        # input was waiting and it was $char
        ${$rc} = $char;
        return 1;
    }
    return 0;
}

sub check_keyboard() {
    my ($char,$val,$pmsg);
    if (got_keyboard(\$char)) {
        $val = ord($char);
        $pmsg = sprintf( "%02X", $val );
        if ($val == 27) {
            $got_esc = 1;
            prt("ESC key... Exiting...\n");
            return 1;
        } else {
            prt("Got keyboard input hex[$pmsg]...\n");
        }
    }
    return 0;
}

sub process_body_array($$$$$$);

sub process_body_array($$$$$$) {
    my ($URL,$ar,$rbody,$rh,$opts,$dep) = @_;
    my $rahrefs = get_a_href_text_array($ar,$opts);
    my ($item,$nurl,$ncont,$nbody,$ra,$rba,$i,$cnt,$txt,$val);
    my $dbg = ($opts & 0x8000);
    $cnt = scalar @{$rahrefs};
    for ($i = 0; $i < $cnt; $i++) {
        return 1 if ($got_esc);
        return 1 if (check_keyboard());
        $item = ${$rahrefs}[$i][0];
        $txt =  ${$rahrefs}[$i][1];
        $item = strip_quotes($item);
        if ($txt =~ /^\((.*)\)$/) {
            if (defined $1) {
                $val = $1;
            } else {
                $val = $txt;
            }
            # is an end VALUE only
            prt("Store property: $item [$val]\n") if ($dbg);
            ${$rh}{$item} = $val;
        } else {
            $nurl = $URL.$item;
            $ncont = get($nurl);
            prt("Get $nurl\n") if ($dbg);
            if (defined $ncont && length($ncont)) {
                #prt("$ncont\n");
                $ra = get_html_refarray($ncont);
                $rba = get_html_body_only($ra);
                $nbody = get_html_from_refarray($rba,$opts);
                #prt("$nbody\n");
                ${$rbody} .= $nbody;
                if (process_body_array($URL,$rba,$rbody,$rh,$opts,$dep+1)) {
                    return 1;
                }
            } else {
                prt("ERROR: Failed to get content!\n");
            }
        }
    }
    return 0;
}

sub process_body_array_simple($$$) {
    my ($URL,$ar,$rbody) = @_;
    my $rahrefs = get_a_href_array($ar,0x8000);
    my ($item,$nurl,$ncont,$nbody,$ra,$rba);
    foreach $item (@{$rahrefs}) {
        $nurl = $URL.strip_quotes($item);
        $ncont = get($nurl);
        prt("Get $nurl\n");
        if (defined $ncont && length($ncont)) {
            #prt("$ncont\n");
            $ra = get_html_refarray($ncont);
            $rba = get_html_body_only($ra);
            $nbody = get_html_from_refarray($rba,0);
            prt("$nbody\n");
            ${$rbody} .= $nbody;
        } else {
            prt("Failed to get content!\n");
        }
    }
}

sub process_input2($) {
    my $opts = shift;
    my $URL = "$HOST:$PORT";
    my $content = get($URL);
    my %hash = ();
    if (defined $content && length($content)) {
        my $ra = get_html_refarray($content);
        my $rba = get_html_body_only($ra);
        my $body = get_html_from_refarray($rba,$opts);
        #show_html_refarray($rba);
        #my $ar = get_whole_tag_array($rba,"a",0x8000);
        my $ar = get_whole_tag_array($rba,"a",$opts);
        #show_html_refarray($ar);
        #pgm_exit(1,"TEMP EXIT\n");
        ###process_body_array($URL,$ar,\$body);
        if (process_body_array($URL,$ar,\$body,\%hash,$opts,0)) {
            return \%hash;
        }
    } else {
        prt("ERROR: Failed to get content from [$URL]!\n");
    }
    prt("Done process_input2...\n");
    return \%hash;
}

sub process_input($) {
    my $opts = shift;
    my $URL = "$HOST:$PORT";
    my $content = get($URL);
    my %hash = ();
    if (defined $content && length($content)) {
        my $ra = get_html_refarray($content);
        my $rba = get_html_body_only($ra);
        my $body = get_html_from_refarray($rba,$opts);
        #show_html_refarray($rba);
        #my $ar = get_whole_tag_array($rba,"a",0x8000);
        my $ar = get_whole_tag_array($rba,"a",$opts);
        #show_html_refarray($ar);
        #pgm_exit(1,"TEMP EXIT\n");
        ###process_body_array($URL,$ar,\$body);
        if (process_body_array($URL,$ar,\$body,\%hash,$opts,0)) {
            return \%hash;
        }
        my ($key,$val,$cnt);
        if (!$show_all_text) {
            $body = '';
        }
        $body .= "\n<p><b>Full list of property tree values...</b></p>\n";
        $body .= "<table border=\"0\" width=\"100%\" cellspacing=\"2\" cellpadding=\"0\" summary=\"List of properties\">\n";
        $cnt = 0;
        foreach $key (sort keys %hash) {
            $cnt++;
            $val = $hash{$key};
            if ((length($val) == 0)||($val =~ /^\s+$/)) {
                $val = "&lt;blank&gt;";
            } else {
                $val = "<b>$val</b>";
            }
            $key =~ s/\%5B/\[/;
            $key =~ s/\%5D/\]/;
            $body .= "<tr><td>$cnt</td><td nowrap>$key</td><td>&nbsp;=&nbsp;</td><td>$val</td></tr>\n";
        }
        $body .= "</table>\n";
        $content = "<html>\n<head>\n<title>\nFull property list\n</title>\n</head>\n<body>\n";
        $content .= "<h1 align=\"center\">Full Property List - $cnt items</h1>\n";
        $content .= "<h2>httpd server: HOST=$HOST, PORT=$PORT</h2>\n";
        $content .= $body;
        $content .= "\n</body>\n</html>\n\n";
        write2file($content,$out_xml);
        prt("Written to $out_xml...\n");
    } else {
        prt("ERROR: Failed to get content from [$URL]!\n");
    }
    return \%hash;
}

sub compare_hashes($$) {
    my ($rh1,$rh2) = @_;
    my ($key1,$val1,$key2,$val2);
    foreach $key2 (sort keys %{$rh2}) {
        $val2 = ${$rh2}{$key2};
        if (!defined ${$rh1}{$key2}) {
            prt("New property [$key2] value [$val2]\n");
        } else {
            $val1 = ${$rh1}{$key2};
        }
        return 1 if (check_keyboard());
        return 1 if ($got_esc);
    }
    return 0;
}

sub repeat_until_esc($) {
    my $rh1 = shift;
    ReadMode('cbreak');    # set special key mode
    prt("Will continue until ESC key pressed...\n");
    while (1) {
        last if (check_keyboard());
        my $rh2 = process_input2(0);
        last if (compare_hashes($rh1,$rh2));
        $rh1 = $rh2;
    }
    ReadMode(0);    # restore normal keyboard mode
}

#########################################
### MAIN ###
parse_args(@ARGV);
my $hash_ref = process_input(0);
repeat_until_esc($hash_ref);
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] HOST PORT\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,$cnt);
    $cnt = 0;
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                $load_log = 1;
                prt("Set to load log at end.\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_xml = $sarg;
                prt("Set out file to [$out_xml].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            if ($cnt == 0) {
                $HOST = $arg;
                prt("Set HOST to [$HOST]\n");
            } elsif ($cnt == 1) {
                $PORT = $arg;
                prt("Set PORT to [$PORT]\n");
            } else {
                pgm_exit(1,"ERROR: Unknown argument [$arg]! Already have HOST $HOST, PORT $PORT\n");
            }
        }
        shift @av;
    }

    if ($debug_on) {
        $load_log = 1;
        if (length($HOST) == 0) {
            $HOST = $def_host;
            prt("Set DEFAULT HOST to [$HOST]\n");
        }
        if (length($PORT) == 0) {
            $PORT = $def_port;
            prt("Set DEFAULT PORT to [$PORT]\n");
        }
    }

    if (length($HOST) ==  0) {
        pgm_exit(1,"ERROR: No HOST found in command!\n");
    }
    if (length($PORT) ==  0) {
        pgm_exit(1,"ERROR: No PORT found in command!\n");
    }
}

# eof - template.pl
