#!perl -w
# #######################################################################################
# module: fgdsphdrs02.pl - Version 2 - see fgdsphdrs.pl for version 1
# header information, when building DSP files
#
# 20090819 - start to split header generation so additional options can be done
#
# 20090816 - Added ($dbg & 2) output of 'C_SOURCES' during check for duplicates
# NOTE: The $hash{'C_SOURCES'} = [ @c_sources ] is of the form push(@c_sources, [ $file, $group, $filter ]); Similar for 'H_SOURCES'...
# The 'default' group and filter are available through -
# my $sgrp = get_def_src_grp();    # "Source Files"; my $sflt = get_def_src_filt();
# my $hgrp = get_def_hdr_grp();    # "Header Files"; my $hflt = get_def_hdr_filt();
# The DEFAULT hash, sub get_default_sub { } returns a HASH with all the '-NEW_*' items set.
# To this MUST be added -
# $hash{'APP_TYPE'} = $app_statlib_stg, or one of the other strings setting APPLICATION TYPE
# and of course the above $hash{'C_SOURCES'} and 'H_SOURCES' before using sub write_hash_to_DSP2 {...}
#
# 10/11/2008 - Added /GR to compiler for each. Without this MSVC7 defaults to /GR-, which
# disables Runt-Time Type Info, which causes a BIG problem with OSG
#
# APP_TYPE
# $app_console_stg  = 'Console Application'  = get_dsp_head_console
# $app_windows_stg  = 'Application'          = get_dsp_head_app
# $app_dynalib_stg  = 'Dynamic-Link Library' = get_dsp_head_dynalib
# $app_statlib_stg  = 'Static Library'       = get_dsp_head_slib
# $app_utility_stg  = 'Utility'              = *TBD*
#
# substitution variables
# -NEW_PROJECT_NAME-    = name of the project   = MUST EXIST
# -NEW_OUTD_(REL|DBG)-  = PROP Output_Dir ????
# -NEW_INTER_(REL|DBG)- = PROP Intermediate_Dir ????
# ADD CPP with 
# -NEW_RT_(REL|DBG)-    = RUNTIME, like /MT /MD, /MTd, etc
# -NEW_INCS_(REL|DBG)-  = INCLUDE DIRECTORIES, like /I ".."
# -NEW_DEFS_(REL|DBG)-  = DEFINES, like /D "FGFS"
# ADD LINK32 (for console, app, DLL) with
# -NEW_LIBS_(REL|DBG)-  = Additional libraries for the link
# -NEW_OUT_(REL|DBG)-   = link output, like /out:"StaticRelease\libpng.lib
# -NEW_POST_(REL|DBG)-  = POST build - description and commands, TAB separated
# ADD LIB32 (for static library) with
# -NEW_OUT_(REL|DBG)-   =  OUTPUT static library
# #######################################################################################

# DEBUG ONLY - should be OFF
my $dbg_props = 0;

sub set_dbg_props { $dbg_props = 1; }

# like zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
#  // This is an internal type to Visual Studio, it seems that:
#  // 4 == static library
#  // 2 == dll
#  // 1 == executable
#  // 10 == utility
my $app_console_stg  = 'Console Application';
my $app_windows_stg  = 'Application';
my $app_dynalib_stg  = 'Dynamic-Link Library';
my $app_statlib_stg  = 'Static Library';
my $app_utility_stg  = 'Utility';

my %short_2_app_type = (
    'CA' => $app_console_stg,
    'WA' => $app_windows_stg,
    'DLL' => $app_dynalib_stg,
    'SL' => $app_statlib_stg
    );

sub get_app_type_4_short($$) {
    my ($st, $rs) = @_;
    if (defined $short_2_app_type{$st}) {
        ${$rs} = $short_2_app_type{$st};
        return 1;
    }
    return 0;
}

# "Win32 (x86) Dynamic-Link Library" 0x0102
sub get_app_type_stg($) {
    my ($stg) = shift;
    if ($stg =~ /Static\s+Library/) {
        return $app_statlib_stg;
    } elsif ($stg =~ /Console\s+Application/) {
        return $app_console_stg;
    } elsif ($stg =~ /Dynamic-Link\s+Library/) {
        return $app_dynalib_stg;
    }
    return "Unresolved [$stg] FIXME in fgdsphdrs02.pl!!!";
}

sub strip_quotes_02($) {
	my ($ln) = shift;
	if ($ln =~ /^".*"$/) {
		$ln = substr($ln,1,length($ln)-2);
	}
	return $ln;
}

sub dos_2_unix_02($) {
	my ($du) = shift;
	$du =~ s/\\/\//g;
	return $du;
}


sub scan_DSP_lines {
	my ($df,$mhr,$rdlns) = @_;
	my $lncnt = scalar @{$rdlns};
	my @dspsrcs = ();
    my $projname = '';
    my $projtype = '';
    my $group = '';
    my $filter = '';
    my ($tmp, $key);
    my %dsp_hash = ();
    my $hr = \%dsp_hash;
    my @c_sources = ();
    my @h_sources = ();
    prt( "Scanning $lncnt lines, from [$df]...\n" );
	###prt( "File contains $lncnt lines ...\n" );
    # push(@c_sources,[$src, $group, $filter, 0]);
	foreach $line (@{$rdlns}) {
		chomp $line;
        if ($line =~ /^#\s+Microsoft\s+Developer\s+Studio\s+.+Name="(\w+)".+$/) {
            $projname = $1;
            prt( "Project Name [$projname]\n" );
            # -NEW_PROJECT_NAME-"   = name of the project
            $key = '-NEW_PROJECT_NAME-';
            ${$hr}{$key} = $projname;
        } elsif ($line =~ /^#\s+TARGTYPE\s+(.*)/) {
            $tmp = $1;
			#prt( "# TARGTYPE $1\n" );
            $projtype = get_app_type_stg($tmp);
            prt( "Project Type [$projtype]\n" );
            $key = 'APP_TYPE';
            ${$hr}{$key} = $projtype;
	    } elsif ( $line =~ /^#\s+Begin\s+Group\s+(.*)/ ) {
            $group = strip_quotes_02($1);
			prt( "Begin Group  [$group]\n" );
        } elsif ( $line =~ /^#\s+PROP\s+Default_Filter\s+"(.*)".*$/ ) {
            $filter = $1;
            prt( "Filter       [$filter]\n" );
		} elsif ( $line =~ /^SOURCE=/ ) {
			$line =~ s/^SOURCE=//o;
			while ($line =~ /\W$/) { # ending in NON-alphanumic
				####prt( "Discarding [".substr($line,-1,1)."]!\n" );
				$line = substr($line,0,length($line)-1);
			}
			##while (( substr($line,-1,1) eq ' ' )||( substr($line,-1,1) eq "\t")||
			##	( substr($line,-1,1) eq "\r")||( substr($line,-1,1) eq "\n")) {
			##	$line = substr($line,0,length($line)-1);
			##}
			$line =~ s/^\"//; # remove leading inverted commas
			$line =~ s/\"$//; # remove trailing inverted commas
			$line = dos_to_unix_02($line);
			$line =~ s/^\.\///;
			if (($line =~ /\.cxx$/i) || ($line =~ /\.c$/i) || ($line =~ /\.cpp$/i) || ($line =~ /\.cc$/i)) {
				push(@dspsrcs, $line);
                push(@c_sources, [$line, $group, $filter]);
			} elsif ( ($line =~ /\.hxx$/i) || ($line =~ /\.h$/i) || ($line =~ /\.hpp$/i) ) {
				push(@dspsrcs, $line);
                push(@h_sources, [$line, $group, $filter]);
            } else {
                if ( !($line =~ /^\$\(/) ) {
                    prt( "CHECK Discarded [$line]\n" );
				}
			}
		}
	}
    $key = 'C_SOURCES';
    ${$hr}{$key} = [@c_sources];
    $key = 'H_SOURCES';
    ${$hr}{$key} = [@h_sources];
    $key = $projname;
    ${$mhr}{$key} = $hr;
	$lncnt = scalar @dspsrcs;
	prt( "File [$df] contains $lncnt SOURCES ...\n" );
	return \@dspsrcs;
}


sub process_DSP_file($$) {
    my ($df,$rmh) = @_;
    if (open(INF, "<$df")) {
        my @lns = <INF>;
        close INF;
        my $lncnt = scalar @lns;
        my $rdsrcs = scan_DSP_lines($df,$rmh,\@lns);
    } else {
        prtw("WARNING:scan_DSP_file: Unable to OPEN [$df]!\n");
    }
}

# Windows Console Application
# ===========================
sub get_dsp_head_console {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Console Application" 0x0103

CFG=-NEW_PROJECT_NAME- - Win32 Release
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Console Application")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Console Application")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir ".\\Release"
# PROP BASE Intermediate_Dir ".\\Release"
# PROP BASE Target_Dir "."
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir "."
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /YX /c
# ADD CPP /nologo -NEW_RT_REL- /W3 /GR /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_CONSOLE" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:console /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /subsystem:console /machine:I386 -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir ".\\Debug"
# PROP BASE Intermediate_Dir ".\\Debug"
# PROP BASE Target_Dir "."
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir "."
# ADD BASE CPP /nologo /W3 /Gm /GX /Zi /Od /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /YX /c
# ADD CPP /nologo -NEW_RT_DBG- /W3 /Gm /GR /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_CONSOLE" -NEW_DEFS_DBG- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:console /debug /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /subsystem:console /debug /machine:I386 -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Application
# ===========================
sub get_dsp_head_app {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Application" 0x0101

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Application")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Application")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
MTL=midl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /c
# ADD CPP /nologo /W3 -NEW_RT_REL- /GR /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /subsystem:windows /machine:I386 -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /GZ /c
# ADD CPP /nologo /W3 -NEW_RT_DBG- /Gm /GR /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" -NEW_DEFS_DBG- /FD /GZ /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Static Library
# ===========================
sub get_dsp_head_slib {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Static Library" 0x0104

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Static Library")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Static Library")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" /YX /FD /c
# ADD CPP /nologo /W3 /GR /GX /O2 -NEW_RT_REL- -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" /YX /FD /GZ /c
# ADD CPP /nologo /W3 /Gm /GR /GX /ZI /Od -NEW_RT_DBG- -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_DBG- /FD /GZ /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

sub get_dsp_head_static_MD {
	my $msg = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Static Library" 0x0104

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Static Library")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Static Library")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" /YX /FD /c
# ADD CPP /nologo /MD /W3 /GR /GX /O2 -NEW_RT_REL- -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" /YX /FD /GZ /c
# ADD CPP /nologo /MDd /W3 /Gm /GR /GX /ZI /Od -NEW_RT_DBG- -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_DBG- /FD /GZ /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $msg;
}

# Windows Dynamic Library
# ===========================
sub get_dsp_head_dynalib {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Dynamic-Link Library" 0x0102

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Dynamic-Link Library")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Dynamic-Link Library")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
MTL=midl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" /Yu"stdafx.h" /FD /c
# ADD CPP /nologo -NEW_RT_REL- /W3 /GR /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /dll /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /dll /machine:I386 -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" /Yu"stdafx.h" /FD /GZ  /c
# ADD CPP /nologo -NEW_RT_DBG- /W3 /Gm /GR /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" -NEW_DEFS_DBG- /FD /GZ  /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /dll /debug /machine:I386 /pdbtype:sept
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /dll /debug /machine:I386 /pdbtype:sept -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

    return $dsp_head;
}


sub get_dsp_tail {
	my $dsp_tail = <<EOF;
# End Target
# End Project
EOF

	return $dsp_tail;
}

sub get_dsw_head {
	### default DSW
	my $raw_dswh = <<EOF;
Microsoft Developer Studio Workspace File, Format Version 6.00
# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!

EOF
	return $raw_dswh;
}


sub get_dsw_tail {
	my $raw_dswt = <<EOF;
###############################################################################

Global:

Package=<5>
{{{
}}}

Package=<3>
{{{
}}}

###############################################################################

EOF
	return $raw_dswt;
}


sub get_default_sub {
    my %def_sub = (
    "APP_TYPE"           => "Static Library",
    "-NEW_PROJECT_NAME-" => "fgfs",
    "-NEW_RT_REL-"       => "/MT",
    "-NEW_RT_DBG-"       => "/MTd",
    "-NEW_DEFS_REL-"     => "/D \"FGFS\" /D \"_CRT_SECURE_NO_WARNINGS\"",
    "-NEW_DEFS_DBG-"     => "/D \"FGFS\" /D \"_CRT_SECURE_NO_WARNINGS\"",
    "-NEW_LIBS_DBG-"     => "Winmm.lib ws2_32.lib",
    "-NEW_LIBS_REL-"     => "Winmm.lib ws2_32.lib",
    "-NEW_POST_DBG-"     => "",
    "-NEW_POST_REL-"     => "",
    "-NEW_INCS_DBG-"     => "",
    "-NEW_INCS_REL-"     => "",
    "-NEW_OUTD_DBG-"     => "\"Debug\"",
    "-NEW_OUTD_REL-"     => "\"Release\"",
    "-NEW_INTER_DBG-"    => "\"Debug\"",
    "-NEW_INTER_REL-"    => "\"Release\"",
    "-NEW_OUT_DBG-"      => "",
    "-NEW_OUT_REL-"      => ""
    );

    return %def_sub;
}

# 20090828 - return a REFERENCE
sub get_default_sub2() {
   my %h = get_default_sub();
   return \%h;
}

# Windows Console Application === sub get_dsp_head_console
# Windows Application         === sub get_dsp_head_app
# Windows Static Library      === sub get_dsp_head_slib
# Windows Dynamic Library     === sub get_dsp_head_dynalib
# $isok = get_dsp_header_text( \$msg, $val );
sub get_dsp_header_text {
    my ($rm, $v) = @_;
    my $iok = 1;
    my %dht = (
        $app_console_stg => \&get_dsp_head_console,
        $app_windows_stg => \&get_dsp_head_app,
        $app_statlib_stg => \&get_dsp_head_slib,
        $app_dynalib_stg => \&get_dsp_head_dynalib
    );
    if (defined $dht{$v}) {
            my $val = $dht{$v};
            $$rm = $val->();
    } else {
        prtw( "WARNING: No application type [$v] in hash ...\n" );
        $iok = 0;
    }
    return $iok;
}

my $def_runtime_lts = "MD";
my $def_runtime_stg = "Multithreaded DLL";
my $def_runtime_val = 2;
#    0                  1     2                         3  4
my @fg_runtimes_array = (
    ["RuntimeLibrary", "MT",  "Multithreaded",           0, 0],
    ["RuntimeLibrary", "MTd", "Multithreaded Debug",     1, 0],
    ["RuntimeLibrary", $def_runtime_lts, $def_runtime_stg, $def_runtime_val, 0],
    ["RuntimeLibrary", "MDd", "Multithreaded DLL Debug", 3, 0],
    ["RuntimeLibrary", "ML",  "Single Thread",           4, 0],
    ["RuntimeLibrary", "MLd", "Single Thread Debug",     5, 0]
);

sub fg_get_runtime_val_2_lts {
	my ($rtn) = shift;
    my $len = scalar @fg_runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $fg_runtimes_array[$i][3];
        if ($itm == $rtn) {
            return "/" . $fg_runtimes_array[$i][1];
        }
    }
    prtw( "WARNING: $rtn not found in runtimes array! Using default '$def_runtime_lts'!!\n" );
	return "/$def_runtime_lts";
}

sub get_app_conf_type {
    my ($ct) = shift;
    # per <Configuration ... ConfigurationType="4" ...
    my %vc_cts = (
        1  => $app_windows_stg,
        2  => $app_dynalib_stg,
        4  => $app_statlib_stg,
        10 => $app_utility_stg );
    my $at = '';
    if (defined $vc_cts{$ct}) {
        $at = $vc_cts{$ct};
    } else {
        prtw( "WARNING: Failed to FIND '$ct' in v8_conftypes!\n" );
        mydie( "ABORTING, in disgust ;=))\n" );
    }
    return $at;
}

# $apptype = adjust_app_type_per_subsystem( $apptype, $adddeps );
sub adjust_app_type_per_subsystem {
    my ($capt,$ss,$dbg) = @_;
    # and if 1 ($app_windows), then per SubSystem
    # <Tool Name="VCLinkerTool" ... SubSystem="2"
    # SubSystem="1" = :console or "2" = :window
    my %vc_ss = (
        1 => $app_console_stg,
        2 => $app_windows_stg );
    if (defined $vc_ss{$ss}) {
        my $napt = $vc_ss{$ss};
        if ($capt eq $napt) {
            prt("Got APPTYPE: NO CHANGE [$capt] equals SubSystem ($ss) [$napt] ...\n" ) if ($dbg);
        } else {
            if ($capt eq $app_dynalib_stg) {
                if ($napt eq $app_windows_stg) {
                    # these are NOT incompatible, so NO CHANGE
                    prt("Got APPTYPE: NO CHANGE [$capt] EQUIVALENT to $ss ($napt) ...\n" ) if ($dbg);
                } else {
                    prtw("WARNING: NO CHANGE but [$capt] NOT EQUIVALENT to $ss ($napt) ...\n" );
                }
            } else {
                prt("Set APPTYPE: from [$capt], to [$napt] ($ss).\n" ) if ($dbg);
                $capt = $napt;
            }
        }
    }
    return $capt;
}

# function: get_balance_of_line_bump_offset
# parameters passed:
# $rt = reference to counter
# $tx = balance of file string
sub get_balance_of_line_bump_offset {
    my ($rt,$tx) = @_;
    my $ln = length($tx);
    my $ba = '';
    for (my $k = 0; $k < $ln; $k++) {
        my $ch = substr($tx,$k,1);
        if ($ch eq "\n") {
            $$rt++;
            return $ba;
        }
        $ba .= $ch;
        $$rt++;
    }
    return $ba;
}

sub get_if_props {
    my ($txt) = shift;
    my @lns = split("\n",$txt);
    my $len = scalar @lns;
    my ($t, $ln, $iln, $idir);
    my $props = '';
    my $pr = '#\\s+PROP\\s+Intermediate_Dir\\s+"(.+)".*';
    for ($t = 0; $t < $len; $t++) {
        $ln = $lns[$t];
        chomp $ln;
        if ($ln =~ /\!MESSAGE\s+/) {
           # ignore this
        } elsif ($ln =~ /\!IF\s+/) {
            $iln = $ln;
            prtw("WARNING:$t: NOT FIRST FOUND [$ln]\n") if length($props);
            $props = "\n$ln\n\n";
            prt( "LINE $t: [$ln]\n" ) if ($dbg_props);
            $t++;
            for ( ; $t < $len; $t++) {
                $ln = $lns[$t];
                chomp $ln;
                ##if ($ln =~ /#\s+PROP\s+Intermediate_Dir\s+"(.+)".*/) {
                if ($ln =~ /$pr/) {
                    $idir = $1;
                    $idir .= "\\Dupes";
                    $ln =~ s/$1/$idir/;
                    $props .= $ln."\n\n";
                    $t++;
                    prt( "ID $t = [$ln]\n" ) if ($dbg_props);
                    last;
                }
            }
        } elsif ($ln =~ /\!ELSEIF\s+/) {
            $props .= "$ln\n\n";
            prt( "LINE $t: [$ln]\n" ) if ($dbg_props);
            $t++;
            for ( ; $t < $len; $t++) {
                $ln = $lns[$t];
                chomp $ln;
                ###if ($ln =~ /#\s+PROP\s+Intermediate_Dir\s+"(.+)".*/) {
                if ($ln =~ /$pr/) {
                    $idir = $1;
                    $idir .= "\\Dupes";
                    $ln =~ s/$1/$idir/;
                    $props .= $ln."\n\n";
                    $t++;
                    prt( "ID $t = [$ln]\n" ) if ($dbg_props);
                    last;
                }
            }
        } elsif ($ln =~ /\!ENDIF\s+/) {
            $props .= "$ln\n\n";
            prt( "LINE $t: [$ln]\n" ) if ($dbg_props);
        }
    }
    return $props;
}

sub add_dotrel_if_none {
    my ($fl) = shift;
    $fl = ".\\".$fl if !($fl =~ /^\./);
    return $fl;
}

# 20090910 - this version expects SOURCE file array to be in form 
#           0       1      2      3
#push(@cs, [$sfile, $sgrp, $sflt, $hm] );
# if $hm is 1, then '# PROP Exclude_From_Build 1' is added after source
sub write_hash_to_DSP2 {
    my ($of, $rh, $dbg) = @_; # say ('tempvcscan.dsp', \%h, 0);
    my ($val, $msg, $key, $cnt, $srcs, $captyp, $capname);
    my $isok = 1;
    my ($fnam, $ftyp, $i, $fil);
    my ($dupes, $nm, $dr, $ext, @dups, $props);
    my ($hm, $hm_msg, $tmp, $tmp2); # added 20090910
    my %dsrc = ();
    my $def_src_group = 'Source Files'; # added 20090915
    my $def_hdr_group = 'Header Files'; # added 20090915
    my $def_oth_group = 'Other Files'; # added 20090915
    my $src_group = '';
    my $hdr_group = '';
    my $oth_group = '';
    $msg = '';
    $key = '-NEW_PROJECT_NAME-';
    if (defined ${$rh}{$key}) {
        $capname = ${$rh}{$key};
    } else {
        prtw( "WARNING:write_hash_to_DSP2: No project NAME in hash... key=[$key]\n" );
        $isok = 0;
    }
    $key = 'APP_TYPE';
    if (defined ${$rh}{$key}) {
        $captyp = ${$rh}{$key};
        $isok = get_dsp_header_text( \$msg, $captyp );
    } else {
        prtw( "WARNING:write_hash_to_DSP2: No application type in hash ... key=[$key]\n" );
        $isok = 0;
    }
    $key = 'C_SOURCES';
    if (defined ${$rh}{$key}) {
        $srcs = ${$rh}{$key}; # = [@vc_c_sources];
        $cnt = scalar @{$srcs};
        if ($cnt == 0) {
            prtw( "WARNING:write_hash_to_DSP2: No source files in hash ... key=[$key]\n" );
            $isok = 0;
        } else {
            my $rsa = ${$srcs}[0];
            $cnt = scalar @{$rsa};
            if ($cnt < 4) {
                prtw( "WARNING:write_hash_to_DSP2: (ref) Array of a source NOT enough depth (have $cnt, should be 4, or more ...\n" );
                $isok = 0;
            }
        }
    } else {
        prtw( "WARNING:write_hash_to_DSP2: No SOURCES in hash ... key=[$key]\n" );
        $isok = 0;
    }

    ############################################
    ### ABORT IF NOT OK ###
    #######################
    if (! $isok) {
        # 2009/09/22 - since already generated a WARNING on teh problem, this should only be ADVICE
        prt( "ADVICE:write_hash_to_DSP2: No DSP written... for reason shown...\n" );
        return 0;
    }
    ############################################

    # do the SUBSTITUTIONS
    ################################
    # NOTE: $msg contains the DSP HEADER information
    foreach $key (keys %{$rh}) {
        if ($key =~ /^-NEW_/) {
            $val = $$rh{$key};
            if ($msg =~ /$key/) {
                $msg =~ s/$key/$val/g;
                prt( "Subbed $key with [$val]\n" ) if ($dbg & 8);
            } else {
                # NOT FOUND, but may be OK ...
                if (($captyp eq 'Static Library')&&($key =~ /^-NEW_LIBS_(REL|DBG)-$/)) {
                    # this is NOT expected in template == is OK
                } else {
                    prtw("WARNING: No [$key] found for [$val] SUBSTITUTION!\n");
                }
            }
        }
    }
    ###############################################
    # scan for DUPLICATE - need SPECIAL treatment
    ###############################################
    $key = 'C_SOURCES';
    $srcs = ${$rh}{$key}; # = [@vc_c_sources];
    $cnt = scalar @{$srcs};
    $dupes = 0;
    @dups = ();
    %dsrc = ();
    $tmp = '';
    for ($i = 0; $i < $cnt; $i++) {
        $fil  = ${$srcs}[$i][0];  # extract C SOURCE file
        $fnam = ${$srcs}[$i][1];  # extract 'folder' (group) name
        $ftyp = ${$srcs}[$i][2];  # its FILTER STRING
        $hm   = ${$srcs}[$i][3];  # and if it has 'main'
		prt( "CS: [$fil]\n" ) if ($dbg & 2);
        ($nm,$dr,$ext) = fileparse( $fil, qr/\.[^.]*/ );
        $nm = lc($nm);
        if (is_c_source($fil)) {
            if (defined $dsrc{$nm}) {
                $dupes++;
                push(@dups,$fil);
            } else {
                $dsrc{$nm} = 1;
            }
            if (length($tmp) == 0) {
                $tmp = $fnam;
            } elsif (length($src_group) == 0) {
                if ( $tmp ne $fnam ) {
                    $src_group = $def_src_group;
                    prt("NOTE: Due to multiple source GROUPS, like [$tmp] and [$fnam], using DEFAULT [$src_group]!\n");
                }
            }
        }
    }

    # scan through HEADER sources
    $key = 'H_SOURCES';
    $srcs = ${$rh}{$key}; # = [@vc_c_sources];
    $cnt = scalar @{$srcs};
    $tmp2 = '';
    for ($i = 0; $i < $cnt; $i++) {
        $fil  = ${$srcs}[$i][0];  # extract C SOURCE file
        $fnam = ${$srcs}[$i][1];  # extract 'folder' (group) name
        $ftyp = ${$srcs}[$i][2];  # its FILTER STRING
        $hm   = ${$srcs}[$i][3];  # and if it has 'main'
		prt( "HS: [$fil]\n" ) if ($dbg & 2);
        ($nm,$dr,$ext) = fileparse( $fil, qr/\.[^.]*/ );
        $nm = lc($nm);
        if (is_h_source($fil)) {
            if (length($tmp2) == 0) {
                $tmp2 = $fnam;
            } elsif (length($hdr_group) == 0) {
                if ($tmp2 ne $fnam) {
                    $hdr_group = $def_hdr_group;
                    prt("NOTE: Due to multiple header GROUPS, like [$tmp2] and [$fnam], using DEFAULT [$hdr_group]!\n");
                }
            }
        }
    }

    $props = '';
    if (@dups) {
        # we have one or more duplicates
        $props = get_if_props($msg);
        prt("NOTE: Adding PROP, due to duplicates!\n[$props] CHECHME!\n");
    }

    # OUTPUT THE SOURCES

    # First the C/C++ files
    $key = 'C_SOURCES';
    $srcs = ${$rh}{$key}; # = [@vc_c_sources];
    $cnt = scalar @{$srcs};
    $fnam = $$srcs[0][1];   # extract FIRST 'folder' (group) name,
    $fnam = $src_group if (length($src_group)); # 20090915 - override with 'Source Files', if MULTIPLE groups
    $ftyp = $$srcs[0][2];   # its FILTER STRING
    $hm   = $$srcs[0][3];   # and if it has 'main'
    if ($cnt) {
        $msg .= '# Begin Group "'.$fnam."\"\n";
        $msg .= "\n";
        $msg .= '# PROP Default_Filter "'.$ftyp."\"\n";
        for ($i = 0; $i < $cnt; $i++) {
            $fil = $$srcs[$i][0];
            $hm  = $$srcs[$i][3]; # and if it has 'main'
            $nm = lc($nm);
            $msg .= "# Begin Source File\n";
            $msg .= "\n";
            ###$msg .= "SOURCE=$fil\n";
            $msg .= "SOURCE=".add_dotrel_if_none($fil)."\n";
            $msg .= "# PROP Exclude_From_Build 1\n" if $hm;
            if ( length($props) && is_in_array($fil,@dups) ) {
                prt( "Added DUPE props for $fil ...\n" ) if ($dbg_props);
                $msg .= $props;
            }
            $msg .= "# End Source File\n";
        }
        $msg .= "# End Group\n";
    }

    # OUTPUT THE HEADERS
    $key = 'H_SOURCES';
    $cnt = 0;
    if (defined ${$rh}{$key}) {
        $srcs = ${$rh}{$key}; # = [@vc_h_sources];
        $cnt = scalar @{$srcs};
        $fnam = $$srcs[0][1];
        $fnam = $hdr_group if (length($hdr_group)); # 20090915 - override with 'Header Files', if MULTIPLE groups
        $ftyp = $$srcs[0][2];
    }
    if ($cnt) {
        $msg .= '# Begin Group "'.$fnam."\"\n";
        $msg .= "\n";
        $msg .= '# PROP Default_Filter "'.$ftyp."\"\n";
        for ($i = 0; $i < $cnt; $i++) {
            $fil = $$srcs[$i][0];
            $hm  = $$srcs[$i][3];
            $msg .= "# Begin Source File\n";
            $msg .= "\n";
            $msg .= "SOURCE=".add_dotrel_if_none($fil)."\n";
            $msg .= "# PROP Exclude_From_Build 1\n" if $hm;
            $msg .= "# End Source File\n";
        }
        $msg .= "# End Group\n";
    } else {
        prt("Note: There appears to be NO header files...\n");
    }
    
	$msg .= get_dsp_tail();

    rename_2_old_bak($of);

    write2file($msg,$of);

    prt( "Written [$of] file ...\n" );

    return 1;

}

sub get_proj_begin {
	my ($prj, $fil) = @_;
	my $ret = <<EOF;
###############################################################################

Project: "$prj"=".\\$fil" - Package Owner=<4>

Package=<5>
{{{
}}}

Package=<4>
{{{
EOF
	return $ret;
}

sub get_proj_end {
	my $ret = <<EOF;
}}}

EOF
	return $ret;
}

# ===============================================
# passed an output DSW file, and
# a array reference push(@arr, project, dsp_file)
# ===============================================
sub write_proj_DSW {
	my ($of, $projs) = @_;
	my $msg = get_dsw_head();
	my ($i, $pcnt, $prj);
	$pcnt = scalar @{$projs};
	# process the projects
	for ($i = 0; $i < $pcnt; $i++) {
		$prj = $$projs[$i][0];
		$fil = $$projs[$i][1];
		$msg .= get_proj_begin( $prj, $fil );
		# add any DEPENDENCIES NOW
		# fg_add_proj_depends( $DSW, $prj, $ref_deps );
		$msg .= get_proj_end();
	}

	$msg .= get_dsw_tail();

    rename_2_old_bak($of);

    write2file($msg,$of);

    prt( "Written [$of] file ...\n" );

}


1;
# eof - fgdsphdrs.pl