#!perl -w
# NAME: fgscanvc03.pl
# 2009/10/26 - moved some functions out to lib utility - fgutils02.pl
# 2009/10/15 - try to take account of an inheritted property sheet
# like <Configurations><Configuration Name="ReleaseNASM|Win32" ConfigurationType="4"
# InheritedPropertySheets=".\vc9_lame_config.vsprops;.\arch_nasm.vsprops" UseOfMFC="0" ATLMinimizesCRunTimeLibraryUsage="false" >
# 20090912 - in show_hash_results(), output the TYPE of build
# 20090819 - moved on from version 1, to this version 2
# 20090808 - Added substitution of -
# 1: $adddeps =~ s/\$\(ProjectName\)/$projname/;
# 2: $adddeps =~ s/\$\(SolutionDir\)//; $adddeps =~ s/\$\(ConfigurationName\)/$confname/; x2
# 2009/06/05 - Add (dbg) output of 'OutputFile', and added decode of 'VCLibrarianTool'
# 05/10/2008 - Part of a series of Perl scripts to compare and show changes
# in the build files of FlightGear and SimGear
# 05/10/2008 - specialised SCAN of VCPROJ file
# 05/12/2008 geoff mclane http://geoffair.net/mperl - further refinements

# DEBUG
my $dbg_v01 = 0;    # show each line - prt( "$lnnum:$xln:".scalar @tag_stack.": $tag [$line]
my $dbg_v02 = 0;    # show prt( "$lnnum:$xln: tag=$tag, Name=$pname
my $dbg_v03 = 0;    # show sources - prt( "$lnnum:$xln: [$adddefs] $tmp source
my $dbg_v04 = 0;    # show prt( "$lnnum:$xln: processing inconfig '$conf' '$pname' [$line]
my $dbg_v05 = 0;    # show prt("$lnnum:$xln: Set APPTYPE:$conf: from $apptype, to $ppdefs - CHECK!
my $dbg_v06 = 0;    # show prt("$lnnum:$xln: Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...
my $dbg_v07 = 0;    # show prt( "$lnnum:$xln: Entering Configurations [$line] and EXIT
my $dbg_v08 = 0;    # show prt( "$lnnum:$xln: Entering Configuration [$conf]... [$line] and EXIT
my $dbg_v09 = 0;    # show prt( "$lnnum:$xln: Entering Files [$line] and EXIT
my $dbg_v10 = 0;    # show prt( "$lnnum:$xln: 'VCCLCompilerTool' [$line]
my $dbg_v11 = 0;    # show prt( "$lnnum:$xln: ENTER Filter name=[$fname] list=[$flist]
my $dbg_v12 = 0;    # show prt( "$lnnum:$xln: Entering FileConfiguration [$line]
my $dbg_v13 = 0;    # show prt( "ADVICE:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(1) '$seek' [$line]
my $dbg_v14 = 0;    # show prt( "$lnnum:$xln: last = $last_src [".$$src_ref[-1][0]."] $fconf $seek = $adddefs
my $dbg_v15 = 0;    # show prt( "$lnnum:$xln: got POST event [$ppdefs]
my $dbg_v16 = 0;    # for AdditionalDependencies and 'AdditionalLibraryDirectories'
#  show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(4) & (6) '$seek' [$line]
my $dbg_v17 = 0;    # show prtw( "WARNING: $lnnum:$xln: DOES NOT CONTAIN(12) '$seek'? [$line]\n"
my $dbg_v18 = 0;    # show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(7) '$seek' [$line]
my $dbg_v19 = 0;    # show prt( "$lnnum:$xln: Changed(1) $seek from [".$dsp_current_sub{$var1}."] to [$adddeps]
my $dbg_v20 = 0;    # show prt( "$lnnum:$xln: Changed(2) $seek from [".$dsp_current_sub{$var2}."] to [$adddeps]
my $dbg_v21 = 0;    # show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(5) '$seek' [$line] and others
my $dbg_v22 = 0;    # show prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$adddeps]
my $dbg_v23 = 0;    # show prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$tmp]\n from [$adddeps]
my $dbg_v24 = 0;    # show prt( "$lnnum:$xln: seek=$seek: Set [$var2] to [$adddeps]\n" ) if ($dbg_v24);
my $dbg_v25 = 0;	# show prt( "$lnnum:$xln: VCCLCompilerTool:$seek: set [$var1] to ".$dsp_current_sub{$var1}."\n" ) if ($dbg_v25);
my $dbg_v26 = 0;    # prt( "[dbg_v26] Processing prop file(s) [$fils] cnt=$cnt\n" ) if ($dbg_v26);
my $dbg_v27 = 0;    # prt( "[dbg_v27] $lnnum:$xln: got CUSTOM event [$ppdefs] [$tmp]\n" ) if ($dbg_v27);
my $dbg_v28 = 0;    # prt( "[dbg_v28] $lnnum:$xln:$tag: Exit     Filter::File [$line]\n" ) if ($dbg_v28);
my $dbg_v29 = 0;    # prt( "[dbg_v29] Pushed [$last_src] into source reference - position $last_fpos\n" ) if ($dbg_v29);
my $dbg_v30 = 0;    # prt("[dbg_v30] NOTE:$pnam: Have $cnt items to add! ($cnt2-$cnt3) $tmp\n") if ($dbg_v30); and MORE

sub dbg_show_entering_files { $dbg_v09 = 1; }
sub dbg_show_source_files { $dbg_v03 = 1; }
sub dbg_show_output_files { $dbg_v21 = 1; $dbg_v24 = 1; }
sub dbg_set_all_scan_debug {
   $dbg_v01 = 1;    # show each line - prt( "$lnnum:$xln:".scalar @tag_stack.": $tag [$line]
   $dbg_v02 = 1;    # show prt( "$lnnum:$xln: tag=$tag, Name=$pname
   $dbg_v03 = 1;    # show sources - prt( "$lnnum:$xln: [$adddefs] $tmp source
   $dbg_v04 = 1;    # show prt( "$lnnum:$xln: processing inconfig '$conf' '$pname' [$line]
   $dbg_v05 = 1;    # show prt("$lnnum:$xln: Set APPTYPE:$conf: from $apptype, to $ppdefs - CHECK!
   $dbg_v06 = 1;    # show prt("$lnnum:$xln: Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...
   $dbg_v07 = 1;    # show prt( "$lnnum:$xln: Entering Configurations [$line] and EXIT
   $dbg_v08 = 1;    # show prt( "$lnnum:$xln: Entering Configuration [$conf]... [$line] and EXIT
   $dbg_v09 = 1;    # show prt( "$lnnum:$xln: Entering Files [$line] and EXIT
   $dbg_v10 = 1;    # show prt( "$lnnum:$xln: 'VCCLCompilerTool' [$line]
   $dbg_v11 = 1;    # show prt( "$lnnum:$xln: ENTER Filter name=[$fname] list=[$flist]
   $dbg_v12 = 1;    # show prt( "$lnnum:$xln: Entering FileConfiguration [$line]
   $dbg_v13 = 1;    # show prt( "ADVICE:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(1) '$seek' [$line]
   $dbg_v14 = 1;    # show prt( "$lnnum:$xln: last = $last_src [".$$src_ref[-1][0]."] $fconf $seek = $adddefs
   $dbg_v15 = 1;    # show prt( "$lnnum:$xln: got POST event [$ppdefs]
   $dbg_v16 = 1;    # for AdditionalDependencies and 'AdditionalLibraryDirectories'
#  show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(4) & (6) '$seek' [$line]
   $dbg_v17 = 1;    # show prtw( "WARNING: $lnnum:$xln: DOES NOT CONTAIN(12) '$seek'? [$line]\n"
   $dbg_v18 = 1;    # show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(7) '$seek' [$line]
   $dbg_v19 = 1;    # show prt( "$lnnum:$xln: Changed(1) $seek from [".$dsp_current_sub{$var1}."] to [$adddeps]
   $dbg_v20 = 1;    # show prt( "$lnnum:$xln: Changed(2) $seek from [".$dsp_current_sub{$var2}."] to [$adddeps]
   $dbg_v21 = 1;    # show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(5) '$seek' [$line]
   $dbg_v22 = 1;    # show prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$adddeps]
   $dbg_v23 = 1;    # show prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$tmp]\n from [$adddeps]
   $dbg_v24 = 1;    # show prt( "$lnnum:$xln: seek=$seek: Set [$var2] to [$adddeps]\n" ) if ($dbg_v24);
}
sub svc_get_dbg_stg() {
    my $dbs = '';
    if ($dbg_v01) { $dbs .= "v01 "; } # show each line - prt( "$lnnum:$xln:".scalar @tag_stack.": $tag [$line]
    if ($dbg_v02) { $dbs .= "v02 "; } # show prt( "$lnnum:$xln: tag=$tag, Name=$pname
    if ($dbg_v03) { $dbs .= "v03 "; } # show sources - prt( "$lnnum:$xln: [$adddefs] $tmp source
    if ($dbg_v04) { $dbs .= "v04 "; } # show prt( "$lnnum:$xln: processing inconfig '$conf' '$pname' [$line]
    if ($dbg_v05) { $dbs .= "v05 "; } # show prt("$lnnum:$xln: Set APPTYPE:$conf: from $apptype, to $ppdefs - CHECK!
    if ($dbg_v06) { $dbs .= "v06 "; } # show prt("$lnnum:$xln: Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...
    if ($dbg_v07) { $dbs .= "v07 "; } # show prt( "$lnnum:$xln: Entering Configurations [$line] and EXIT
    if ($dbg_v08) { $dbs .= "v08 "; } # show prt( "$lnnum:$xln: Entering Configuration [$conf]... [$line] and EXIT
    if ($dbg_v09) { $dbs .= "v09 "; } # show prt( "$lnnum:$xln: Entering Files [$line] and EXIT
    if ($dbg_v10) { $dbs .= "v10 "; } # show prt( "$lnnum:$xln: 'VCCLCompilerTool' [$line]
    if ($dbg_v11) { $dbs .= "v11 "; } # show prt( "$lnnum:$xln: ENTER Filter name=[$fname] list=[$flist]
    if ($dbg_v12) { $dbs .= "v12 "; } # show prt( "$lnnum:$xln: Entering FileConfiguration [$line]
    if ($dbg_v13) { $dbs .= "v13 "; } # show prt( "ADVICE:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(1) '$seek' [$line]
    if ($dbg_v14) { $dbs .= "v14 "; } # show prt( "$lnnum:$xln: last = $last_src [".$$src_ref[-1][0]."] $fconf $seek = $adddefs
    if ($dbg_v15) { $dbs .= "v15 "; } # show prt( "$lnnum:$xln: got POST event [$ppdefs]
    if ($dbg_v16) { $dbs .= "v16 "; } # for AdditionalDependencies and 'AdditionalLibraryDirectories'
    if ($dbg_v17) { $dbs .= "v17 "; } # show prtw( "WARNING: $lnnum:$xln: DOES NOT CONTAIN(12) '$seek'? [$line]\n"
    if ($dbg_v18) { $dbs .= "v18 "; } # show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(7) '$seek' [$line]
    if ($dbg_v19) { $dbs .= "v19 "; } # show prt( "$lnnum:$xln: Changed(1) $seek from [".$dsp_current_sub{$var1}."] to [$adddeps]
    if ($dbg_v20) { $dbs .= "v20 "; } # show prt( "$lnnum:$xln: Changed(2) $seek from [".$dsp_current_sub{$var2}."] to [$adddeps]
    if ($dbg_v21) { $dbs .= "v21 "; } # show prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(5) '$seek' [$line] and others
    if ($dbg_v22) { $dbs .= "v22 "; } # show prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$adddeps]
    if ($dbg_v23) { $dbs .= "v23 "; } # show prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$tmp]\n from [$adddeps]
    if ($dbg_v24) { $dbs .= "v24 "; } # show prt( "$lnnum:$xln: seek=$seek: Set [$var2] to [$adddeps]\n" ) if ($dbg_v24);
    if ($dbg_v25) { $dbs .= "v25 "; } # show prt( "$lnnum:$xln: VCCLCompilerTool:$seek: set [$var1] to ".$dsp_current_sub{$var1}."\n" ) if ($dbg_v25);
    if ($dbg_v26) { $dbs .= "v26 "; } # prt( "[dbg_v26] Processing prop file(s) [$fils] cnt=$cnt\n" ) if ($dbg_v26);
    if ($dbg_v27) { $dbs .= "v27 "; } # prt( "[dbg_v27] $lnnum:$xln: got CUSTOM event [$ppdefs] [$tmp]\n" ) if ($dbg_v27);
    if ($dbg_v28) { $dbs .= "v28 "; } # prt( "[dbg_v28] $lnnum:$xln:$tag: Exit Filter::File [$line]\n" ) if ($dbg_v28);
    if ($dbg_v29) { $dbs .= "v29 "; } # prt( "[dbg_v29] Pushed [$last_src] into source reference - position $last_fpos\n" ) if ($dbg_v29);
    if ($dbg_v30) { $dbs .= "v30 "; } # prt("[dbg_v30] NOTE:$pnam: Have $cnt items to add! ($cnt2-$cnt3) $tmp\n") if ($dbg_v30); and MORE
    return $dbs;
}

my $CMDSPEC = (exists $ENV{COMSPEC}) ? $ENV{COMSPEC} : "CMD";

# additions
my %compileas = (
	0 => "",
	1 => "TC",
	2 => "TP"
	);

# 2009/10/25 - special provision for RC files - not duplicates
sub show_hash_results3($) {
    my ($rh) = @_;
    my ($key, $val, @arr, $itm, $icnt, $i, $msg, $src, $grp, $nm, $dir, $ext);
    my ($iia, $wmsg, $tmp, $ics, $mlen, $slen);
    my ($captyp);
    my %srcs = ();
    my @fsrcs = ();
    my $flag = 0;
    my $dbg  = 0;
    $key = "PROJECT_FLAGS";
    if (defined ${$rh}{$key}) {
        $flag = ${$rh}{$key}[0];
        $dbg  = ${$rh}{$key}[1];
    } else {
        prtw("WARNING: Project HASH does NOT have a [$key] key!\n");
    }

    prt( "Show HASH results... (flag=$flag,dbg=$dbg)\n" );
    $key = '-NEW_PROJECT_NAME-';
    if (defined ${$rh}{$key}) {
       $cname = ${$rh}{$key};
    } else {
       $cname = "Unknown - [$key] NOT SET!"; 
    }
    $msg = "Application name: [$cname]";
    $msg .= " [key=$key]" if ($dbg & 8);
    prt("$msg\n");

    $key = 'APP_TYPE';
    if (defined ${$rh}{$key}) {
       $captyp = ${$rh}{$key};
    } else {
       $captyp = "Unknown - [$key] NOT SET!"; 
    }
    $msg = "Application type: [$captyp]";
    $msg .= " [key=$key]" if ($dbg & 8);
    prt( "$msg\n" );

    foreach $key (sort keys(%{$rh}) ) {
        $val = $$rh{$key};  # extract the VALUE of the KEY
        if (($key eq 'APP_TYPE')||($key eq '-NEW_PROJECT_NAME-')||
            ($key eq 'PROJECT_FLAGS')||($key eq 'CURR_CARR')) {
            # already dealt with at the beginning
            # like prt( "Application Type [$val]\n" );
        } elsif (($key eq 'C_SOURCES')||($key eq 'H_SOURCES')) {
            # SHOW of sources and headers in VCPROJ file
            $icnt = scalar @{$val};
            $msg = "$key count $icnt sources ...";
            prt( "$msg ($icnt)\n" );
            $msg = '';
            # push(@vc_c_sources,[$adddefs, $fname, $flist]);
            $mlen = 0;
            for ($i = 0; $i < $icnt; $i++) {
                $src = $$val[$i][0];
                $slen = length($src);
                $mlen = $slen if ($slen > $mlen);
            }
            for ($i = 0; $i < $icnt; $i++) {
                $src = $$val[$i][0];
                ($nm,$dir,$ext) = fileparse( $src, qr/\.[^.]*/ );
                $nm = lc($nm);
                # 2009/10/25 - must ignore *.rc files, since NOT really 'duplicate'
                $iia = defined $srcs{$nm}; 
                $ics = is_c_source_extended($src);
                if ($iia) {
                    if ($ics) {
                        # 2009/10/22 - reduced to a NOTE, since it seems handled ok
                        #$wmsg = "WARNING: Duplicate [$src]! ";
                        #prtw( "$wmsg\n" );
                        if (lc($ext) ne '.rc') {    # 2009/10/25 - exclude if RC file
                            prt( "NOTE: Duplicate source file [$src]\n" );
                        }
                    }
                } else {
                    $srcs{$nm} = 1 if ($ics);
                    push(@fsrcs,$src);
                }
                $grp = $$val[$i][1];
                $msg .= "\n" if length($msg);
                $tmp = $src;
                $tmp .= ' ' while (length($tmp) < $mlen);
                $msg .= $tmp;
                $msg .= " [$grp]";
                ###$msg .= ' '.$$val[$i][2];
            }
            prt( "$msg [dbg & 32]\n" ) if ($dbg & 32);
        } elsif ($key =~ /^config-\d+/) {
            $icnt = scalar keys(%{$val});
            prt( "CONFIG: $key: $icnt items...\n" );
            if ($dbg & 64) {
                my ($ky,$vl);
                foreach $ky (keys %{$val}) {
                    $vl = ${$val}{$ky};
                    prt( " key=[$ky], value=[$vl]\n" );
                }
            }
        } elsif ($key eq 'PROJECT_FILE') {
            prt("Input file [$val]\n");
        } else {
            prtw("WARNING: WHAT IS THIS KEY!!! [$key]\n");
        }
    }
    prt( "Done show HASH results... (flag=$flag,dbg=$dbg)\n" ) if ($dbg);
}

sub add_2_source_ref($$$$$$$) {
    my ($src_ref, $last_src, $var1, $var2, $tmp, $rlfp, $num) = @_;
    my $last_fpos = scalar @{$src_ref};
    push(@{$src_ref}, [$last_src, $var1, $var2, 0, ""]);
    ${$rlfp} = $last_fpos;  # pointer to active file in array
    prt( "[dbg_v29] Pushed src [$last_src][$tmp:$num][$var1][$var2] - position $last_fpos\n" ) if ($dbg_v29);
}

# Specifically interested in addeding
# $seek = 'OutputDirectory';
# $seek = 'IntermediateDirectory';
# %comspec% /k ""C:\Program Files\Microsoft Visual Studio 9.0\VC\vcvarsall.bat"" x86
# $(VCInstallDir)VCProjectDefaults\UpgradeFromVC71.vsprops
sub add_props_to_hash($$$$) {     # ( $adddeps, \%atthash );
    my ($fil,$fils,$rh,$props) = @_;
    my (@arr,$cnt,$i,$nm,$dir,$itm,$ff,%lnmap,$xlncnt,@lines,$lncnt,$lnnum);
    my ($line,$xln,@attribs,$ratthash,$key,$val);
    my ($val2, $tkey, $tag, $idir);
    my @parr = split(";",$props);
    ($nm,$dir) = fileparse($fil);
    $dir = strip_dotrel($dir);
    @arr = split(/[;,]/,$fils); # can be MORE THAN ONE property sheet
    $cnt = scalar @arr;
    prt( "[dbg_v26] Processing prop file(s) [$fils] cnt=$cnt\n" ) if ($dbg_v26);
    for ($i = 0; $i < $cnt; $i++) {
        $itm = strip_dotrel(trim_all(strip_quotes(trim_all($arr[$i]))));
        if ($itm =~ /^\$\(VCInstallDir\)/i) {
            $idir = '';
            if ( get_vs_install_dir(\$idir) && length($idir) ) {
                $itm =~ s/^\$\(VCInstallDir\)//i;
                $dir = $idir."\\VC";
                prt( "[dbg_v26] Setting dir to [$dir], for item [$itm]\n" ) if ($dbg_v26);
            } else {
                prtw("WARNING: Failed to get VCINSTALLDIR!\n");
            }
        }
        # ===========================================================================
        $ff = $dir;
        $ff .= "\\" if ( length($dir) && !(($dir =~ /(\\|\/)$/)||($itm =~ /^(\\|\/)/)) );
        $ff .= $itm;
        ###prt( "Finding [$ff], from [$dir]/[$itm]...\n" );
        # ===========================================================================
        if (-f $ff) {
            prt( "[dbg_v26] Loading inherited props [$ff]..\n" ) if ($dbg_v26);
            if (open INF, "<$ff") {
                %lnmap = ();
                @lines = <INF>;
                close INF;
                $xlncnt = scalar @lines;
                @lines = fg_xml_to_lines(\%lnmap, @lines);
                $lncnt = scalar @lines;
                $lnnum = 0;
                prt( "Processing file [$ff], $lncnt lines ($xlncnt) ...\n" ) if ($dbg_v26);
                foreach $line (@lines) {
                    $lnnum++;
                    $xln = $lnmap{$lnnum};
                    $ratthash = line_2_hash_on_equals($line,$lnnum);
                    $tag = $attribs[0];
                    foreach $key (sort keys %{$ratthash}) {
                        $val = ${$ratthash}{$key};
                        $tkey = substr($key,16);
                        if (length($val) && is_in_array($tkey,@parr)) {
                            if (defined ${$rh}{$tkey}) {
                                $val2 = ${$rh}{$tkey};
                                prtw( "WARNING: key=[$tkey], value=[$val2] REPLACED with [$val] [$fil]\n" );
                            } else {
                                prt( "Added key=[$tkey], value=[$val]\n" );
                                ${$rh}{$tkey} = $val;
                            }
                        }
                    }
                }
            } else {
                prtw( "WARNING: FAILED to OPEN inherited props [$ff] [$fil]\n" );
            }
        } else {
            prtw( "WARNING: FAILED to FIND inherited props [$itm] [$ff]! in [$fil]\n" );
        }
    }
    #prt( "TEMP EXIT\n" );
    #exit(1);
}

sub show_confs_warning($$) { # = ($fil, \@configs)
    my ($fil, $ra) = @_;
    my $cnt = scalar @{$ra};
    my ($k, $conf, $var1, $dbg, $rel, $cw32, $not);
    $dbg = 0;
    $rel = 0;
    $not = 0;
    for ($k = 0; $k < $cnt; $k++) {
        $conf = ${$ra}[$k][0];
        if ($conf =~ /Release/i) {
            $rel++;
        } elsif ($conf =~ /Debug/i) {
            $dbg++;
        } else {
            $not++;
        }
    }
    my $msg = "NOTE: File [$fil] has $cnt CONFIGURATIONS! $rel Release and $dbg Debug ($not)\n";
    for ($k = 0; $k < $cnt; $k++) {
        $conf = ${$ra}[$k][0];
        $var1 = ${$ra}[$k][1];
        $cw32 = ${$ra}[$k][2];
        $msg .= "   ".($k+1).": $conf ($var1) [$cw32]\n";
    }
    if ($not) {
        prtw($msg);
    } else {
        prt($msg);  # 2009/10/21 - reduced to normal message, NOT warning
    }
}


sub add_any_per_file_items($$$$$$) {  
    # ( $rdsp_current_sub, \%per_file_hash, $src_ref, \@configs, $last_pos, $projname );
    my ($rdsp, $rpf, $rsrc, $rca, $lp, $pnam) = @_;
    my @arr = keys(%{$rpf});    # per_file_hash);
    my $cnt = scalar @arr;
    my ($cnt2, $tmp, $i, $v, @a, $cnt3, $key, $num, $cfg, $tmp2);
    my ($j,$srcs, $msg, $ky2, $val2);
    my $failed = 0;
    my @cfgs = ();
    if( $cnt ) {
        # note project name is $projname
        $cnt2 = scalar @{$rca};
        $tmp = ${$rsrc}[$lp][0];
        for ($i = 0; $i < $cnt; $i++) {
            $v = $arr[$i];  # this is the KEY in the $rpf, to get the prepared string
            @a = split(/\|/,$v);
            $tmp .= "[".$a[0]."]";
            #            0      1   2   3  4   5
            push(@cfgs, [$a[0], '', 0, '', $v, '']);
        }
        $cnt3 = 0;
        foreach $key (keys %{$rdsp}) {
            if ($key =~ /^config-(\d+)-(.+)/) {
                $num = $1;
                $cfg = $2;
                if ($cnt3 < $cnt) {
                    for ($j = 0; $j < $cnt; $j++) {
                        if ($cfgs[$j][0] eq $cfg) {
                            $cfgs[$j][1] = $key;
                            $cfgs[$j][2] = $num;
                            $cfgs[$j][3] = $cfg;
                            last;
                        }
                    }
                    if ($j == $cnt) {
                        prt("Oops: MISSED finding CONFIG [$cfg] [$key]\n");
                        pgm_exit(1,"FAILED IN FIND");
                    }
                }
                $cnt3++;
            }
        }
        prt("[dbg_v30] NOTE:$pnam: Have $cnt items to add! ($cnt2-$cnt3) $tmp\n") if ($dbg_v30);
        $tmp2 = '';
        for ($i = 0; $i < $cnt3; $i++) {
            $v   = $cfgs[$i][0];
            $key = $cfgs[$i][1];
            $num = $cfgs[$i][2];
            $cfg = $cfgs[$i][3];
            $ky2 = $cfgs[$i][4];
            $msg = "v=[$v], ky=[$key], num=[$num], cfg=[$cfg] ";
            if (defined ${$rdsp}{$key}) {
                $srcs = ${$rdsp}{$key};
                $msg .= "OK";
                if (defined ${$rpf}{$ky2}) {
                    $val2 = ${$rpf}{$ky2};
                    if (length($val2)) {
                        $cfgs[$i][5] = $val2;
                        $msg .= " OK (".length($val2).")";
                    } else {
                        $msg .= " FAILED3";
                        $failed++;
                    }
                } else {
                    $msg .= " FAILED2";
                    $failed++;
                }
            } else {
                $msg .= "FAILED1";
                $failed++;
            }
            prt( "[dbg_v30] $msg\n" ) if ($dbg_v30);
        }
        if ( ($cnt == $cnt2) && ($cnt == $cnt3) && !$failed ) {
            # we should be able to build it...
            $tmp = '';
            for ($i = 0; $i < $cnt; $i++) {
                $cfg = $cfgs[$i][3];
                if ($i == 0) {
                    $tmp .= "\n!IF ";
                } else {
                    $tmp .= "!ELSEIF ";
                }
                $tmp .= "\"\$(CFG)\" == \"$pnam - Win32 $cfg\"\n\n";
                $tmp .= $cfgs[$i][5]."\n";
            }
            $tmp .= "!ENDIF \n\n";
            ${$rsrc}[$lp][4] = $tmp;
            if ($dbg_v30) {
                prt( "[dbg_v30] === added following to $lp position ============\n" );
                prt( "$tmp" );
                prt( "==============================================\n" );
            }
        } else {
            $failed++;
            prtw("WARNING:fgscanvc03:add_any_per_file_items: FAILED: COUNTS NOT EQUAL $cnt $cnt2 $cnt3 or something\n");
            pgm_exit(1,"CHECKME AND FIX!");
        }
    }
    return $failed;
}

sub add_config_arrays($) {
    my ($rh) = @_;
    my $name = '';
    my $conf1 = '';
    my $key = 'CURR_CARR';   # ${$rh}{$key} = [@confarr];
    if (defined ${$rh}{$key}) {
        prtw("WARNING: add_config_arrays: Key [$key] already EXISTS\n");
    }
    if ( !get_project_name($rh, \$name) ) {
        prtw("WARNING:fgscanvc03:add_config_arrays: Unable to get project name!\n");
        pgm_exit(1,"NO NAME IN HASH");
    }
    get_configs_array($rh, \$conf1, $name);
    if (! defined ${$rh}{$key}) {
        prtw("WARNING:fgscanvc03:add_config_arrays: Key [$key] was NOT created!\n");
        pgm_exit(1,"CREATE CONFIG ARRAYS FAILED");
    }
    prt( "Got config arrays - first is [$conf1]\n" );
}

sub process_VCPROJ3 {
    my ($fil) = shift;
    $act_vcproj = $fil;
    my (@lines, $xlncnt, $lncnt, $lnnum, $xln, $line, $tag);
    my (@attribs, %atthash, %lnmap);
    my ($pname, $adddeps, $adddefs, $ppdefs);
    my ($var1, $var2, $var3, $seek, $tmp);
    my (@arr,$cnt,$i);
    my @configs = ();
    my $rdsp_current_sub = get_default_sub_ref(0); # copy the DEFAULTS
    my ($dsp_sub_sub);
    my $sub_count = 0;
    ${$rdsp_current_sub}{'PROJECT_FILE'} = $fil;
    if (open INF, "<$fil") {
        %lnmap = ();
        @lines = <INF>;
        close INF;
        $xlncnt = scalar @lines;
        @lines = fg_xml_to_lines(\%lnmap, @lines);
        $lncnt = scalar @lines;
        $lnnum = 0;
        prt( "Processing file [$fil], $lncnt lines ($xlncnt) ...\n" );
        my $invcproj = 0;
        my @tag_stack = ();
        my $inconfigs = 0;
        my $inconfig = 0;
        my $apptype = '';
        my $dnapptype = '';
        my $dnaptype = 0;
        my $conf = '';
        my $infiles = 0;
        my $infile = 0;
        my $fname = '';
        my $flist = '';
        my $infilt = 0;
        my $projname = '';
        my $fconf = ''; # FileConfiguration
        my $infconf = 0; # in FileConfiguration
        my @vc_c_sources = ();
        my @vc_h_sources = ();
        my $src_ref = \@vc_c_sources;
        my $last_src = '';  # the LAST SOURCE file processed
        my $last_nm  = '';  # and its NAME only
        my $last_dir = '';  # and its DIRECTORY
        my $last_ext = '';  # and its EXTENSION
        my $last_fpos = 0;  # last position in $src_ref array, ie ${$ref_src}[$last_fpos][0] to get FILE NAME
        my $last_intdir = '';   # last intermediate directory - under "-NEW_INTER-" in $dsp_sub_sub
        # which is in $sub_count++; $tmp = sprintf("config-%03d",$sub_count); $tmp .= "-$confname"; ${$rdsp_current_sub}{$tmp} = $dsp_sub_sub;
        my $confname = '';
        my ($curval,$newval);
        my $dn_lt_noo = 0;
        my %per_file_hash = ();
        foreach $line (@lines) {
            $lnnum++;
            $xln = $lnmap{$lnnum};
            @attribs = space_split($line);
            %atthash = array_2_hash_on_equals(@attribs);
            $tag = $attribs[0];
            $pname = '';
            if (defined $atthash{'Name'}) {
                $pname = strip_quotes(trim_all($atthash{'Name'}));
                prt( "$lnnum:$xln: tag=$tag, Name=$pname\n" ) if ($dbg_v02);
            }
            if ($invcproj) {
                if ($tag =~ /<\/VisualStudioProject/) {
                    $invcproj = 0;
                    ##pop @tag_stack;
                } else {
                    # in VCPROJ file
                    if ($line =~ /\/>$/) {
                        # begin and end tag line
                    } elsif ($line =~ /^<\//) {
                        if (! @tag_stack) {
                            prtw( "Close WITHOUT stacked tag! [$line]\n" );
                        } else {
                            pop @tag_stack;
                        }
                    } else {
                        push(@tag_stack,$tag);
                    }
                    if ($inconfigs) {
                        if ($tag =~ /<\/Configurations/) {
                            add_config_arrays($rdsp_current_sub) if ($inconfigs);
                            $inconfigs = 0;
                            prt( "$lnnum:$xln: Exit Configurations [$line]\n" ) if ($dbg_v07);
                        } else {
                            # in 'Configurations' section
                            if ($inconfig) {
                                # in a specific 'Confgiuration name="..."...>
                                if ($line =~ /^<\/Configuration/) {
                                    $inconfig = 0;
                                    $sub_count++;
                                    $tmp = sprintf("config-%03d",$sub_count);
                                    $tmp .= "-$confname";
                                    ${$rdsp_current_sub}{$tmp} = $dsp_sub_sub;
                                    prt( "$lnnum:$xln: Exit Configuration [$conf]... [$line] ...\n" ) if ($dbg_v08);
                                } else {
                                    # processing a Configuration in Configurations
                                    prt( "$lnnum:$xln: processing inconfig '$conf' '$pname' [$line]\n" ) if ($dbg_v04);
                                    if ($line =~ /<Tool\s+/ ) {
                                        if ($pname eq 'VCCLCompilerTool') {
                                            $var1 = '-NEW_INCS-';
                                            $var2 = '-NEW_DEFS-';
                                            $var3 = '-NEW_RT-';
                                            prt( "$lnnum:$xln: 'VCCLCompilerTool' [$line]\n" ) if ($dbg_v10);
                                            # <Tool
                                            # Name="VCCLCompilerTool"
                                            # Optimization="0"
                                            # AdditionalIncludeDirectories="../lib,../lib/curl_transport,...
                                            # PreprocessorDefinitions="_DEBUG;WIN32;_LIB;ABYSS_WIN32;CURL_STATICLIB" 
                                            # MinimalRebuild="true" 
                                            # BasicRuntimeChecks="3" 
                                            # RuntimeLibrary="1" 
                                            # PrecompiledHeaderFile=".\Debug\xmlrpccpp/xmlrpccpp.pch" 
                                            # AssemblerListingLocation=".\Debug\xmlrpccpp/" 
                                            # ObjectFile=".\Debug\xmlrpccpp/" 
                                            # ProgramDataBaseFileName=".\Debug\xmlrpccpp/" 
                                            # WarningLevel="3" 
                                            # SuppressStartupBanner="true" 
                                            # DebugInformationFormat="4" />]
                                            # WATCHOUT FOR 
                                            # AdditionalIncludeDirectories="..\..;&quot;..\..\..\zlib-1.2.3&quot;"

                                            $seek = 'AdditionalIncludeDirectories'; # -NEW_INCS_[DBG|REL]-
                                            if ( defined $atthash{$seek} ) {
                                                $ppdefs = strip_quotes(trim_all($atthash{$seek}));
                                                $ppdefs =~ s/&amp;/&/g;     # 20081205 - added
                                                $ppdefs =~ s/&quot;/"/g;
                                                $curval = '';
                                                if (defined ${$dsp_sub_sub}{$var1}) {
                                                   $curval = ${$dsp_sub_sub}{$var1};
                                                }
                                                $newval = get_includes_string($ppdefs);
                                                if ($curval ne $newval) {
                                                   ${$dsp_sub_sub}{$var1} = $newval;
                                                   if ($dbg_v25) {
                                                      if (length($curval)) {
                                                         prt( "$lnnum:$xln: VCCLCompilerTool:$seek: RESET [$var1] to [$newval] from [$curval]\n" );
                                                      } else {
                                                         prt( "$lnnum:$xln: VCCLCompilerTool:$seek: set [$var1] to [$newval]\n" );
                                                      }
                                                   }
                                                }
                                            } else { 
                                                ${$dsp_sub_sub}{$var1} = '';
                                                prt( "ADVICE:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(1) '$seek' [$line]\n" ) if ($dbg_v13);
                                            }

                                            $seek = 'PreprocessorDefinitions';
                                            if ( defined $atthash{$seek} ) {
                                                $ppdefs = strip_quotes(trim_all($atthash{$seek}));
                                                prt( "PreprocessorDefinitions = [$ppdefs] [$fil]\n" );
                                                $curval = '';
                                                if (defined ${$dsp_sub_sub}{$var1}) {
                                                   $curval = ${$dsp_sub_sub}{$var1};
                                                }
                                                $newval = get_defines_string($ppdefs);
                                                ${$dsp_sub_sub}{$var2} = $newval;
                                            } else {
                                                # 2009/09/22 - downgraded from WARNING, to a simple ADVICE
                                                # prtw( "WARNING:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(2) '$seek' [$line]\n" );
                                                prt( "ADVICE:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(2) '$seek' [$line]\n" );
                                            }

                                            $seek = 'RuntimeLibrary';
                                            if ( defined $atthash{$seek} ) {
                                                $ppdefs = strip_quotes(trim_all($atthash{$seek}));
                                                ${$dsp_sub_sub}{$var3} = fg_get_runtime_val_2_lts($ppdefs);
                                            } else {
                                                # 2009/09/22 - downgraded from WARNING, to a simple ADVICE
                                                # prtw( "WARNING:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(3) '$seek' [$line]\n" );
                                                prt( "ADVICE:$lnnum:$xln: 'VCCLCompilerTool' DOES NOT CONTAIN(3) '$seek' [$line]\n" );
                                            }

                                            $seek = 'CompileAs';
                                            if ( defined $atthash{$seek} ) {
                                                $ppdefs = strip_quotes(trim_all($atthash{$seek}));
                                                $adddeps = ${$dsp_sub_sub}{$var3};
                                                if (defined $compileas{$ppdefs} ) {
                                                   $tmp = $compileas{$ppdefs};
                                                   $adddeps .= " " if length($adddeps);
                                                   $adddeps .= "/$tmp";
                                                   $curval = '';
                                                   if (defined ${$dsp_sub_sub}{$var3}) {
                                                      $curval = ${$dsp_sub_sub}{$var3};
                                                   }
                                                   $newval = $adddeps;
                                                   if ($curval ne $newval) {
                                                      ${$dsp_sub_sub}{$var3} = $newval;
                                                      prt( "$lnnum:$xln: VCCLCompilerTool:$seek: set [$var3] to ".${$dsp_sub_sub}{$var3}."\n" ); # if ($dbg_v26);
                                                   }
                                                } else {
                                                   prtw( "WARNING:$lnnum:$xln: VCCLCompilerTool:$seek: [$var3] NOT BEING SET! [$ppdefs] NOT IN 'compileas' hash [$fil]\n" );
                                                }
                                             }
                                        } elsif ($pname eq 'VCLinkerTool') {
                                            $var1 = '-NEW_LIBS-';
                                            $var2 = '-NEW_OUT-';
                                            # <Tool
                                            #  Name="VCLinkerTool"
                                            #  LinkLibraryDependencies="false"
                                            #  AdditionalDependencies="wsock32.lib SimGear.lib sg_d.lib ... "
                                            #  OutputFile="..\bin\FlightGearD.exe"
                                            #  LinkIncremental="0"
                                            #  SuppressStartupBanner="true"
                                            #  AdditionalLibraryDirectories="..\SimGear\$(IntDir); ..\PLIB, ..."
                                            #  IgnoreDefaultLibraryNames=""
                                            #  GenerateDebugInformation="true"
                                            #  ProgramDatabaseFile=".\Debug/FlightGear.pdb"
                                            #  SubSystem="1"
                                            #  RandomizedBaseAddress="1"
                                            #  DataExecutionPrevention="0"
                                            #  TargetMachine="1" />
                                            $seek = 'AdditionalDependencies';
                                            if (defined $atthash{$seek} ) {
                                                $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                                $adddeps =~ s/&amp;/&/g;     # 20081205 - added
                                                $adddeps =~ s/&quot;/"/g;    # 20081205 - added
                                                $newval = $adddeps;
                                                $curval = '';
                                                if (defined ${$dsp_sub_sub}{$var1}) {
                                                   $curval = ${$dsp_sub_sub}{$var1};
                                                }
                                                if ($newval ne $curval) {
                                                   ${$dsp_sub_sub}{$var1} = $adddeps;
                                                   prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$adddeps]\n" ) if ($dbg_v22);
                                                }
                                            } else {
                                                prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(4) '$seek' [$line] [$fil]\n" ) if ($dbg_v16);
                                            }

                                            $seek = 'OutputFile';
                                            if (defined $atthash{$seek} ) {
                                                $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                                # 20090808 - handle substitution
                                                # EG: 39:138-149: seek=OutputFile: Set [-NEW_OUT_REL-] 
                                                # to [.\$(ProjectName).exe]
                                                $adddeps =~ s/\$\(ProjectName\)/$projname/;
                                                $curval = '';
                                                if (defined ${$dsp_sub_sub}{$var2}) {
                                                   $curval = ${$dsp_sub_sub}{$var2};
                                                }
                                                $newval = '/out:'.$adddeps;
                                                if ($curval ne $newval) {
                                                   ${$dsp_sub_sub}{$var2} = $newval;
                                                   prt( "$lnnum:$xln: seek=$seek: Set [$var2] to [$newval]\n" ) if ($dbg_v24);
                                                }
                                            } else {
                                               # 20090912 - downgraded to a NOTE only, and ONLY once per file
                                               if (!$dn_lt_noo) {
                                                   # prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(5) '$seek' [$line]\n" ) if ($dbg_v21);
                                                   prt( "NOTE:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(5) '$seek' [$line]\n" ) if ($dbg_v21);
                                                   $dn_lt_noo = 1;
                                               }
                                            }

                                            $seek = 'AdditionalLibraryDirectories';
                                            if (defined $atthash{$seek} ) {
                                                # must deal with a crazy string like this -
                                                # AdditionalLibraryDirectories=
                                                # "&amp;quot,..\fltk-1.1.7\lib&amp;quot,..\SimGear.plib\Debug,
                                                # ..\zlib-1.2.3&amp;quot,..\plib,
                                                # ..\pthreads-w32-2-7-0-release&amp;quot,..\gettext\lib"
                                                # after quotes removed, and the first substitution
                                                # &quot,..\fltk-1.1.7\lib&quot,..\SimGear.plib\Debug,
                                                # ..\zlib-1.2.3&quot,..\plib,
                                                # ..\pthreads-w32-2-7-0-release&quot,..\gettext\lib
                                                # after next pair of subs
                                                # ",..\fltk-1.1.7\lib",..\SimGear.plib\Debug,
                                                # ..\zlib-1.2.3",..\plib,
                                                # ..\pthreads-w32-2-7-0-release",..\gettext\lib
                                                # then removing the auotes
                                                # ,..\fltk-1.1.7\lib,..\SimGear.plib\Debug,
                                                # ..\zlib-1.2.3,..\plib,
                                                # ..\pthreads-w32-2-7-0-release,..\gettext\lib
                                                $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                                $adddeps =~ s/&amp;/&/g;    # 20081205 - added
                                                $adddeps =~ s/&quot;/"/g;   # 20081205 - added
                                                $adddeps =~ s/&quot/"/g;    # 20081205 - added
                                                $adddeps =~ s/"//g;         # 20081205 - added
                                                $adddeps =~ s/^,//;         # 20081205 - added
                                                $tmp = get_libpaths_string($adddeps);
                                                $curval = '';
                                                if (defined ${$dsp_sub_sub}{$var1}) {
                                                   $curval = ${$dsp_sub_sub}{$var1};
                                                }
                                                ${$dsp_sub_sub}{$var1} .= ' '.$tmp;
                                                prt( "$lnnum:$xln: seek=$seek: Set [$var1] to [$tmp]\n from [$adddeps]\n" ) if ($dbg_v23);
                                            } else {
                                                prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(6) '$seek' [$line] [$fil]\n" )  if ($dbg_v16);
                                            }

                                            $seek = 'SubSystem';
                                            if (defined $atthash{$seek} ) {
                                                $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                                $apptype = adjust_app_type_per_subsystem( $apptype, $adddeps, $dbg_v05 );
                                                $dnaptype |= 2;  # signal, we have an APP TYPE - VERY IMPORTANT
                                                # subsystem determines different between 'Application' and 'Console Application'
                                                if (length($dnapptype)) {
                                                   if ($dnapptype ne $apptype) {
                                                      prt( "$lnnum:$xln: Project [$projname], APP_TYPE RESET per SubSystem [$apptype] from [$dnapptype]...\n" );
                                                      $dnapptype = $apptype;
                                                   }
                                                } else {
                                                   prt( "$lnnum:$xln: Project [$projname], APP_TYPE per SubSystem [$apptype]...\n" );
                                                   $dnapptype = $apptype;
                                                }
                                            } else {
                                                prtw( "WARNING:$lnnum:$xln: 'VCCLinkerTool' DOES NOT CONTAIN(7) '$seek' [$line] [$fil]\n" ) if ($dbg_v18);
                                            }
                                        } elsif ($pname eq 'VCLibrarianTool' ) {
                                           # <Tool Name="VCLibrarianTool"
                                           # OutputFile="Win32_LIB_Debug\zlibd.lib"
                                           # SuppressStartupBanner="true" />
                                            $var2 = '-NEW_OUT-';
                                            $seek = 'OutputFile';
                                            if (defined $atthash{$seek} ) {
                                                $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                                $curval = '';
                                                if (defined ${$dsp_sub_sub}{$var2}) {
                                                   $curval = ${$dsp_sub_sub}{$var2};
                                                }
                                                $newval = '/out:'.$adddeps;
                                                if ($curval ne $newval) {
                                                   ${$dsp_sub_sub}{$var2} = $newval;
                                                   prt( "$lnnum:$xln: seek=$seek: Set [$var2] to [$newval]\n" ) if ($dbg_v24);
                                                }
                                            } else {
                                               # 20090914 - set as 15, downgraded to a NOTE only, and ONLY once per file
                                               # it seems this will DEFAULT TO '$(OutDir)\$(ProjectName).lib'!!!
                                               if (!$dn_lt_noo) {
                                                    prt( "NOTE:$lnnum:$xln: 'VCLibrarianTool' DOES NOT CONTAIN(15) '$seek' [$line]\n" ) if ($dbg_v21);
                                                    $dn_lt_noo = 1;
                                               }
                                            }
                                        } elsif ($pname eq 'VCPostBuildEventTool') {
                                            $var1 = '-NEW_POST-';
                                            if ( !(($conf =~ /Debug/i)||($conf =~ /Release/i)) ) {
                                                prtw( "WARNING:$lnnum:$xln: pname=[$conf] NOT Debug or Release - def to REL! [$fil]\n" );
                                            }
                                            # <Tool
                                            #  Name="VCPostBuildEventTool"
                                            #  Description="Copy Library to plib directory"
                                            #  CommandLine="copy debug\*.lib ..\..\*.*&#x0D;&#x0A;copy ul.h ..\..\ul.h&#x0D;&#x0A;copy ulRTTI.h ..\..\ulRTTI.h&#x0D;&#x0A;"
                                            #  />
                                            # this will be output to the DSP, under the paticular, config, something like
                                            # # Begin Special Build Tool
                                            # SOURCE="$(InputPath)"
                                            # PostBuild_Desc=Copy to bin
                                            # PostBuild_Cmds=copy Release\*exe bin\.	copy test.h bin\.
                                            # # End Special Build Tool
                                            if (( defined $atthash{'Description'} ) || ( defined $atthash{'CommandLine'} ) ) {
                                                $ppdefs = ""; # to 'PostBuild_Desc=';
                                                if ( defined $atthash{'Description'} ) {
                                                    $ppdefs .= add_quotes(strip_quotes(trim_all($atthash{'Description'})));
                                                }
                                                $adddeps = ""; # to ' PostBuild_Cmds=';
                                                if ( defined $atthash{'CommandLine'} ) {
                                                    $adddeps = strip_quotes(trim_ends($atthash{'CommandLine'}));
                                                    $adddeps =~ s/&quot;/"/g;   # put back the quotes, if any
                                                    $adddeps =~ s/&#x0D;&#x0A;/\t/g;    # new line to TAB for VC6
                                                    $adddeps =~ s/\t$//;    # clear any END tab
                                                }
                                                prt( "$lnnum:$xln: got POST event [$ppdefs]\n" ) if ($dbg_v15);
                                                $tmp = "# Begin Special Build Tool\n";
                                                $tmp .= "SOURCE=\"\$(InputPath)\"\n";
                                                $tmp .= "PostBuild_Desc=$ppdefs\n";
                                                # sometimes need a little 'massaging' of the command ...
                                                $tmp .= "PostBuild_Cmds=".massage_command($adddeps)."\n";
                                                $tmp .= "# End Special Build Tool\n";
                                                ${$dsp_sub_sub}{$var1} = $tmp;
                                            }
                                        }
                                    }
                                }
                            } elsif ($line =~ /^<Configuration\s+/) {
                                # entering a SPECIFIC "Configuration\s+name="..." ...>
                                $conf = $pname;
                                @arr = split(/\|/,$pname);
                                $confname = $arr[0];
                                prt( "$lnnum:$xln: Entering ConfigurationName=[$confname] conf=[$conf] [$line] ...\n" ) if ($dbg_v08);

                                # 28/09/2008 - note, has quotes added
                                # "-NEW_OUTD-" $out_dir
                                # "-NEW_INTER-" $int_dir
                                $var1 = "-NEW_OUTD-";
                                $var2 = "-NEW_INTER-";
                                if ($conf =~ /Debug/i) {
                                    $dsp_sub_sub = get_default_sub3(1);
                                } else {
                                    $dsp_sub_sub = get_default_sub3(0);
                                    if (!($conf =~ /Release/i)) {
                                        prtw( "WARNING:$lnnum:$xln: pname=[$conf] NOT Debug or Release - def to REL! [$fil]\n" );
                                    }
                                }
                                push(@configs,[ $pname, $var1, $conf ]);
                                #  // This is an internal type to Visual Studio, it seems that:
                                #  // 4 == static library
                                #  // 2 == dll
                                #  // 1 == executable - note, subsytem decides if this remains 'Application' or becomes 'Console Application'
                                #  // 10 == utility
                                $seek = 'ConfigurationType';
                                if (defined $atthash{$seek}) {
                                    $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                    $apptype = get_app_conf_type($adddeps);
                                    $dnaptype |= 1;  # signal, we have an APP TYPE - VERY IMPORTANT
                                    if (length($dnapptype)) {
                                       if ($dnaptype & 2) {
                                          $apptype = $dnapptype;
                                       }
                                       if ($dnapptype ne $apptype) {
                                          prt( "$lnnum:$xln: Project [$projname], APP_TYPE RESET per $seek [$apptype] from [$dnapptype]...\n" );
                                          $dnapptype = $apptype;
                                       }
                                    } else {
                                       prt( "$lnnum:$xln: Project [$projname], APP_TYPE per $seek [$apptype]...\n" );
                                       $dnapptype = $apptype;
                                    }
                                } else {
                                    prtw( "WARNING:$lnnum:$xln: DOES NOT CONTAIN(8) '$seek' [$line] [$fil]\n" );
                                }
                                # 2009/10/15 - handle better 'InheritedPropertySheets=".\vc9_lame_config.vsprops;.\arch_nasm.vsprops"'
                                # and this PROPS (vsprops) MAY contain the following items
                                $seek = 'InheritedPropertySheets';
                                if (defined $atthash{$seek}) {
                                    $adddeps = strip_quotes(trim_all($atthash{$seek}));
                                    add_props_to_hash( $fil, $adddeps, \%atthash, "OutputDirectory;IntermediateDirectory" );
                                }

                                $seek = 'OutputDirectory';
                                if (defined $atthash{$seek}) {
                                   # 20090808 - improved to handle
                                   # EG: 9:18-24: Changed(1) OutputDirectory from ["Debug"]
                                   # to ["$(SolutionDir)$(ConfigurationName)"]
                                   #$adddeps = add_quotes(strip_dotrel(strip_quotes(trim_all($atthash{$seek}))));
                                    $adddeps = strip_dotrel(strip_quotes(trim_all($atthash{$seek})));
                                    $adddeps =~ s/\$\(SolutionDir\)//;
                                    $adddeps =~ s/\$\(ConfigurationName\)/$confname/;
                                    if ( ${$dsp_sub_sub}{$var1} ne add_quotes($adddeps)) {
                                        if ($dbg_v19) {
                                           prt( "$lnnum:$xln: Changed(1) [$seek]" );
                                           prt( " from [".${$dsp_sub_sub}{$var1}."]" );
                                           prt( " to [".add_quotes($adddeps)."]\n" );
                                        }
                                    }
                                    ${$dsp_sub_sub}{$var1} = add_quotes($adddeps);
                                } else {
                                    prtw( "WARNING:$lnnum:$xln: DOES NOT CONTAIN(9) '$seek' [$line] [$fil]\n" );
                                }
                                $seek = 'IntermediateDirectory';
                                if (defined $atthash{$seek}) {
                                   # 20090808 - improved to handle
                                   # 9:18-24: Changed(2) IntermediateDirectory from ["Debug"] 
                                   # to ["$(ConfigurationName)"]
                                   # $adddeps = add_quotes(strip_dotrel(strip_quotes(trim_all($atthash{$seek}))));
                                   $adddeps = strip_dotrel(strip_quotes(trim_all($atthash{$seek})));
                                   $adddeps =~ s/\$\(SolutionDir\)//;
                                   $adddeps =~ s/\$\(ConfigurationName\)/$confname/;
                                   if (${$dsp_sub_sub}{$var2} ne add_quotes($adddeps)) {
                                       if ($dbg_v20) {
                                          prt( "$lnnum:$xln: Changed(2) [$seek]" );
                                          prt( " from [".${$dsp_sub_sub}{$var2}."]" );
                                          prt( " to [".add_quotes($adddeps)."]\n" );
                                       }
                                   }
                                   $last_intdir = $adddeps;
                                   ${$dsp_sub_sub}{$var2} = add_quotes($last_intdir);
                                } else {
                                    prtw( "WARNING:$lnnum:$xln: DOES NOT CONTAIN(10) '$seek' [$line] [$fil]\n" );
                                }
                                $inconfig = 1;
                            }
                        }
                    } elsif ($infiles) {
                        if ($tag =~ /\/Files/) {
                            prt( "[dbg_v09] $lnnum:$xln:$tag: Exit Files [$line]\n" ) if ($dbg_v09);
                            $infiles = 0;
                        } else {
                            # processing the <Files> section
                            # ##############################
                            if ($infilt) {
                                if ($line =~ /^<\/Filter/) {
                                    $infilt = 0;
                                    prt( "$lnnum:$xln: EXIT Filter name=[$fname] list=[$flist]\n" ) if ($dbg_v11);
                                    $flist = '';    # 20081205 - kill list on exit
                                } else {
                                    if ($infile) {
                                        if ($line =~ /^<\/File(\s|>)+/) {
                                            prt( "[dbg_v28] $lnnum:$xln:$tag: Exit     Filter::File [$line]\n" ) if ($dbg_v28);
                                            add_any_per_file_items( $rdsp_current_sub, \%per_file_hash, $src_ref,
                                                \@configs, $last_fpos, $projname );
                                            $infile = 0;
                                            %per_file_hash = ();
                                        } else {
                                            # processing a <Files><Filter...><File ... may have
                                            # In <Files ...>
                                            # WATCH FOR THIS
                                            # <File RelativePath="..\..\scripts\pngw32.def">
                                            # <FileConfiguration Name="LIB Release|Win32" ExcludedFromBuild="true">
                                            # <Tool Name="VCCustomBuildTool" />
                                            # </FileConfiguration>
                                            # <FileConfiguration Name="LIB Debug|Win32" ExcludedFromBuild="true">
                                            # <Tool Name="VCCustomBuildTool" />
                                            # </FileConfiguration>
                                            # </File>
                                            # <FileConfiguration Name="Release|Win32" >
                                            # <Tool Name="VCCLCompilerTool" AdditionalIncludeDirectories="" PreprocessorDefinitions="" />
                                            # </FileConfiguration>
                                            # <FileConfiguration Name="Debug|Win32" >
                                            # <Tool Name="VCCLCompilerTool" AdditionalIncludeDirectories="" PreprocessorDefinitions="" />
                                            # </FileConfiguration>
                                            # OR can have
                                            # <FileConfiguration Name="Release|Win32">
                                            # <Tool Name="VCCustomBuildTool" Description="Assembly $(InputPath)"
                                            # CommandLine="yasm -I..\..\common\x86\ -f win32 -O2 -DPREFIX -o &quot;$(IntDir)\$(InputName)&quot;.obj &quot;$(InputPath)&quot;&#x0D;&#x0A;"
                                            # Outputs="$(IntDir)\$(InputName).obj" />
                                            # </FileConfiguration>
                                            # and something similar for each configuration
                                            # </File>
                                            if ($infconf) {
                                                if ($tag =~ /<\/FileConfiguration/) {
                                                    $infconf = 0;
                                                    prt( "[dbg_v12] $lnnum:$xln: Exit     FileConfiguration [$line] conf=[$fconf]\n") if ($dbg_v12);
                                                } else {
                                                    # deal with a FILE CONFIGURATION
                                                    if ($tag =~ /<Tool/) {
                                                        if ($pname eq 'VCCustomBuildTool') {
                                                            if (( defined $atthash{'Description'} ) || ( defined $atthash{'CommandLine'} ) ) {
                                                                $ppdefs = ""; # to 'PostBuild_Desc=';
                                                                $seek = 'Description';
                                                                if ( defined $atthash{$seek} ) {
                                                                    $ppdefs .= strip_quotes(trim_all($atthash{$seek}));
                                                                }
                                                                $seek = 'CommandLine';
                                                                $adddeps = ""; # to ' PostBuild_Cmds=';
                                                                if ( defined $atthash{$seek} ) {
                                                                    $adddeps = strip_quotes(trim_ends($atthash{$seek}));
                                                                    $adddeps =~ s/&quot;/"/g;   # put back the quotes, if any
                                                                    $adddeps =~ s/&#x0D;&#x0A;/\t/g;    # new line to TAB for VC6
                                                                    $adddeps =~ s/\t$//;    # clear any END tab
                                                                }
                                                                $adddefs = '$(IntDir)';
                                                                $seek = 'Outputs';
                                                                if ( defined $atthash{$seek} ) {
                                                                    $adddefs = strip_quotes(trim_all($atthash{$seek}));
                                                                }
                                                                # 2009/10/29 - massage this more
                                                                # this seems to be something like -
                                                                # $(IntDir)\asm\$(InputName).obj, but for the DSP file the '\$(InputName).obj' seems ASSUMED,
                                                                # and the $(IndDir) is replaced with an actual DIRECTORY, so...
                                                                if ($adddefs =~ /\.obj$/i) {
                                                                    ($nm,$dir) = fileparse( $adddefs );
                                                                    $dir =~ s/(\\|\/)$//;
                                                                    $adddefs = $dir;
                                                                }
                                                                if ($adddefs =~ /\$\(IntDir\)/) {
                                                                    if (defined ${$dsp_sub_sub}{'-NEW_INTER-'}) {
                                                                        $dir = strip_quotes(${$dsp_sub_sub}{'-NEW_INTER-'});
                                                                        $dir =~ s/(\\|\/)$//;
                                                                        $adddefs =~ s/\$\(IntDir\)/$dir/;
                                                                    }
                                                                }

                                                                $tmp = "# Begin Custom Build - $ppdefs\n";
                                                                $tmp .= "IntDir=$adddefs\n";
                                                                $tmp .= "Inputpath=$last_src\n";
                                                                $tmp .= "InputName=$last_nm\n\n";
                                                                $tmp .= "\"\$(IntDir)\\\$(InputName).obj\" : \$(SOURCE) \"\$(INTDIR)\" \"\$(OUTDIR)\"\n";
                                                                $tmp .= "\t".massage_command($adddeps)."\n\n";
                                                                $tmp .= "# End Custom Build\n";
                                                                prt( "[dbg_v27] $lnnum:$xln: got CUSTOM event [$pname] [$fconf] [$tmp] [$adddefs]\n" ) if ($dbg_v27);
                                                                if (defined $per_file_hash{$fconf}) {
                                                                    prtw("WARNING: Already have [$fconf] in per_file_hash!\n");
                                                                }
                                                                $per_file_hash{$fconf} = $tmp;  # store it for later
                                                            } else {
                                                                $tmp = scalar keys(%atthash);
                                                                if (length($pname) && ($tmp < 4)) {
                                                                    # ignore is just <tag name="blah" />, but empty otherwise
                                                                } else {
                                                                    prtw( "WARNING: Deal with TAG=$tag - [$line] NO Decription or Command line! ($tmp)\n file=[$fil]\n" );
                                                                }
                                                            }
                                                        } else {
                                                            $tmp = scalar keys(%atthash);
                                                            $tmp = (length($pname) && ($tmp < 4)) ? 0 : 1;
                                                            # ignore if just <tag name="blah" />, but empty otherwise
                                                            if ($pname eq 'VCCLCompilerTool') {
                                                                # *TBD*
                                                                if  ($tmp) {
                                                                    # prtw( "WARNING: Deal with TAG=$tag - [$line]\n" );
                                                                }
                                                            } elsif ($pname eq 'VCResourceCompilerTool') {
                                                                # *TBD*
                                                                if  ($tmp) {
                                                                    prtw( "WARNING: Deal with TAG=$tag - [$line]\n" );
                                                                }
                                                            } else {
                                                                if  ($tmp) {
                                                                    prtw( "WARNING: Deal with TAG=$tag - [$line]\n" );
                                                                    pgm_exit(1,"TEMP EXIT 1");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            } elsif ($tag =~ /<FileConfiguration/) {
                                                $infconf = 1;
                                                $fconf = $pname;
                                                $seek = 'ExcludedFromBuild';
                                                $adddefs = '';
                                                if (defined $atthash{$seek} ) {
                                                    $adddefs = strip_quotes(trim_all($atthash{$seek}));
                                                    if (length($adddefs) && ($adddefs =~ /true/)) {
                                                        $$src_ref[-1][3] = 1;
                                                        prt( "$lnnum:$xln: last = $last_src [".$$src_ref[-1][0]."] $fconf $seek = $adddefs\n" ) if ($dbg_v14);
                                                    }
                                                }
                                                prt( "[dbg_v12] $lnnum:$xln: Entering FileConfiguration [$line] conf=[$fconf]\n") if ($dbg_v12);
                                            }
                                        }
                                    } elsif ($line =~ /^<File\s+/) {
                                        prt( "[dbg_v28] $lnnum:$xln:$tag: Entering Filter::File [$line]\n" ) if ($dbg_v28);
                                        $seek = 'RelativePath';
                                        if (defined $atthash{$seek}) {
                                            $var1 = $atthash{$seek};
                                            $var1 =~ s/>$//;
                                            $last_src = strip_dotrel(strip_quotes(trim_all($var1)));
                                            ($last_nm,$last_dir,$last_ext) = fileparse( $last_src, qr/\.[^.]*/ );
                                            if (is_c_source_extended($last_src)) {
                                                #push(@vc_c_sources,[$last_src, $fname, $flist, 0]);
                                                $var1 = (length($fname) ? $fname : get_def_src_grp());
                                                $var2 = (length($flist) ? $flist : get_def_src_filt());
                                                ### push(@vc_c_sources,[$last_src, $var1, $var2, 0]);
                                                $src_ref = \@vc_c_sources;
                                                $tmp = 'C';
                                                add_2_source_ref($src_ref, $last_src, $var1, $var2, $tmp, \$last_fpos, 1);
                                            } else {
                                                #push(@vc_h_sources,[$last_src, $fname, $flist, 0]);
                                                $var1 = (length($fname) ? $fname : get_def_hdr_grp());
                                                $var2 = (length($flist) ? $flist : get_def_hdr_filt());
                                                ### push(@vc_h_sources,[$last_src, $var1, $var2, 0]);
                                                $src_ref = \@vc_h_sources;
                                                $tmp = 'H';
                                                add_2_source_ref($src_ref, $last_src, $var1, $var2, $tmp, \$last_fpos, 1);
                                            }
                                            prt( "$lnnum:$xln: [$last_src] $tmp source\n" ) if ($dbg_v03);
                                        } else {
                                            prtw( "WARNING: $lnnum:$xln: DOES NOT CONTAIN(11) '$seek'? [$line] [$fil]\n" );
                                        }
                                        $infile = 1;
                                    }
                                }
                            } elsif ($line =~ /^<Filter\s+/) {
                                $fname = $pname;
                                $seek = 'Filter';
                                if (defined $atthash{$seek} ) {
                                    $flist = strip_quotes(trim_all($atthash{$seek}));
                                    # handle this Filter="&quot;h;hpp;hxx;hm;inl&quot;&gt;"
                                    $flist =~ s/&gt;//g;    # 20081205 - remove this, if exists
                                    $flist =~ s/&quot;/"/g; # 20081205 - put QUOTES back
                                    $flist = strip_quotes($flist);  # now again remove them
                                } else {
                                    # example: alut.vcproj
                                    # <Filter Name="ALUT Header">
                                    # <File RelativePath="..\..\..\include\AL\alut.h">
                                    # </File></Filter>
                                    prtw( "WARNING: $lnnum:$xln: DOES NOT CONTAIN(12) '$seek'? [$line] [$fil]\n" ) if ($dbg_v17);
                                }
                                prt( "$lnnum:$xln: ENTER Filter name=[$fname] list=[$flist]\n" ) if ($dbg_v11);
                                $infilt = 1;
                            } else {
                                # some VCPROJ files have NO <Filter ...><File...>...</File></Filter>
                                if ($infile) {
                                    if ($line =~ /^<\/File/) {
                                        add_any_per_file_items( $rdsp_current_sub, \%per_file_hash, $src_ref,
                                                \@configs, $last_fpos, $projname );
                                        $infile = 0;
                                        prt( "[dbg_v09] $lnnum:$xln:$tag: Exit     Files [$line]\n" ) if ($dbg_v09);
                                    } else {
                                        # processing a <Files><File ... may have
                                        # In <Files ...>
                                        # WATCH FOR THIS
                                        # <File RelativePath="..\..\scripts\pngw32.def">
                                        # <FileConfiguration Name="LIB Release|Win32" ExcludedFromBuild="true">
                                        # <Tool Name="VCCustomBuildTool" />
                                        # </FileConfiguration>
                                        # <FileConfiguration Name="LIB Debug|Win32" ExcludedFromBuild="true">
                                        # <Tool Name="VCCustomBuildTool" />
                                        # </FileConfiguration>
                                        # </File>
                                        # <FileConfiguration Name="Release|Win32" >
                                        # <Tool Name="VCCLCompilerTool" AdditionalIncludeDirectories="" PreprocessorDefinitions="" />
                                        # </FileConfiguration>
                                        # <FileConfiguration Name="Debug|Win32" >
                                        # <Tool Name="VCCLCompilerTool" AdditionalIncludeDirectories="" PreprocessorDefinitions="" />
                                        # </FileConfiguration>
                                        if ($tag =~ /<FileConfiguration/) {
                                            $infconf = 1;
                                            $fconf = $pname;
                                            $seek = 'ExcludedFromBuild';
                                            $adddefs = '';
                                            if (defined $atthash{$seek} ) {
                                                $adddefs = strip_quotes(trim_all($atthash{$seek}));
                                                if (length($adddefs) && ($adddefs =~ /true/)) {
                                                    $$src_ref[-1][3] = 1;
                                                    prt( "$lnnum:$xln: last = $last_src [".$$src_ref[-1][0]."] $fconf $seek = $adddefs\n" ) if ($dbg_v14);
                                                }
                                            }
                                            prt( "[dbg_v12] $lnnum:$xln:$tag: Entering FileConfiguration [$line]\n") if ($dbg_v12);
                                        }
                                    }
                                } elsif ($line =~ /^<File\s+/) {
                                    prt( "[dbg_v28] $lnnum:$xln:$tag: Entering File [$line]\n" ) if ($dbg_v28);
                                    %per_file_hash = ();    # clear the PER FILE HASH
                                    $seek = 'RelativePath';
                                    if (defined $atthash{$seek}) {
                                        $last_src = strip_dotrel(strip_quotes(trim_all($atthash{$seek})));
                                        ($last_nm,$last_dir,$last_ext) = fileparse($last_src, qr/\.[^.]*/ );
                                        if (is_c_source_extended($last_src)) {
                                            #push(@vc_c_sources,[$last_src, $fname, $flist, 0]);
                                            $var1 = "<none>";   # 2009/10/25 - have NONE (length($fname) ? $fname : get_def_src_grp());
                                            $var2 = "<none>";   # 2009/10/25 - have NONE (length($flist) ? $flist : get_def_src_filt());
                                            ### push(@vc_c_sources,[$last_src, $var1, $var2, 0]);
                                            $src_ref = \@vc_c_sources;
                                            $tmp = 'C';
                                            add_2_source_ref($src_ref, $last_src, $var1, $var2, $tmp, \$last_fpos, 0);
                                        } else {
                                            #push(@vc_h_sources,[$last_src, $fname, $flist, 0]);
                                            $var1 = "<none>";   # 2009/10/25 - have NONE (length($fname) ? $fname : get_def_hdr_grp());
                                            $var2 = "<none>";   # 2009/10/25 - have NONE (length($flist) ? $flist : get_def_hdr_filt());
                                            ### push(@vc_h_sources,[$last_src, $var1, $var2, 0]);
                                            $src_ref = \@vc_h_sources;
                                            $tmp = 'H';
                                            add_2_source_ref($src_ref, $last_src, $var1, $var2, $tmp, \$last_fpos, 0);
                                        }
                                        prt( "$lnnum:$xln: [$last_src] $tmp source\n" ) if ($dbg_v03);
                                    } else {
                                        prtw( "WARNING: $lnnum:$xln: DOES NOT CONTAIN(13) '$seek'? [$line] [$fil]\n" );
                                    }
                                    $infile = 1;
                                }
                            }
                        }
                    } else {
                        if ($tag =~ /<Configurations/) {
                            $inconfigs = 1; # 2009/10/15 - entered a 'Configurations' block
                            prt( "[dbg_v08] $lnnum:$xln:$tag: Entering Configurations [$line]\n" ) if ($dbg_v08);
                        } elsif ($tag =~ /<Files/) {
                            prt( "[dbg_v09] $lnnum:$xln:$tag: Entering Files [$line]\n" ) if ($dbg_v09);
                            $infiles = 1;
                        }
                    }
                }
                ###if ($infconf && (($tag =~ /<\/FileConfiguration/)||($line eq '</FileConfiguration>'))) {
                if ($infconf && ($tag =~ /<\/FileConfiguration/)) {
                    $infconf = 0;
                    prt( "[dbg_v12] $lnnum:$xln:$tag: Exit FileConfiguration 2 [$line]\n" ) if ($dbg_v12);
                }
            } else {
                if ($tag =~ /<VisualStudioProject/) {
                    $invcproj = 1;
                    ##push(@tag_stack, $tag);
                    # <VisualStudioProject
                    #  ProjectType="Visual C++" 
                    #  Version="9.00" 
                    #  Name="FlightGear"
                    #  ProjectGUID="{5C747AB8-6441-46B3-95D2-9D948C80EC77}"
                    #  TargetFrameworkVersion="131072" >
                    $seek = 'Name';
                    if (!defined $atthash{$seek} ) {
                        mydie( "ERROR: 'VisualStudioProject' DOES NOT CONTAIN(14) a project NAME! NO GO!! ABORTING!!! [$fil]\n" );
                    }
                    $projname = $pname;
                    $adddeps = '';
                    $adddefs = '';
                    $seek = 'ProjectType';
                    if (defined $atthash{$seek}) {
                        $adddefs = strip_dotrel(strip_quotes(trim_all($atthash{$seek})));
                    }
                    $seek = 'Version';
                    if (defined $atthash{$seek}) {
                        $adddeps = strip_dotrel(strip_quotes(trim_all($atthash{$seek})));
                    }
                    prt( "$lnnum:$xln: Project [$projname], using [$adddefs], version [$adddeps] ...\n" );
                }
            }
            prt( "$lnnum:$xln:".scalar @tag_stack.": $tag [$line]\n" ) if ($dbg_v01);
        }
        prtw( "WARNING: tag_stack NOT empty! ".$tag_stack[0]." [$fil]\n") if (@tag_stack);
        ${$rdsp_current_sub}{'C_SOURCES'} = [@vc_c_sources];
        ${$rdsp_current_sub}{'H_SOURCES'} = [@vc_h_sources];
        ${$rdsp_current_sub}{'APP_TYPE'} = $apptype;
        ${$rdsp_current_sub}{'-NEW_PROJECT_NAME-'} = $projname;
        if (scalar @configs > 2) {
            show_confs_warning( $fil, \@configs );
            ###pgm_exit(1,"TEMP EXIT AFTER MULTIPLE CONFIG SHOW!\n");
        }
    } else {
        mydie( "ERROR: Unable to open $fil ... $! ... check name, location ...\n" );
    }
    return $rdsp_current_sub;
}

sub fg_xml_to_lines {
    my ($rlm, @lns) = @_;
    my $intag = 0;
    my $text = '';
    my @nlines = ();
    my ($fln, $ln, $ch, $pch, $nch, $len, $i, $i2, $tag, $xml, $dnx);
    my ($lnnm, $lnb, $nlnm);
    $pch = '';
    $nch = '';
    $tag = '';
    $xml = '';
    $dnx = 0;
    $lnnm = 0;
    $nlnm = 0;
    $lnb = 0;
    my $nxtxt = '';
    foreach $fln (@lns) {
        chomp $fln;
        $ln = trim_all($fln);
        $len = length($ln);
        $lnnm++;    # count another xml line
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($ln,$i,1);
            $nch = (($i2 < $len) ? substr($ln,$i2,1) : ' ');
            if ($intag) {
                # on first SPACE
                $tag .= $ch;
                if ($ch eq '>') {
                    # end of XML tag
                    $nlnm++;
                    push(@nlines,$tag);
                    ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                    $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                    $nxtxt .= "$lnb-$lnnm: [$tag]\n";
                    $tag = '';
                    $intag = 0;
                    $xml = '';
                }
            } else {
                if ($ch eq '<') {
                    $tag = $ch; # start a tag line
                    $intag = 1; # signal in a tag
                    $xml = '';
                    $dnx = 0;
                    $lnb = $lnnm;    # set the BEGIN xml line
                }
            }
            $pch = $ch;
        }
        # done a line - this is like a SPACE
        if ($intag && length($tag)) {
            $tag .= ' ' if !($tag =~ /\s$/);
        }
    }
    if (length($tag)) {
        prtw("WARNING: xml re-lining error! Left pending tag [$tag]\nin $act_vcproj file ...\n");
    }

    if (! -f 'tempvcx.xml') {
        write2file($nxtxt,'tempvcx.xml');
        prt( "Written relined XML to 'tempvcx.xml'\n" );
    }
    return @nlines;
}

# added 07/12/2008 from fgscanvc.pl in Dell02:D:\fg\26
sub xml_array_to_lines {
    my ($rlm, @lns) = @_;
    my $intag = 0;
    my $text = '';
    my @nlines = ();
    my ($fln, $ln, $ch, $pch, $nch, $len, $i, $i2, $tag, $xml, $dnx);
    my ($lnnm, $lnb, $nlnm);
	my ($ppch, $rem, $incomm);
    $pch = '';
    $nch = '';
    $tag = '';
    $xml = '';
	$ppch = '';
    $dnx = 0;
    $lnnm = 0;
    $nlnm = 0;
    $lnb = 0;
	$incomm = 0;
	$text = '';
    foreach $fln (@lns) {
        chomp $fln;
        $ln = trim_all($fln);
        $len = length($ln);
        $lnnm++;    # count another xml line
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($ln,$i,1);
            $nch = (($i2 < $len) ? substr($ln,$i2,1) : ' ');
            if ($intag) {
                # on close of tag
                $tag .= $ch;
                if ($ch eq '>') {
                    # end of XML tag
					if (( ! $incomm) || ( $incomm && ($pch eq '-') && ($ppch eq '-') )) {
						$nlnm++;
						push(@nlines,$tag);
						### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
						$$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
						$tag = '';
						$intag = 0;
						$xml = '';
						$incomm = 0;
					}
                }
            } else {
                if ($ch eq '<') {
					if (length($text)) {
						$nlnm++;
						push(@nlines,$text);
						### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
						$$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
						$text = '';
					}
					if ($nch eq '!') {
						# potential start of comment <!-- until -->
						$rem = $len - $i;
						if (($rem > 4) && (substr($ln,$i,4) eq '<!--')) {
							$incomm = 1;
						}
					}
                    $tag = $ch; # start a tag line
                    $intag = 1; # signal in a tag
                    $xml = '';
                    $dnx = 0;
                    $lnb = $lnnm;    # set the BEGIN xml line
                } else {
					$text .= $ch;
				}
            }
			$ppch = $pch;
            $pch = $ch;
        }
        # done a line - this is like a SPACE
        if ($intag && length($tag)) {
            $tag .= ' ' if !($tag =~ /\s$/);
        }
    }
    if (length($tag)) {
        prtw("WARNING: xml re-lining error! Left pending tag [$tag]\nin $act_vcproj file ...\n");
    }
    return @nlines;
}


1;
# eof fgscanvc03.pl
