#!/usr/bin/perl -w
# NAME: fgsetfile.pl
# AIM: Process a FG *-set.xml file
# 07/05/2013 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use XML::Simple;
use Data::Dumper;
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';
my $fg_root = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_fgroot = 'C:\FG\fgdata';
my $def_file = 'C:\FG\fgdata\Aircraft\TBM-Avenger\avenger-set.xml';
##my $def_file = 'C:\FG\fgdata\Aircraft\sgs233\sgs233-set.xml';
#my $def_file = $def_fgroot.'\Aircraft\747-200\747-200-set.xml';
#my $def_file = 'C:\FG\fgdata\Aircraft\AG-14\AG-14-set.xml';
#my $def_fgroot = 'C:\FG\fgdata-2.9.0';
#my $def_file = 'C:\FG\fgdata-2.9.0\Aircraft\SenecaII\SenecaII-panelonly-set.xml';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($);

sub process_in_file($) {
    my ($inf) = @_;
    prt("Processing [$inf]...\n");
    if (! -f $inf) {
        prtw("WARNING: Can NOT locate [$inf]!\n");
        return;
    }
    my $xml = XMLin($inf);
    my ($ff,$sim,$mod,$tmp);
    my ($name,$dir) = fileparse($inf);
    ut_fix_directory(\$dir);
    my $rt = ref($xml);
    prt("Got ref = $rt\n");
    #prt(Dumper($xml));
    $load_log = 1;
    my $path = '';
    if ($rt eq 'HASH') {
        if (defined ${$xml}{'sim'}) {
            $sim = ${$xml}{'sim'};
            $rt = ref($sim);
            if ($rt eq 'HASH') {
                if (defined ${$sim}{'model'}) {
                    $mod = ${$sim}{'model'};
                    $rt = ref($mod);
                    if ($rt eq 'HASH') {
                        if (defined ${$mod}{'path'}) {
                            $path = ${$mod}{'path'};
                            $rt = ref($path);
                            if ($rt eq 'HASH') {
                                $path = '';
                            } elsif ($rt eq 'ARRAY') {
                                $path = '';
                            }
                        }
                    } elsif ($rt eq 'ARRAY') {
                        foreach $tmp (@{$mod}) {
                            $rt = ref($tmp);
                            if ($rt eq 'HASH') {
                                if (defined ${$tmp}{'path'}) {
                                    $path = ${$tmp}{'path'};
                                    $rt = ref($path);
                                    if ($rt eq 'HASH') {
                                        $path = '';
                                    } elsif ($rt eq 'ARRAY') {
                                        $path = '';
                                    } else {
                                        last;
                                    }
                                }
                            }
                        }
                    } else {
                        prt("\$mod = \${\$xml}{'sim'}{'model'}; NOT a HASH/ARRAY! got [$rt]\n");
                    }
                } elsif (defined ${$xml}{'include'}) {
                    my $inc = ${$xml}{'include'};
                    prt("Got an include file [$inc]\n");
                    $rt = ref($inc);
                    if ($rt eq '') {
                        $ff = $fg_root.$PATH_SEP.$inc;
                        if (-f $ff) {
                            process_in_file($ff);
                            return;
                        }
                        $ff = $dir.$inc;
                        if (-f $ff) {
                            process_in_file($ff);
                            return;
                        }
                    } else {
                        prt("Found 'include' as [$rt]\n");
                    }
                }
                prt("\${\$xml}{'sim'}{'model'} nor {'include'}; NOT defined\n") if (length($path) == 0);
            } else {
                prt("\$sim = \${\$xml}{'sim'}; NOT a HASH! got $rt\n");
            }
        } else {
            prt("Failed to find 'sim' in the HASH ref from $inf!\n");
        }
    } else {
        prt("XMLin gave $rt instead of a HASH!\n");
    }
    #if (defined ${$xml}{'sim'}{'model'}{'path'}) {
    #    my $path = ${$xml}{'sim'}{'model'}{'path'};
    if (length($path)) {
        $ff = $fg_root.$PATH_SEP.$path;
        if (-f $ff) {
            ##my ($n2,$d2) = fileparse($ff);
            my ($n2,$d2,$e2) = fileparse($ff, qr/\.[^.]*/);
            ut_fix_directory(\$d2);
            if ($e2 eq '.ac') {
                prt("Got MODEL file $ff\n");
                system("ac3dview $ff");
            } else {
                prt("Loading MODEL XML $ff\n");
                my $xml2 = XMLin($ff);
                if (defined ${$xml2}{'path'}) {
                    my $path2 = ${$xml2}{'path'};
                    my $ff2 = $d2.$path2;
                    if (-f $ff2) {
                        prt("Got MODEL file $ff2\n");
                        system("ac3dview $ff2");
                    } else {
                        prt("MODEL file $ff2 NOT FOUND\n");
                    }
                } else {
                    prt(Dumper($xml2));
                    $load_log = 1;
                }
            }
        } else {
            prtw("WARNING: Can NOT locate file $ff!\nfg_root=$fg_root, path=$path\n");
        }
    } else {
        prt(Dumper($xml));
        $load_log = 1;
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($fg_root) == 0) {
        $fg_root = $def_fgroot;
        prt("Set DEFAULT FG_ROOT to [$fg_root]\n");
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
