#!/perl -w
# 05/10/2008 - Part of a series of Perl scripts to compare and show changes
# in the build files of FlightGear and SimGear
# NAME: fgvcscan.pl
# AIM: Scan a single VCPROJ file, and extract information
# geoff mclane - http://geoffair.net/fg
use strict;
use warnings;
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
require 'fgdsphdrs.pl' or die "Unable to load fgdsphdrs.pl ...\n";
require 'fgscanvc.pl' or die "Unable to load fgscanvc.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'C:\FG\27\terragear-cs\projects\VC7.1\tgvpf\tgvpf.vcproj';
##my $in_file = 'alut\admin\VisualStudioDotNET\alut\alut.vcproj';
##my $in_file = 'zlib-1.2.3\projects\visualc6\zlib.vcproj';
##my $in_file = 'PLIB\src\util\ul.vcproj';
##my $in_file = 'temp\testcon.vcproj';
##my $in_file = 'lpng\projects\visualc71\libpng.vcproj';
##my $in_file = 'SimGear\SimGear.vcproj';
##my $in_file = 'FlightGear\FlightGear.vcproj';
my $out_file = 'tempvc2dsp.dsp';

my $dbg_on = 0;

# program variables
my $act_vcproj = '';
my @warnings = ();

##dbg_show_entering_files(); # for DEBUG only
dbg_show_source_files();    # for DEBUG only

my %h = process_VCPROJ( $in_file );

show_hash_results($dbg_on,\%h) if ($dbg_on);

write_hash_to_DSP($out_file, \%h, 8);

show_warnings();

close_log($outfile,0);
exit(0);

#########################################################
### SUBS

sub prtw {
    my ($tx) = shift;
    if ($tx =~ /\n$/) {
        prt($tx);
        $tx =~ s/\n$//;
    } else {
        prt("$tx\n");
    }
    push(@warnings,$tx);
}

sub show_warnings {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}

# eof - fgvcscan.pl
