#!/perl -w
# NAME: fixwmdiag.pl
# AIM: VERY SPECIFIC FIX FOR wmdiag.cpp file
# 26/07/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = 'C:\GTools\tools\wmdiag\wmdiag.cpp';
my $out_file = 'tempnwm.txt';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

# lines like
# WMSTR sTb[] = {
#    { TB_ENABLEBUTTON         ,"TB_ENABLEBUTTON", 0 }, // (WM_USER + 1)
# fix to
#    { TB_ENABLEBUTTON         ,"TB_ENABLEBUTTON", 0, 0 }, // (WM_USER + 1)
# That is just add an item to the structure

sub process_file($) {
    my ($inf) = @_;
    if (!open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open [$inf]\n");
    }
    my @lines = <INF>;
    my $lncnt = scalar @lines;
    my ($line,$ch,$i,$len,$nline,$bal);
    prt("Processing $lncnt lines, from [$inf]\n");
    my @nlines = ();
    foreach $line (@lines) {
        chomp $line;
        $len = length($line);
        $nline = '';
        #if ( $line =~ /^(\s*\{\s*\w+\s*,\s*\"\w+\"\s*,\s*(\d|\w)+)\s*\}\s*,/ ) {
        if ( $line =~ /^(\s*\{\s*(\w|\d)+\s*,\s*\"(\w|\?|\s|\(|\))+\"\s*,\s*(\d|\w|\(|\))+)\s*\}\s*,/ ) {
            $nline = $1;
            $len = length($nline);
            $bal = substr($line,$len);
            # prt("[$line]\n");
            # prt("[$nline".$bal."]\n");
            $nline .= ", 0".$bal;
            # prt("[$nline]\n");
            push(@nlines,$nline);
        } else {
            push(@nlines,$line);
            next if (length($line) == 0);
            next if ($line =~ /^\s*\/\//);
            next if ($line =~ /^#/);
            next if ($line =~ /^\s+$/);
            if ($line =~ /^\s*WMSTR/) {
                prt("$line\n");
                next;
            }
            next if ($line =~ /^\s*BOOL/);
            next if ($line =~ /^\s*\{\s*$/);
            next if ($line =~ /^\s*\}.*$/);
            next if ($line =~ /^\s*return/);
            next if ($line =~ /^\s*typedef/);
            next if ($line =~ /^\s*UINT/);
            next if ($line =~ /^\s*LPTSTR/);
            next if ($line =~ /^\s*TCHAR/);
            next if ($line =~ /^\s*C2S/i);
            next if ($line =~ /^\s*VOID/i);
            next if ($line =~ /^\s*MGHND/);
            next if ($line =~ /^\s*DWORD/);
            next if ($line =~ /^\s*if/);
            next if ($line =~ /^\s*int/);
            next if ($line =~ /^\s*strcat/);
            next if ($line =~ /^\s*strcpy/);
            next if ($line =~ /^\s*else/);
            next if ($line =~ /^\s*goto/);
            next if ($line =~ /^\s*while/);
            next if ($line =~ /^\s*sprintf/);
            next if ($line =~ /^\s*UNREFERENCED/);
            next if ($line =~ /^\s*WORD/);
            next if ($line =~ /^\s*switch/);
            next if ($line =~ /^\s*case/);
            next if ($line =~ /^\s*break/);
            next if ($line =~ /^\s*default/);
            next if ($line =~ /^\s*static/);
            next if ($line =~ /.+=.+/);
            next if ($line =~ /LOWORD/);
            next if ($line =~ /HIWORD/);
            next if ($line =~ /->/);
            next if ($line =~ /^\s*\w+\s*,/);
            next if ($line =~ /^\s*\w+\s*\+\+/);
            next if ($line =~ /^\s*\w+\s*\)\s*;/); # uMsg );
            next if ($line =~ /^\s*\w+\s*:/);
            next if ($line =~ /^\s*PTSTR/);
            next if ($line =~ /^\s*AddMFFlag/);
            next if ($line =~ /^\s*\/\*/);
            next if ($line =~ /^\s*mh/);
            next if ($line =~ /^\s*\(/);
            prt("$line\n");
        }

    }
    write2file( join("\n",@nlines)."\n", $out_file);
    prt("Written to out file [$out_file]...\n");

}

#########################################
### MAIN ###
parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-05-05\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have follwoing argument!\n")
        if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /-/);
            if (($sarg =~ /h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
}

# eof - fixwmdiag.pl
