#!/perl -w
# NAME: genstruc.pl
# AIM: not sure???
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
# prt( "$0 ... Hello, World ...\n" );

my $stg = <<EOF;
static const int8_t si_prefixes['z' - 'E' + 1]={
    ['y'-'E']= -24,
    ['z'-'E']= -21,
    ['a'-'E']= -18,
    ['f'-'E']= -15,
    ['p'-'E']= -12,
    ['n'-'E']= - 9,
    ['u'-'E']= - 6,
    ['m'-'E']= - 3,
    ['c'-'E']= - 2,
    ['d'-'E']= - 1,
    ['h'-'E']=   2,
    ['k'-'E']=   3,
    ['K'-'E']=   3,
    ['M'-'E']=   6,
    ['G'-'E']=   9,
    ['T'-'E']=  12,
    ['P'-'E']=  15,
    ['E'-'E']=  18,
    ['Z'-'E']=  21,
    ['Y'-'E']=  24,
};
EOF

my $size = ord('z') - ord('E') + 1;
prt( "Size = $size\n" );
my @arr = split("\n", $stg);
my $cnt = scalar @arr;
my $oe = ord('E');
prt( "Got $cnt lines...\n" );
my %hash = ();
my $ncnt = 0;
foreach my $line (@arr) {
	if ($line =~ /^\s*\[(.+)\]=\s*(.+),/) {
		my $pos = $1;
		my $num = $2;
		$num =~ s/\s//;
		prt( "$pos = [$num] ");
		if ($pos =~ /\'(\w{1})\'-/) {
			$ncnt++;
			my $ch = $1;
			my $och = ord($ch);
			my $dif = $och - $oe;
			prt( "$ch = $och pos = $dif" );
			if (defined $hash{$dif}) {
				prt( " ALREADY DEFINED! ");
			} else {
				$hash{$dif} = $num;
			}
		}
		prt("\n");
	}
}

my $kcnt = scalar keys(%hash);
prt( "Hash count = $kcnt, line cnt = $ncnt\n" );
my $msg = '';
for (my $i = 0; $i < $size; $i++) {
	if (defined $hash{$i}) {
		my $v = $hash{$i};
		my $ch = chr($i + $oe);
		$msg = "   $v, ";
		$msg .= ' ' while (length($msg) < 8);
		$msg .= "// $i = '$ch' - 'E'";
		prt( "$msg\n" );
	} else {
		prt( "   0,   // $i\n" );
	}
}

close_log($outfile,1);
exit(0);

# eof
