#!/perl -w
# NAME: genstruct2.pl
# AIM: REAL SPECIFIC - generate a structure
# 2009/09/25  - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $struct_def = <<EOF;
typedef struct {
    enum { N, U, A, V } kind; /* not handled / unknown / audio / video */
    int codec;          /* HB worker object id of codec */
    int codec_param;    /* param for codec (usually ffmpeg codec id) */
    const char* name;   /* description of type */
} stream2codec_t;
EOF

my $def_text = <<EOF;
#define st(id, kind, codec, codec_param, name) \
 [id] = { kind, codec, codec_param, name }
EOF

my $gen_text = <<EOF;
static const stream2codec_t st2codec[256] = {
    st(0x01, V, WORK_DECMPEG2,     0,              "MPEG1"),
    st(0x02, V, WORK_DECMPEG2,     0,              "MPEG2"),
    st(0x03, A, HB_ACODEC_MPGA,    CODEC_ID_MP2,   "MPEG1"),
    st(0x04, A, HB_ACODEC_MPGA,    CODEC_ID_MP2,   "MPEG2"),
    st(0x05, N, 0,                 0,              "ISO 13818-1 private section"),
    st(0x06, U, 0,                 0,              "ISO 13818-1 PES private data"),
    st(0x07, N, 0,                 0,              "ISO 13522 MHEG"),
    st(0x08, N, 0,                 0,              "ISO 13818-1 DSM-CC"),
    st(0x09, N, 0,                 0,              "ISO 13818-1 auxiliary"),
    st(0x0a, N, 0,                 0,              "ISO 13818-6 encap"),
    st(0x0b, N, 0,                 0,              "ISO 13818-6 DSM-CC U-N msgs"),
    st(0x0c, N, 0,                 0,              "ISO 13818-6 Stream descriptors"),
    st(0x0d, N, 0,                 0,              "ISO 13818-6 Sections"),
    st(0x0e, N, 0,                 0,              "ISO 13818-1 auxiliary"),
    st(0x0f, A, HB_ACODEC_MPGA,    CODEC_ID_AAC,   "ISO 13818-7 AAC Audio"),
    st(0x10, V, WORK_DECAVCODECV,  CODEC_ID_MPEG4, "MPEG4"),
    st(0x12, U, 0,                 0,              "MPEG4 generic"),

    st(0x14, N, 0,                 0,              "ISO 13818-6 DSM-CC download"),

    st(0x1b, V, WORK_DECAVCODECV,  CODEC_ID_H264,  "H.264"),

    st(0x80, N, 0,                 0,              "DigiCipher II Video"),
    st(0x81, A, HB_ACODEC_AC3,     0,              "AC-3"),
    st(0x82, A, HB_ACODEC_DCA,     0,              "HDMV DTS"),
    st(0x83, A, HB_ACODEC_LPCM,    0,              "LPCM"),
    st(0x84, A, 0,                 0,              "SDDS"),
    st(0x85, U, 0,                 0,              "ATSC Program ID"),
    st(0x86, A, HB_ACODEC_DCA,     0,              "DTS-HD"),
    st(0x87, A, 0,                 0,              "E-AC-3"),

    st(0x8a, A, HB_ACODEC_DCA,     0,              "DTS"),

    st(0x91, A, HB_ACODEC_AC3,     0,              "AC-3"),
    st(0x92, N, 0,                 0,              "Subtitle"),

    st(0x94, A, 0,                 0,              "SDDS"),
    st(0xa0, V, 0,                 0,              "MSCODEC"),

    st(0xea, V, WORK_DECAVCODECV,  CODEC_ID_VC1,   "VC1"),
};
EOF

# Using the $gen_text,
sub gen_structure($) {
    my ($txt) = shift;
    my @lns = split("\n",$txt);
    my ($ln, $itm, @arr, $cnt, $val);
    my ($itm0, $itm1, $itm2, $itm3, $itm4, $key);
    my ($i, $ra);
    my ($min1,$min2,$min3,$min4);
    my %str = ();
    $min1 = 0;
    $min2 = 0;
    $min3 = 0;
    $min4 = 0;
    foreach $ln (@lns) {
        $ln = trim_all($ln);
        next if (length($ln) == 0);
        if ($ln =~ /^st\((.+)\),$/) {
            $itm = $1;
            @arr = split(",",$itm);
            $cnt = scalar @arr;
            if ($cnt == 5) {
                # ok, got correct split
                $itm0 = trim_all($arr[0]);
                $itm1 = trim_all($arr[1]);
                $itm2 = trim_all($arr[2]);
                $itm3 = trim_all($arr[3]);
                $itm4 = trim_all($arr[4]);
                $val = hex($itm0);
                prt( "$val " );
                $key = sprintf("%04d", $val);
                $str{$val} = [ $itm0, $itm1, $itm2, $itm3, $itm4 ];
                $min1 = length($itm1) if (length($itm1) > $min1);
                $min2 = length($itm2) if (length($itm2) > $min2);
                $min3 = length($itm3) if (length($itm3) > $min3);
                $min4 = length($itm4) if (length($itm4) > $min4);
            } else {
                prt("Split = $cnt! WHAT [$itm] line=[$ln]\n");
            }
        } elsif ($ln =~ /^static\s+/) {
            # skip this
        } elsif ($ln eq '};') {
            # and this
        } else {
            prt("What is this line [$ln]\n");
        }
    }
    prt("\n");
    for ($i = 0; $i < 256; $i++) {
        $val = sprintf( "%3d", $i);
        if (defined $str{$i}) {
            $ra = $str{$i};
            $itm0 = ${$ra}[0];
            $itm1 = ${$ra}[1];
            $itm2 = ${$ra}[2];
            $itm3 = ${$ra}[3];
            $itm4 = ${$ra}[4];
            $itm1 .= ' ' while (length($itm1) < $min1);
            $itm2 .= ' ' while (length($itm2) < $min2);
            $itm3 .= ' ' while (length($itm3) < $min3);
            $itm4 .= ' ' while (length($itm4) < $min4);
            prt( " { $itm1, $itm2, $itm3, $itm4 }, // $val - $itm0\n" );
        } else {
            prt( " { N, 0, 0, NULL }, // $val\n" );
        }
    }
}


gen_structure($gen_text);

close_log($outfile,1);
exit(0);

# eof
