#!/perl -w
# NAME: gensvnexcl.pl
# AIM: Read a folder, and build a zip exclude file of all '.svn' folders ...
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

# features
my $removebase = 1;
my $addwild = 1;
my $useunixsep = 1;
my $base_folder = 'C:\FG\FGCOMXML\xmlrpc-c';

process_folder( $base_folder );

close_log($outfile,1);
exit(0);

######################################

sub process_folder {
    my ($inf) = shift;
    my @dirs = ();
    my ($fil, $ff, $ofil);
	if ( opendir( DIR, $inf ) ) {
		my @fils = readdir(DIR);
		closedir DIR;
        foreach $fil (@fils) {
            if (($fil eq '.')||($fil eq '..')) {
                next;
            }
            $ff = $inf;
            $ff .= "\\" if ( !($ff =~ /(\\|\/)$/) );
            $ff .= $fil;
            if ( -d $ff ) {
                if (lc($fil) eq '.svn') {
                    $ofil = $ff;
                    $ofil = remove_base($ff) if ($removebase);
                    $ofil .= '\*.*' if ($addwild);
                    $ofil =~ s/\\/\//g if ($useunixsep);
                    prt( "$ofil\n" );
                } else {
                    push(@dirs,$ff);
                }
            }
        }
    } else {
        prt( "ERROR: Failed to open directory [$inf] ...\n" );
    }
    foreach $fil (@dirs) {
        process_folder($fil);
    }
}

sub remove_base {
    my ($fil) = shift;
    return substr($fil, length($base_folder) + 1);
}

# eof
