#!/perl -w
# NAME: gentime.pl
# AIM: Just a simple example showing the use of 'localtime' builtin function.
# 27/11/2008 Added 'gmtime', to get UTC/GMT time of a file.
# 29/07/2007 - geoff mclane - http://geoffair.net/mperl/index.htm
use strict;
use warnings;
use Time::gmtime;
### use Time::gmtime qw(:FIELDS); then $tm_hour can be used
use File::stat;
my $tm = time();
my @timeData = localtime($tm);
print "$tm (seconds since system epoch - Midnight, January 1, 1970 GMT on Unix)\n";
print join(' ', @timeData); 
print " (Array of values)\n";
my $ct = get_date_time();
print "$ct - human readable form\n";
my $dt = get_YYYYMMDD_hhmmss($tm);
print "short $dt - alterative form\n";
my $ftm = stat($0)->mtime;
my $date_string = gmctime($ftm);
my $fdt = get_YYYYMMDD_hhmmss($ftm);
my $fdtu = get_YYYYMMDD_hhmmss_UTC($ftm);
print "$0 - $date_string, or\nlocal [$fdt], or\nUTC   [$fdtu]\n";

sub get_date_time {
	my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my @weekDays = qw(Sun Mon Tue Wed Thu Fri Sat Sun);
	my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset,
		$dayOfWeek, $dayOfYear, $daylightSavings) = localtime(time());
	my $year = 1900 + $yearOffset;
	my $theTime = "$hour:$minute:$second";
	my $theDate = "$weekDays[$dayOfWeek] $months[$month] $dayOfMonth, $year";
	return "$theTime, $theDate"; 
}

sub get_YYYYMMDD_hhmmss {
    my ($t) = shift;
    my @f = (localtime($t))[0..5];
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d",
        $f[5] + 1900, $f[4] +1, $f[3], $f[2], $f[1], $f[0]);
    return $m;
}

sub get_YYYYMMDD_hhmmss_UTC {
    my ($t) = shift;
    # sec, min, hour, mday, mon, year, wday, yday, and isdst.
    my $tm = gmtime($t);
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d",
        $tm->year() + 1900, $tm->mon() + 1, $tm->mday(), $tm->hour(), $tm->min(), $tm->sec());
    return $m;
}

# eof - gentime.pl
