#!/usr/bin/perl -w
# NAME: getcommits.pl
# AIM: Get gitorious commits...
# 07/07/2011 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use LWP::Simple;
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' ... Check \@INC values...\n";
require 'lib_html.pl' or die "Unable to load 'lib_html.pl' ... Check \@INC values...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = '';
my $out_url = $perl_dir."\\tempurl.txt";

my $use_html_lib = 1;

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

#my $TAG_NORM    = 0;
#my $TAG_CLOSE   = 1;
#my $TAG_CLOSED  = 2;
#my $TAG_CLOSEA  = 3;
#my $TAG_SPECIAL = 4;
#my $TAG_COMMENT = 5;
#my $TAG_TEXT    = 6;
#my $ATT_NV = '<no_value>';

my $git = 'http://gitorious.org';
my $fgx = '/fgx/fgx/commits/next';

# debug
my $dbg_01 = 0; # show tags as decoded

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub get_attr_rhash($) {
    my $txt = shift;
    my %hash = ();
    my @arr = space_split($txt);
    my ($item,@arr2,$cnt,$att,$val,$j);
    foreach $item (@arr) {
        @arr2 = split("=",$item);
        $cnt = scalar @arr2;
        $att = trim_all($arr2[0]);
        $val = '';
        if ($cnt > 1) {
            if ($cnt > 2) {
                for ($j = 1; $j < $cnt; $j++) {
                    $val .= '=' if (length($val));
                    $val .= $arr2[$j];
                }
            } else {
                $val = $arr2[1];
            }
        } else {
            next if ($att eq '/');
            $val = get_attr_no_value(); # $ATT_NV;
        }
        $hash{$att} = $val;
    }
    return \%hash;
}

sub get_url() {
    my $URL = $git.$fgx;
    my ($content);
    unless (defined ($content = get $URL)) { pgm_exit(1,"ERROR: could not get $URL\n"); } 
    write2file("$content\n",$out_url);
}
sub get_html() {
    if (! -f $out_url) {
        get_url();
    }
    if (! -f $out_url) {
        pgm_exit(1,"ERROR: No URL file [$out_url]!\n");
    }
    if (! open(FIL,"<$out_url")) {
        pgm_exit(1,"ERROR: Failed to open file [$out_url]!\n");
    }
    my @lines = <FIL>;
    close FIL;
    my $content = join("",@lines);
    return get_html_refarray($content);
}

sub get_html2() {
    if (! -f $out_url) {
        get_url();
    }
    if (! -f $out_url) {
        pgm_exit(1,"ERROR: No URL file [$out_url]!\n");
    }
    if (! open(FIL,"<$out_url")) {
        pgm_exit(1,"ERROR: Failed to open file [$out_url]!\n");
    }
    my @lines = <FIL>;
    close FIL;
    my $content = join("",@lines);
    # HTML parsing
    my ($len,$i,$ch,$nc,$nc2,$tag,$i2,$i3,$intag,$text);
    my ($inquot,$qc,$incomm,$rem,$lnn);
    my (@arr,$cnt,$j,$attrs,$ftag,$ptag,$rah,$typ);
    my ($msg);
    $len = length($content);
    $intag = 0;
    $inquot = 0;
    $incomm = 0;
    $lnn = 1;
    $text = '';
    my @tag_stack = ();
    my @html_array = ();
    for ($i = 0; $i < $len; $i++) {
        $i2 = $i + 1;
        $i3 = $i + 2;
        $ch = substr($content,$i,1);
        $nc = ($i2 < $len) ? substr($content,$i2,1) : '';
        if ($ch eq "\n") {
            $lnn++;
            $ch = ' ';
        }
        if ($intag) {
            if ($inquot) {
                $tag .= $ch;
                if ($ch eq $qc) {
                    $inquot = 0;
                }
            } else {
                $tag .= $ch;
                if (($ch eq '"')||($ch eq "'")) {
                    $inquot = 1;
                    $qc = $ch;
                } elsif ($ch eq '>') {
                    $intag = 0;
                    $tag =~ s/^<//;
                    $tag =~ s/>$//;
                    $ftag = $tag;
                    @arr = space_split($tag);
                    $tag = $arr[0];
                    $cnt = scalar @arr;
                    $attrs = '';
                    for ($j = 1; $j < $cnt; $j++) {
                        $attrs .= ' ' if (length($attrs));
                        $attrs .= $arr[$j];
                    }
                    $rah = get_attr_rhash($attrs);
                    $msg = "$lnn: ";
                    if ($tag =~ /^!/) {
                        $tag =~ s/^!//;
                        $msg .= " spl <![$tag]";
                        $typ = get_tag_special_value(); # $TAG_SPECIAL;
                    } elsif ($tag =~ /^\//) {
                        $tag =~ s/^\///;
                        $typ = get_tag_close_value(); # $TAG_CLOSE;
                        $msg .= " close </[$tag]";
                        if (@tag_stack) {
                            $ptag = pop @tag_stack;
                            if ($tag ne $ptag) {
                                prtw("WARNING: Close TAG [$ftag], NOT PREVIOUS [$ptag]!\n");
                            }
                        } else {
                            prtw("WARNING: Close TAG [$ftag], NOT ON STACK!\n");
                        }
                    } elsif ($ftag =~ /\/$/) {
                        $msg .= " closed <[$tag]";
                        $typ = get_tag_closed_value(); # $TAG_CLOSED;
                    } elsif ($tag =~ /meta/i) {
                        $msg = " unclosed meta <[$tag]";
                        $typ = get_tag_closea_value(); # $TAG_CLOSEA;
                    } elsif ($tag =~ /link/i) {
                        $msg = " unclosed link <[$tag]";
                        $typ = get_tag_closea_value(); # $TAG_CLOSEA;
                    } else {
                        push(@tag_stack,$tag);
                        $msg .= " tag <[$tag]";
                        $typ = get_tag_normal_value(); # $TAG_NORM;
                    }
                    if (length($attrs)) {
                        $msg .= " attr [$attrs]";
                    }
                    $msg .= ">";
                    prt("$msg\n") if ($dbg_01);
                    push(@html_array,[$typ,$tag,$rah,$lnn]);
                }
            }
        } else {
            if ($inquot) {
                $text .= $ch;
                if ($ch eq $qc) {
                    $inquot = 0;
                }
            } else {
                if (($ch eq '"')||($ch eq "'")) {
                    $inquot = 1;
                    $qc = $ch;
                    $text .= $ch;
                } elsif ($ch eq '<') {
                    $typ = get_tag_text_value();
                    $rah = get_attr_rhash("");
                     if (length($text)) {
                        prt("$lnn: TXT [$text]\n") if ($dbg_01);
                        push(@html_array,[$typ,$text,$rah,$lnn]);
                     }
                    $text = '';
                    if ($nc eq '!') {
                        $rem = substr($content,$i2+1);
                        if ($rem =~ /^--/) {
                            # in a comment
                            $i = $i2 + 1;
                            $rem = "!";
                            for (; $i < $len; $i++) {
                                $i2 = $i + 1;
                                $i3 = $i + 2;
                                $ch = substr($content,$i,1);
                                if ($ch eq "\n") {
                                    $lnn++;
                                    $ch = ' ';
                                }
                                $nc = ($i2 < $len) ? substr($content,$i2,1) : '';
                                $nc2 = ($i3 < $len) ? substr($content,$i3,1) : '';
                                $lnn++ if ($ch eq "\n");
                                if (($ch eq '-')&&($nc eq '-')&&($nc2 eq '>')) {
                                    $i = $i3;
                                    $rem .= "--";
                                    last;
                                }
                                $rem .= $ch;
                            }
                            push(@html_array,[get_tag_comment_value(),$rem,$rah,$lnn]);
                            next;
                        }
                    }
                    $tag = '<';
                    $intag = 1;
                } else {
                    $ch = ' ' if ($ch eq "\n");
                    if ($ch =~ /\s/) {
                        if ( length($text) && !($text =~ /\s$/) ) {
                            $text .= $ch;
                        }
                    } else {
                        $text .= $ch;
                    }
                }
            }
        }
    }
    if (@tag_stack) {
        $text = join(" ",@tag_stack);
        prtw("WARNING: End of document, with tag on stack [$text]\n");
    }
    return \@html_array;
}

sub show_html_ra($) {
    my ($ra) = @_;
    my ($cnt,$typ,$tag,$rha,$i,$lnn);
    my ($hcnt,$key,$val,$att);
    $cnt = scalar @{$ra};
    prt("HTML ref array had $cnt items\n");
    for ($i = 0; $i < $cnt; $i++) {
        $typ = ${$ra}[$i][0];
        $tag = ${$ra}[$i][1];
        $rha = ${$ra}[$i][2];
        $lnn = ${$ra}[$i][3];
        $hcnt = scalar keys(%{$rha});
        $att = '';
        foreach $key (keys %{$rha}) {
            $val = ${$rha}{$key};
            $att .= " " if (length($att));
            if ($val eq get_attr_no_value()) {
                $att .= $key;
            } else {
                $att .= "$key=$val";
            }
        }
        if ($typ == get_tag_normal_value()) {
            prt("$lnn: norm [$tag]");
        } elsif ($typ == get_tag_close_value()) {
            prt("$lnn: close [$tag]");
        } elsif ($typ == get_tag_closed_value()) {
            prt("$lnn: closed [$tag]");
        } elsif ($typ == get_tag_closea_value()) {
            prt("$lnn: closea [$tag]");
        } elsif ($typ == get_tag_special_value()) {
            prt("$lnn: spl [$tag]");
        } elsif ($typ == get_tag_comment_value()) {
            prt("$lnn: comm [$tag]");
        } elsif ($typ == get_tag_text_value()) {
            prt("$lnn: text [$tag]");
        } else {
            prt("$lnn: unknown [$tag]");
        }
        prt(" attr [$att]") if (length($att));
        prt("\n");
    }
}

#########################################
### MAIN ###
#parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
#process_in_file($in_file);
if ($use_html_lib) {
    my $ref_arr = get_html();
    show_html_refarray($ref_arr);
} else {
    # development stuff
    my $ref_arr = get_html2();
    show_html_ra($ref_arr);
}
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - template.pl
