#!/perl -w
# NAME: getimgsize.pl
# AIM: Given a folder, use Imagemagick identify to get the image sizes
# 08/12/2008 - externalise im_get_image_size(file_name)
# 08/07/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'imgsize.pl' or die "Unable to load imgsize.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ... ".scalar localtime(time())."\n" );

my $in_folder = '';

# constants
my @imgfiles = qw( .jpg .jpeg .gif .png );
my @fpfolders = qw( _vti_cnf _vti_cnf _private _derived );

# features
my $recursive = 0;
my $outjsarray = 0;

# DEBUG
my $dbg3 = 0;	# show "[$ln]
my $def_dir = 'C:\HOMEPAGE\GA\travel\maroc\jetphoto\128x128';

# program variables
my @imglist = ();    # list of JPEG files - full path name

$in_folder = pop @ARGV;
$in_folder = $def_dir if (!$in_folder || (length($in_folder) == 0));

sub is_fp_folder($) {
	my ($fil) = shift;
	foreach my $fp (@fpfolders) {
		if (lc($fp) eq lc($fil)) {
			return 1;
		}
	}
	return 0;
}

sub is_my_file {
	my ($fil) = shift;
	my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
	if (lc($ext) eq '.jpg') {
        return 1;
	}
	return 0;
}

sub get_jpg_file_list {
    my ($inf) = shift;
    if (opendir(DIR, $inf)) {
        my @files = readdir(DIR);
        closedir DIR;
        foreach my $fl (@files) {
            if (($fl eq '.') || ($fl eq '..') ||
                 is_fp_folder($fl) ) {
                next;
            }
            my $ff = $inf . "\\" . $fl;
            if (-d $ff) {
                get_jpg_file_list($ff) if ($recursive);
            } else {
                if (is_my_file($fl)) {
                    push(@imglist, [$ff, $fl, '']);
                }
            }
        }
    } else {
        prt( "ERROR: Failed to open directory [$inf] ...\n" );
    }
}

#sub im_get_image_size {
#	my ($if) = shift;
#	my $is = '';
#	if (open (IDT, "identify \"$if\"|")) {
#		my @arr2 = <IDT>;
#		close IDT;
#		foreach my $ln (@arr2) {
#			chomp $ln;
#			prt( "[$ln]\n" ) if ($dbg3);
#			if (substr($ln,0,length($if)) eq $if) {
#				my $ln2 = substr($ln,length($if));
#				$ln2 =~ s/^\s//;
#				prt( "$ln2\n" ) if ($dbg3);
#				if ($ln2 =~ /\s(\d+x\d+)\s/) {
#					$is = $1;
#				}
#			}
#		}
#	} else {
#		prt( "ERROR: I can't open [$if]\n" );
#	}
#	return $is;
#}

sub process_image_list {
    my $fcnt = scalar @imglist;
    my ($i, $file, $fil, $siz, $msg);
    for ($i = 0; $i < $fcnt; $i++) {
        $file = $imglist[$i][0];
        $fil  = $imglist[$i][1];
        $siz = im_get_image_size($file);
        $imglist[$i][2] = $siz;
        prt( "$siz $fil\n" );
    }
    if ($outjsarray) {
        $msg = '';
        for ($i = 0; $i < $fcnt; $i++) {
            $file = $imglist[$i][0];
            $fil  = $imglist[$i][1];
            $siz  = $imglist[$i][2];
            $msg .= '"'.$fil.'|'.$siz.'",'."\n";
        }
        write2file($msg, 'tempjs.js');
        prt( "Results written to tempjs.js ...\n" );
    }
}

get_jpg_file_list($in_folder);

if (@imglist) {
    prt( "Processing ".scalar @imglist." files from $in_folder ...\n" );
    process_image_list();
} else {
    prt( "Did NOT find any JPG files in $in_folder ...\n" );
}

close_log($outfile,1);
exit(0);

##############################
# eof - getimgsize.pl

