#!/perl -w
# NAME: gettaf01.pl
# AIM: Get the TAF text from a URL page per directory 
# 25/01/2008 - geoff mclane
# references
# see from : http://aviationweather.gov/static/help/taf-decode.php - see html/taf-decode.htm
# from : http://mbev.net/wikka/METARSandTAFS
# KJAX 020256Z 02003KT 10SM TSRA OVC01OCB SCT100 BKN130 18/17 A2996 
# METAR's will always be published in the same order: see: html/METARSandTAFS.htm
# http://weather.noaa.gov/pub/SL.us008001/DF.an/DC.sflnd/DS.synop
# SEE : http://www.nws.noaa.gov/oso/oso1/oso12/document/guide.shtml for DECODE
use strict;
use warnings;
use Socket;
use LWP::Simple;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require "htmltools.pl" or die "Missing htmltools.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
my $tmpdir = 'tempdir.txt';
my $tmphrf = 'temphref.txt';
my $tmptaf = 'temptaf.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $fetchtafs = 1;

my $TAFBASE  = 'http://weather.noaa.gov/pub/data/forecasts/taf/stations/';
my $testurl1 = $TAFBASE. 'KSFO.TXT';
my $testurl2 = 'http://weather.noaa.gov/pub/data/forecasts/taf/stations/XS50.TXT';
my $testtaf = 'KSFO 231456Z 03009KT 10SM FEW009 OVC020 06/04 A2999 RMK AO2 RAB25E33 SLP156 P0000 60003 T00610039 55000';

my $dbg1 = 0;	# show fetched data ...
my $dbg2 = 0;	# show trimmed fetched data ...

my $txt = '';
my $hrf = '';
my $dcnt = 0;
my $cnt = 0;
my $tcnt = 0;
my @taflist = ();
my @tafhrefs = ();

if (open HF, "<$tmphrf") {
	@tafhrefs = <HF>;
	close HF;
	$cnt = scalar @tafhrefs;
	prt( "Got $cnt HREFS ... from FILE $tmphrf ...\n" );
} else {
	if (open IF, "<$tmpdir") {
		prt( "Reading from file $tmpdir ...\n" );
		my @arr = <IF>;
		close IF;
		$txt = join(' ',@arr);
	} else {
		prt( "Fetching from web ...\n" );
		$txt = get($TAFBASE);
		prt( "Writing $tmpdir file ...\n" );
		write2file($txt, $tmpdir);
	}
	my @tmptafhrefs = collect_hrefs($txt);
	$cnt = scalar @tmptafhrefs;
	prt( "Got $cnt temporary HREFS ...\n" );
	foreach my $hrf (@tmptafhrefs) {
		if ($hrf =~ /^\w{4}\.{1}TXT$/) {
			push(@tafhrefs, $hrf);
		} else {
			prt( "Discarding [$hrf] ...\n" );
			$dcnt++;
		}
	}
	$txt = join("\n",@tafhrefs);
	prt( "Writing $tmphrf file ...\n" );
	write2file($txt, $tmphrf);
	$cnt = scalar @tafhrefs;
	prt( "Got $cnt HREFS ... discarded $dcnt ...\n" );
}

if ($fetchtafs) {
	if (open TF, "<$tmptaf") {
		@taflist = <TF>;
		close TF;
		$tcnt = scalar @taflist;
		prt( "Got $tcnt TAFS ... from file $tmptaf ...\n" );
	} else {
		prt( "Doing web fetch URL ... moment ...\n" );
		foreach my $hrf (@tafhrefs) {
			chomp $hrf;
			my $url = $TAFBASE.$hrf;
			fetch_url($url, $hrf);
		}
		$txt = join("\n",@taflist);
		prt( "Writing $tmptaf file ...\n" );
		write2file($txt, $tmptaf);
		$tcnt = scalar @taflist;
		prt( "Got $tcnt TAFS ... from WEB GET ...\n" );
	}
}

close_log($outfile,1);
exit(0);



#################################
sub replace_all_belowsp {
	my ($txt) = shift;
	my $ntxt = '';
	my $tl = length($txt);
	for (my $i = 0; $i < $tl; $i++) {
		my $ch = substr($txt,$i,1);
		my $val = ord($ch);
		if ($val < 32) {
			$ch = ' ';
		}
		$ntxt .= $ch;
	}
	return $ntxt;
}

sub fetch_url {
	my ($url, $hrf) = @_;
	prt( "Fetching: $url\n" );
	my $txt = get($url);
	if ($txt && length($txt)) {
		prt( "$txt\n" ) if ($dbg1);
		# the TEXT - something like
		# 2008/01/22 11:00
		# TAF LFPO 221100Z 221818 20006KT 9999 SCT025 SCT040 
		#      BECMG 1820 6000 SCT004 
		#      TEMPO 2002 2000 BR BKN003 
		#      TEMPO 0408 -RADZ BKN006 
		#      BECMG 0810 BKN012 
		#      BECMG 1214 BKN018
		my $taftxt = replace_all_belowsp($txt);
		$taftxt = trim_all($taftxt);
		prt( "$taftxt\n" ) if ($dbg2);
		# 2008/01/22 11:00 TAF LFPO 221100Z 221818 20006KT 9999 SCT025 SCT040 BECMG 1820 6000 SCT004 TEMPO 2002 2000 BR BKN003 TEMPO 0408 -RADZ BKN006 BECMG 0810 BKN012 BECMG 1214 BKN018
		# 2008/01/22 17:00 TAF LFPO 221700Z 230024 20005KT 9999 SCT040 BECMG 0002 4000 BR BKN040 TEMPO 0205 2500 BR SCT006 BECMG 0810 19012KT BECMG 1416 BKN025
		push(@taflist, "$hrf $taftxt");
	} else {
		prt( "FAILED to get URL $url ...\n" );
	}
}

# eof - gettaf01.pl
