#!/perl -w
# NAME: imagemagic.pl
# AIM: Test of ImageMagic installation
use strict;
use warnings;
use Image::Magick;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
my ($image, $x);

$image = Image::Magick->new;
$x = $image->Read('girl.png', 'logo.png', 'rose.png');
warn "$x" if "$x";
$x = $image->Crop(geometry=>'100x100+100+100');
warn "$x" if "$x";
$x = $image->Write('x.png');
warn "$x" if "$x";


close_log($outfile,1);
exit(0);

# eof
