#!/usr/bin/perl -w
# NAME: in2cmake.pl
# AIM: Try to convert an *.in file to cmake format
# 06/02/2014 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-02-06";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'F:\FG\18\gdal-1.9.1\port\cpl_config.h.in';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$len,$i,$i2,$tline,$incomm,$ch,$nc,$comment);
    my ($res,$off,$cmake,$tmp,$cmake2);
    my ($cmvar,$var);
    my $def1 = "Define to 1 if you have the ";
    my $def1len = length($def1);
    $lnn = 0;
    $incomm = 0;
    $comment = '';
    $cmake = '';
    $cmake2 = '';
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $tline = trim_all($line);
        $len = length($tline);
        next if ($len == 0);    # skip blank lines
        $len = length($line);
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($line,$i,1);
            $nc = ($i2 < $len) ? substr($line,$i2,1) : "";
            if ($incomm) {
                if (($ch eq "*")&&($nc eq '/')) {
                    $comment .= "*/";
                    $incomm = 0;
                    $off = index($comment,$def1);
                    if ($off == -1) {
                        prt("$comment\n");
                    } else {
                        $res = substr($comment,$off+$def1len);
                        if ($res =~ /header/) {
                            if ($res =~ /<(.+)>\s+header/) {
                                # check_include_file(windows.h   HAVE_WINDOWS_H)
                                $tmp = $1;
                                $var = $tmp;
                                $var = uc($var);
                                $var =~ s/\./_/g;
                                $var =~ s/\//_/g;
                                $cmvar = 'HAVE_'.$var;
                                $cmake .= "check_include_file($tmp $cmvar)\n";
                                $cmake2 .= "#cmakedefine $cmvar 1\n";
                            } else {
                                prt("If you HAVE [".$res."]\n");
                            }
                        } elsif ($res =~ /function/) {
                            # If you have [`snprintf' function. */]
                            if ($res =~ /`(.+)'\s+function/) {
                                $tmp = $1;
                                $var = $tmp;
                                $var = uc($var);
                                $var =~ s/\./_/g;
                                $var =~ s/\//_/g;
                                $cmvar = 'HAVE_'.$var;
                                $cmake .= "check_function_exists($tmp $cmvar)\n";
                                $cmake2 .= "#cmakedefine $cmvar 1\n";
                            } else {
                                prt("If you Have [".$res."]\n");
                            }
                        } else {
                            prt("If you have [".$res."]\n");
                        }
                    }
                    $i++;
                } else {
                    $comment .= $ch;
                }
            } else {
                if (($ch eq '/') && ($nc eq '*')) {
                    $incomm = 1;
                    $i++;
                    $comment = "/*";
                }
            }
        }
        if ($incomm) {
            $comment .= "\n";
        }
    }
    if (length($cmake)) {
        prt("\nFor CMakeLists.txt file\n");
        prt($cmake);
        prt("\nFor config.h.cmake file\n");
        prt($cmake2);
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
