#!/usr/bin/perl
#< inches to H-pascal/Mb

my $INCH_TO_PASCAL = 3386.38866667;
my $PASCAL_TO_INCH = 0.000295299830714;

# QNH with pressure below STD (1013.25 Hpa/Mb)

sub prt($) { print shift; }

if (@ARGV) {
    my $inchs = $ARGV[0];
    # if ($inchs =~ /^(\d+|\.)$/) 
    if ($inchs =~ /^[-+]?[0-9]*\.?[0-9]+$/) {
        my $pascal = $inchs * $INCH_TO_PASCAL;
        my $pas = int(($pascal / 100) * 100) ;
        $pas /= 100;
        prt("Inches $inchs = $pas Hpa/Mb ($pascal pascal)\n");
    } else {
        prt("Does not appear to be a decimal number [$inchs]!\n");
    }
} else {
    prt("Give decimal inches to convert to pascal\n");
}

# eof
