#!/Perl
# AIM: Output ISO 3166 table, and
#
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file and some other utility subs
require "htmltools.pl" or die "Missing htmltools.pl ...\n";

my $dbg1 = 0;
my $dbg2 = 0;
my $dbg3 = 0;
my $dbg4 = 0;
my $dbg5 = 0;
my $dbg6 = 0;

# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

$head = <<EOF;
<html>
<head>
<title>ISO 3166 table</title>
<style type="text/css">
<!--
p.contentBody { font-family:"Courier New"; }
-->
</style> 
</head>
<body>
<p align="center">
EOF

$tail = <<EOF;
</p>
</body>
</html>
EOF

$iso3166table = <<EOF;
            <table cellspacing="0" border="1" cellpadding="8" summary="List of ISO 3166">
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">AFGHANISTAN <a name="af"></a> 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AF 
                </td>
              </tr>
			  <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">&Aring;LAND ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AX
                </td>
              </tr>
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ALBANIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ALGERIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">DZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">AMERICAN SAMOA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ANDORRA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ANGOLA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ANGUILLA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ANTARCTICA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AQ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ANTIGUA AND BARBUDA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ARGENTINA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ARMENIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ARUBA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">AUSTRALIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">AUSTRIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">AZERBAIJAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BAHAMAS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BAHRAIN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BANGLADESH 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BARBADOS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BB 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BELARUS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BELGIUM 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BELIZE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BENIN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BJ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BERMUDA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BHUTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BOLIVIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BOSNIA AND HERZEGOVINA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BOTSWANA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BOUVET ISLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BV 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BRAZIL 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BRITISH INDIAN OCEAN TERRITORY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BRUNEI DARUSSALAM 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BULGARIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BURKINA FASO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">BURUNDI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">BI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CAMBODIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CAMEROON 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CANADA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CAPE VERDE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CV 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CAYMAN ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CENTRAL AFRICAN REPUBLIC 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CHAD 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CHILE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CHINA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CHRISTMAS ISLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CX 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">COCOS (KEELING) ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">COLOMBIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">COMOROS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CONGO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CONGO, THE DEMOCRATIC REPUBLIC OF THE (Zaire) 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">COOK ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">COSTA RICA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">C&Ocirc;TE D'IVOIRE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CROATIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">HR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CUBA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CYPRUS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">CZECH REPUBLIC 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">DENMARK 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">DK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">DJIBOUTI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">DJ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">DOMINICA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">DM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">DOMINICAN REPUBLIC 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">DO 
                </td>
              </tr>
                           <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ECUADOR 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">EC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">EGYPT 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">EG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">EL SALVADOR 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SV 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">EQUATORIAL GUINEA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GQ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ERITREA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ER 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ESTONIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">EE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ETHIOPIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ET 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FALKLAND ISLANDS (MALVINAS) 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">FK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FAROE ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">FO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FIJI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">FJ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FINLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">FI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FRANCE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">FR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FRENCH GUIANA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FRENCH POLYNESIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">FRENCH SOUTHERN TERRITORIES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GABON <a name="gk"></a> 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GAMBIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GEORGIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GERMANY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">DE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GHANA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GIBRALTAR 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GREECE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GREENLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GRENADA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GUADELOUPE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GP 
                </td>
              </tr>
              <tr>
                <td valign="TOP"><span class="contentBody">GUAM </span></td>
                <td valign="TOP"><span class="contentBody">GU</span></td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GUATEMALA</td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GT</td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GUERNSEY</td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GG</td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GUINEA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GUINEA-BISSAU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">GUYANA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">HAITI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">HT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">HEARD ISLAND AND MCDONALD ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">HM 
                </td>
              </tr>
<!--              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">HOLY SEE (VATICAN CITY STATE) 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VA 
                </td>
              </tr>  -->
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">HONDURAS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">HN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">HONG KONG 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">HK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">HUNGARY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">HU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ICELAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">INDIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">INDONESIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ID 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">IRAN, ISLAMIC REPUBLIC OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">IRAQ 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IQ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">IRELAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IE 
                </td>
              </tr>
              <tr class="contentBody">
                <td valign="TOP">ISLE OF MAN </td>
                <td valign="TOP">IM</td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ISRAEL 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ITALY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">IT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">JAMAICA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">JM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">JAPAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">JP 
                </td>
              </tr>
              <tr class="contentBody">
                <td valign="TOP">JERSEY</td>
                <td valign="TOP">JE</td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">JORDAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">JO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KAZAKHSTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KENYA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KIRIBATI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KP 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KOREA, REPUBLIC OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KUWAIT 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">KYRGYZSTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LAO PEOPLE'S DEMOCRATIC REPUBLIC <a name="lr"></a> 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LATVIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LV 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LEBANON 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LB 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LESOTHO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LIBERIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LIBYAN ARAB JAMAHIRIYA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LIECHTENSTEIN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LITHUANIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">LUXEMBOURG 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MACAO
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MADAGASCAR 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MALAWI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MALAYSIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MALDIVES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MV 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MALI 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ML 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MALTA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MARSHALL ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MARTINIQUE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MQ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MAURITANIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MAURITIUS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MAYOTTE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">YT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MEXICO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MX 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MICRONESIA, FEDERATED STATES OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">FM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MOLDOVA, REPUBLIC OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MONACO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MONGOLIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MONTSERRAT 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MOROCCO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MOZAMBIQUE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">MYANMAR 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NAMIBIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NAURU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NEPAL 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NP 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NETHERLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NETHERLANDS ANTILLES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NEW CALEDONIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NEW ZEALAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NICARAGUA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NIGER 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NIGERIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NIUE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NORFOLK ISLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NORTHERN MARIANA ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">MP 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">NORWAY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">NO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">OMAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">OM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PAKISTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PALAU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PALESTINIAN TERRITORY, OCCUPIED 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PANAMA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PAPUA NEW GUINEA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PARAGUAY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PERU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PHILIPPINES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PITCAIRN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">POLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PORTUGAL 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">PUERTO RICO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">QATAR 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">QA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">R&Eacute;UNION 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">RE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ROMANIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">RO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">RUSSIAN FEDERATION 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">RU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">RWANDA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">RW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAINT HELENA <a name="sz"></a> 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAINT KITTS AND NEVIS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">KN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAINT LUCIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAINT PIERRE AND MIQUELON 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">PM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAINT VINCENT AND THE GRENADINES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAMOA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">WS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAN MARINO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAO TOME AND PRINCIPE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ST 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SAUDI ARABIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SENEGAL 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SN 
                </td>
              </tr>
			  <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SERBIA AND MONTENEGRO
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CS
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SEYCHELLES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SIERRA LEONE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SL 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SINGAPORE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SLOVAKIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SLOVENIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SOLOMON ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SB 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SOMALIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SOUTH AFRICA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ZA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GS 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SPAIN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ES 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SRI LANKA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">LK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SUDAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SD 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SURINAME 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SVALBARD AND JAN MAYEN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SJ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SWAZILAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SWEDEN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SWITZERLAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">CH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">SYRIAN ARAB REPUBLIC 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">SY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TAIWAN, PROVINCE OF CHINA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TW 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TAJIKISTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TJ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TANZANIA, UNITED REPUBLIC OF 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">THAILAND 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TH 
                </td>
              </tr>
			   <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TIMOR-LESTE
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TL
                </td>
              </tr>
			  
			  
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TOGO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TOKELAU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TK 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TONGA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TO 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TRINIDAD AND TOBAGO 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TT 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TUNISIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TURKEY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TR 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TURKMENISTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TURKS AND CAICOS ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TC 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">TUVALU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">TV 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UGANDA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">UG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UKRAINE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">UA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UNITED ARAB EMIRATES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">AE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UNITED KINGDOM 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">GB 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UNITED STATES 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">US 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UNITED STATES MINOR OUTLYING ISLANDS 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">UM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">URUGUAY 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">UY 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">UZBEKISTAN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">UZ 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">VANUATU 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VU 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">Vatican City State (HOLY SEE) 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VA 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">VENEZUELA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VE 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">VIET NAM 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VN 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">VIRGIN ISLANDS, BRITISH 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VG 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">VIRGIN ISLANDS, U.S. 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">VI 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">WALLIS AND FUTUNA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">WF 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">WESTERN SAHARA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">EH 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">YEMEN 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">YE 
                </td>
              </tr>
<!--                            <tr> 
                <td valign="TOP" colspan=2> 
                  <p class="contentBody">Zaire see CONGO, THE DEMOCRATIC REPUBLIC OF THE 
                </td>
              </tr> -->
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ZAMBIA 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ZM 
                </td>
              </tr>
              <tr> 
                <td width="88%" valign="TOP"> 
                  <p class="contentBody">ZIMBABWE 
                </td>
                <td width="12%" valign="TOP"> 
                  <p class="contentBody">ZW 
                </td>
              </tr>
            </table>
EOF

my $test1 = 0;
my $test2 = 0;
my $tlen = 0;
if ($test1) {
	my $ntxt = adjustedtabletext();
	$tlen = length($ntxt);
	prt("len=$tlen - New text [$ntxt]\n");
	close_log($outfile,1);
	exit(1);
} elsif ($test2) {
	my $ntxt = removetag($iso3166table, 'p');
	$ntxt = dropcomments($ntxt);
	$ntxt = htmlexpand($ntxt);
	$ntxt = collecthrefs($ntxt,1); # collect, and DELETE
	$ntxt = removetagattrib( $ntxt,'td' );
	$ntxt = inlinetagmax( $ntxt, 'td', 80 );
	$ntxt = trimblanklines( $ntxt );
	prt("New text [$ntxt]\n");
	close_log($outfile,1);
	exit(1);
}
my $file1 = 'tempiso3166.htm';
my $file2 = 'tempiso31662.htm';
my $msg = $head;
my $hash = '';
my @ISO3166 = ();
$msg .= $iso3166table;
$msg .= $tail;

write2file( $msg, $file1 );

my $txt = adjustedtabletext();

$msg = striptag($head,'style');

##@ISO3166 = processtxt($txt);
##$hash = Array2Text(@ISO3166);
processtxt($txt);
$hash = Array2Text();

$msg .= $txt;
$msg .= $hash;
$msg .= $tail;

write2file( $msg, $file2 );

close_log($outfile,1);
##system( $file1 );
system( $file2 );
exit(0);

sub adjustedtabletext {
	my $ntxt = htmlexpand($iso3166table);
	$tlen = length($ntxt);
	prt( "len=$tlen - Removing tag <p> ...\n" );
	$ntxt = removetag($ntxt, 'p');
	$ntxt = htmlcleanall( $ntxt );
	$tlen = length($ntxt);
	prt( "len=$tlen - Inlining <td> tag...\n" );
	$ntxt = inlinetagmax( $ntxt, 'td', 80 );
	$tlen = length($ntxt);
	prt( "len=$tlen - Trim blank lines...\n" );
	$ntxt = trimblanklines( $ntxt );
	return $ntxt;
}

sub processtxt {
	my ($t) = shift;
	my $len = length($t);
	my $ntxt = '';
	prt("Processing $len chars for a table ...\n");
	my $i = 0;
	my $ch = '';
	my $tag = '';
	my $tg = 'td';
	my $ltag = 0;
	my $intbl = 0;
	my $inrow = 0;
	my $rowcnt = 0;
	my $colcnt = 0;
	my $ctxt = '';
	my $ctxt1 = '';
	my $ctxt2 = '';
	my @arr = ();
	for ($i = 0; $i < $len; $i++) {
		$ch = substr($t,$i,1);
		if ($ch eq '<') {
			$tag = html_next_tag(substr($t,$i));
			if ($intbl) {
				if ($tag =~ /^<\/table>$/i) {
					prt("Exit the table ...\n");
					$intbl = 0;
				} else {
					if ($inrow) {
						if ($tag =~ /^<\/tr.*>$/i) {
							prt("Exit row $rowcnt ...\n");
							$inrow = 0;
						} elsif ($tag =~ /^<td.*>$/) {
							$colcnt++;
							$ltag = length($tag);
							$ctxt = html_text_2_end( substr($t, $i+$ltag), $tg );
							$ctxt =~ s/&Aring;//i;
							prt("Entering $tag column $colcnt ...ctxt=[$ctxt]\n");
							if ($colcnt == 1) {
								$ctxt1 = $ctxt;
							} elsif ($colcnt == 2) {
								$ctxt2 = $ctxt;
								# push    Country   ISO
								push(@arr, [$ctxt1, $ctxt2]);
							}
						} elsif ($tag =~ /^<\/td>$/) {
							prt("Exit column $colcnt ...\n");
						}
					} else {
						if ($tag =~ /^<tr.*>$/i) {
							$rowcnt++;
							prt("Entering row $rowcnt ...\n");
							$inrow = 1;
							$colcnt = 0; # reset column counter
							$ctxt1 = '';
							$ctxt2 = '';
						}
					}
				}
			} elsif ($tag =~ /^<table.*>$/i) {
				prt("Entering the table ...\n");
				$intbl = 1;
			}
		}
	}
	$ltag = scalar @arr;
	prt("Collected $ltag Country, ISO pairs ...\n");
	@ISO3166 = @arr;
}

sub Array2Text {
	my @arr = @ISO3166;
	my $ltag = scalar @arr;
	my $ntxt = '';
	if ($ltag) {
		$ntxt = "<p>List of $ltag Country, ISO pairs ...</p>\n";
		$ntxt .= "<pre>$ltag ISO 3166\n";
		$ntxt .= "my %ISO3166 = (\n";
		for ($i = 0; $i < $ltag; $i++) {
			$ctxt1 = $arr[$i][0];
			$ctxt2 = $arr[$i][1];
			$ntxt .= "'$ctxt2' => '$ctxt1'";
			if (($i + 1) < $ltag) {
				$ntxt .= ",";
			}
			$ntxt .= "\n";
		}
		$ntxt .= ");</pre>\n";
	} else {
		prt("GOT NO Country, ISO pairs ...\n");
	}
	return $ntxt;
}

sub processtxt2 {
	my ($t) = shift;
	my $len = length($t);
	my @arr = split(/\n/,$t);
	my $lns = scalar @arr;
	my $ntxt = '';
	prt( "Got $len characters, now in $lns lines to process ...\n" );
	foreach my $ln (@arr) {
		if (substr($ln, length($ln)-1, 1) eq "\r") {
			$ln = substr($ln, 0, length($ln)-1);
		}
		$ntxt .= $ln."\n";
	}
	write2file( $ntxt, "tempnew.txt" );
	system( "tempnew.txt" );
}

sub html_next_tag {
	my ($nttxt) = shift;
	my $ln = length($nttxt);
	my $nch = '';
	my $ntag = '';
	my $i2 = $ln;
	if ($i2 > 20) { $i2 = 20; }
	prt( "Finding NEXT tag in $ln ... begin[".substr($nttxt,0,$i2)."]\n" ) if ($dbg1);
	for ($i2 = 0; $i2 < $ln; $i2++) {
		$nch = substr($nttxt,$i2,1);
		if ($nch eq '<') {
			$ntag = $nch;
			$i2++;
			for ( ; $i2 < $ln; $i2++) {
				$nch = substr($nttxt,$i2,1);
				$ntag .= $nch;
				if ($nch eq '>') {
					last;
				}
			}
			if ( !($nch eq '>') ) {
				$ntag = '';
			}
			last;
		}
	}
	prt( "Returning tag [$ntag] len=".length($ntag)." ...\n" ) if ($dbg1);
	return $ntag;
}

sub html_next_text {
	my ($txt) = shift;
	my $ln = length($txt);
	my $ch = '';
	my $ntxt = '';
	my $i2 = $ln;
	if ($i2 > 30) {	$i2 = 30; }
	prt( "NEXT text in $ln ... [".substr($txt,0,$i2)."]\n" ) if ($dbg1);
	for ($i2 = 0; $i2 < $ln; $i2++) {
		$ch = substr($txt,$i2,1);
		if ($ch eq '<') {
			last;
		} else {
			$ntxt .= $ch;
		}
	}
	prt( "Returning text [$ntxt] len=".length($ntxt)." ...\n" ) if ($dbg1);
	return $ntxt;
}

sub html_text_2_end {
	my ($txt, $tag) = @_;
	my $rtxt = html_next_text($txt);
	my $ntag = html_next_tag( substr($txt, length($rtxt)) );
	my $lcnt = 0;
	prt( "Next text end at [</$tag>] rtxt=[$rtxt] ntag=[$ntag] ...\n" ) if ($dbg1);
	while (length($ntag)) {
		if ($ntag =~ /^<\/$tag>$/i) {
			prt("$lcnt FOUND: Returning [$rtxt] len=".length($rtxt)."\n") if ($dbg1);
			return $rtxt;
		} else {
			$lcnt++;
			$rtxt .= $ntag;
			$rtxt .= html_next_text( substr($txt, length($rtxt)) );
			$ntag = html_next_tag( substr($txt, length($rtxt)) );
			prt( "$lcnt - Next end rtxt=[$rtxt] ntag=[$ntag] ...\n" ) if ($dbg1);
		}
	}
	prt("***NOT FOUND***: Returning [$rtxt] len=".length($rtxt)."\n");
	return $rtxt;
}

sub inlinetagmax {
	my ($tx, $tg, $mx) = @_;
	my $len = length($tx);
	my $ch = '';
	my $tag = '';
	my $ntxt = '';
	my $rtt = '';
	my $tt = '';
	my $i = 0;
	my $j = 0;
	my $off = 0;
	my $ntag = '';
	my $skip = '';
	my $rlen = 0;
	my $tlen = 0;
	if (length($tg) == 0) {
		return $tx;
	}
	prt( "Processing $len chs for tag [$tg], max=$mx ...\n" );
	for ($i = 0; $i < $len; $i++) {
		$ch = substr($tx, $i, 1);
		if ($ch eq '<') {
			$tag = html_next_tag(substr($tx, $i));
			if ($tag =~ /^<$tg.*>$/) {
				$off = length($tag);
				prt( "\n******** Found tag [$tag] $i ($off) ... ********\n" ) if ($dbg4);
				$rtt = html_text_2_end(substr($tx, $i+$off),$tg);
				$rlen = length($rtt);
				$tt = trimbothends($rtt);
				$tlen = length($tt);
				### if (length($tt)) {
				if ($tlen && ($tlen < $mx)) {
					$off += $rlen;
					$ntag = html_next_tag(substr($tx,$i+$off));
					prt( "-> Found tag [$tag]+[$tt]+[$ntag] $i ($off) rlen=$rlen tlen=$tlen...\n" ) if ($dbg6);
					##$off += length($ntag);
					$ntxt .= ($tag . $tt); ### . $ntag;
					$skip = substr($tx, $i, $off);
					prt( "\n--> About to SKIP [$skip] len=". length($skip) . " i=$i off=$off ...\n" ) if ($dbg5);
					$i += ($off - 1);
					$j = $len - $i;
					if ($j > 120) {
						$j = 120;
					}
					prt( "\n---> Continue at [". substr($tx,$i+1,$j)."] $i ($off)...\n" ) if ($dbg5);
				} else {
					$ntxt .= $ch;
				}
			} else {
				$ntxt .= $ch;
			}
		} else {
			$ntxt .= $ch;
		}
	}
	return $ntxt;
}


# eof - iso3166.pl
