#!/usr/bin/perl
#< lib_css.pl
use strict;
use warnings;

sub css_content_2_hash($$$) {
    my ($cont,$dbg,$lnn) = @_;
    my %hash = ();
    my ($len,$ch,$i,$hadcolon,$key,$val);
    $cont = trim_all($cont);
    $len = length($cont);
    $hadcolon = 0;
    $key = '';
    $val = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($cont,$i,1);
        if ($hadcolon) {
            if ($ch eq ';') {
                # end of item
                $hadcolon = 0;
                $key = trim_all($key);
                $val = trim_all($val);
                if ( length($key) && length($val) ) {
                    $hash{$key} = $val;
                } elsif (length($key)) {
                    prtw("WARNING:$lnn: Got key $key with NO VALUE!\n");
                } elsif (length($val)) {
                    prtw("WARNING:$lnn: Got value $val with NO KEY!\n");
                }
                $key = '';
                $val = '';
            } else {
                $val .= $ch;
            }
        } else {
            if ($ch eq ':') {
                $hadcolon = 1;
            } elsif ($ch =~ /\s/) {
                # ignore space here
            } else {
                $key .= $ch;
            }
        }
    }
    if ( length($key) && length($val) ) {
       $hash{$key} = $val;
    } elsif (length($key)) {
        prtw("WARNING:$lnn: Got key $key with NO VALUE!!\n");
    } elsif (length($val)) {
        prtw("WARNING:$lnn Got value $val with NO KEY!!\n");
    }
    return \%hash;
}

sub show_content_hash($$) {
    my ($class,$rh) = @_;
    my ($key,$val,$msg);
    $msg = '';
    foreach $key (sort keys %{$rh}) {
        $val = ${$rh}{$key};
        $msg .= "\n$key:$val;";
    }
    prt("$class { $msg\n}\n");
}

sub get_class_counts($) {
    my %h_classes = ();
    my %h_names = ();
    my %h_elements = ();
    my %h_eleclass = ();
    my %h_elehash = ();
    my %h_elecolon = ();
    my %h_eleplus = ();
    my %h_others = ();
    my $rhash = shift;
    my $len = scalar keys(%{$rhash});
    my $elecnt = 0;
    my $dotcnt = 0;
    my $eledot = 0;
    my $hashcnt = 0;
    my $elehash = 0;
    my $elecolon = 0;
    my $eleplus = 0;
    my $other = 0;
    my $cont = '';
    my ($tag,@arr,$class,$ra);
    foreach $tag (keys %{$rhash}) {
        if ($tag =~ /^\./) {
            $dotcnt++;
            $tag = substr($tag,1);
            $h_classes{$tag} = 1;
        } elsif ($tag =~ /^\#/) {
            $hashcnt++;
            $tag = substr($tag,1);
            $h_names{$tag} = 1;
        } elsif ($tag =~ /^\w+$/) {
            $elecnt++;
            $h_elements{$tag} = 1;
        } elsif ($tag =~ /^\w+\./) {
            $eledot++;
            @arr = split(/\./,$tag);
            $tag = $arr[0];
            $class = $arr[1];
            $h_eleclass{$tag} = [] if (!defined $h_eleclass{$tag});
            $ra = $h_eleclass{$tag};
            #$h_eleclass{$tag} = $class;
            push(@{$ra},$class);
            ### $h_eleclass{$tag} = $class;
            ###prt("Stored $tag.$class\n");
        } elsif ($tag =~ /^\w+\#/) {
            $elehash++;
            @arr = split(/\#/,$tag);
            $tag = $arr[0];
            $class = $arr[1];
            $h_elehash{$tag} = $class;
        } elsif ($tag =~ /^\w+\:/) {
            $elecolon++;
            @arr = split(/\#/,$tag);
            $tag = $arr[0];
            $class = $arr[1];
            $h_elecolon{$tag} = $class;
        } elsif ($tag =~ /^\w+\+/) {
            $eleplus++;
            @arr = split(/\+/,$tag);
            $tag = $arr[0];
            $class = $arr[1];
            $h_eleplus{$tag} = $class;
        } else {
            $other++;
            $cont .= ' ' if (length($cont));
            $cont .= $tag;
            $h_others{$tag} = 1;
        }
    }
    prt("Got $len classes... dotcnt=$dotcnt, hashcnt=$hashcnt, elecnt=$elecnt, eledot=$eledot, elehash=$elehash, eleplus=$eleplus, other=$other\n");
    prt("Others: [$cont]\n") if (length($cont));
    my %hash = ();
    $hash{'REF_HASH'} = $rhash;
    $hash{'H_CLASSES'} = \%h_classes;
    $hash{'H_NAMES'} = \%h_names;
    $hash{'H_ELEMENTS'} = \%h_elements;
    $hash{'H_ELECLASS'} = \%h_eleclass;
    $hash{'H_ELEHASH'} = \%h_elehash;
    $hash{'H_ELECOLON'} = \%h_elecolon;
    $hash{'H_ELEPLUS'} = \%h_eleplus;
    $hash{'H_OTHERS'} = \%h_others;
    return \%hash;
}


sub read_css_lines($$$$) {
    my ($rlines,$rhash,$file,$dbg) = @_;
    my ($line,$i,$i2,$len,$ch,$nc,$incomm,$tag,$cont,@arr,$tmp,$lnn,$prev);
    my ($inbrace,$rh,$key,$val);
    $incomm = 0;
    $inbrace = 0;
    $tag = '';
    $cont = '';
    $lnn = 0;
    foreach $line (@{$rlines}) {
        chomp $line;
        $line = trim_all($line);
        $len = length($line);
        $lnn++;
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($line,$i,1);
            $nc = ($i2 < $len) ? substr($line,$i2,1) : '';
            if ($incomm) {
                if (($ch eq '*')&&($nc eq '/')) {
                    prt("$lnn:$i2: End comment\n") if ($dbg & 8);
                    $incomm = 0;
                    $i++;
                }
            } else {
                if (($ch eq '/')&&($nc eq '*')) {
                    prt("$lnn:$i2: Begin comment\n") if ($dbg & 8);
                    $incomm = 1;
                    $i++;
                } else {
                    if ($inbrace) {
                        if ($ch eq '}') {
                            $inbrace = 0;
                            prt("$lnn:$i2: End   brace\n") if ($dbg & 8);
                            $tag = trim_all($tag);
                            $cont = trim_all($cont);
                            if (length($tag)) { # && length($cont)) {
                                #@arr = split(/,/,$tag);
                                @arr = split(/[\s,]/,$tag);
                                foreach $tmp (@arr) {
                                    $tmp = trim_all($tmp);
                                    next if (length($tmp) == 0);
                                    $prev = '';
                                    if (defined ${$rhash}{$tmp}) {
                                        $rh = ${$rhash}{$tmp}; # extract previous ref hash
                                        foreach $key (keys %{$rh}) {
                                            $val = ${$rh}{$key};
                                            $prev .= "$key:$val;";
                                        }
                                        #$hash{$tmp} .= " $cont";
                                    } else {
                                        #$hash{$tmp} = $cont;
                                    }
                                    $rh = css_content_2_hash("$cont $prev",$dbg,$lnn);
                                    ${$rhash}{$tmp} = $rh;
                                    prt(" $tmp = [$cont] $prev\n") if ($dbg & 4);
                                    ### show_content_hash($tmp,$rh);
                                }
                            #} elsif (length($tag)) {
                            #    prtw("WARNING:$lnn:$i2: Got tag [$tag] with NO CONTENT!\n");
                            } elsif (length($cont)) {
                                prtw("WARNING:$lnn:$i2: Got content [$cont] with NO TAG!\n");
                            }
                            $tag = '';
                            $cont = '';
                        } else {
                            $cont .= $ch;
                        }
                    } elsif ($ch eq '{') {
                        $inbrace = 1;
                        prt("$lnn:$i2: Begin brace\n") if ($dbg & 8);
                    } else {
                        $tag .= $ch;
                    }
                }
            }
        }
        if ($inbrace) {
            $cont .= ' ' if (length($cont));
        } else {
            $tag .= ' ' if (length($tag));
        }
    }
    ### get_class_counts($rhash);
    if ($dbg & 16) {
        my $min = 0;
        foreach $tag (sort keys %{$rhash}) {
            $len = length($tag);
            $min = $len if ($len > $min);
        }
        foreach $tag (sort keys %{$rhash}) {
            $rh = ${$rhash}{$tag};
            $prev = "";
            foreach $tmp (sort keys %{$rh}) {
                $val = ${$rh}{$tmp};
                $prev .= "$tmp:$val;";
            }
            $tag .= ' ' while (length($tag) < $min);
            prt("$tag { $prev }\n");
        }
    }
    return $rhash;
}

sub read_css_file($$$) {
    my ($rh,$file,$dbg) = @_;
    if (! open INF, "<$file") {
        prtw("WARNING: Unable to OPEN $file\n");
        return $rh;
    }
    my @lines = <INF>;
    close INF;
    prt("Loaded ".(scalar @lines)." from [$file]\n") if ($dbg & 0x01);
    return read_css_lines(\@lines,$rh,$file,$dbg);
}

1;

# eof - lib_css.pl
