#!/usr/bin/perl
use strict;
use warnings;

# simple vector3 class

package vec3;

sub new {
    my $caller = shift;
    my $class  = ref($caller) || $caller;
    my $self   = [ map( { defined($_) ? $_ : 0 } @_[ 0, 1, 2 ] ) ];
    bless( $self, $class );
    return ($self);
}

sub x { shift->[0] }
sub y { shift->[1] }
sub z { shift->[2] }

use overload '+' => sub {
    my ( $v1, $v2 ) = @_;
    vec3->new( $v1->x + $v2->x, $v1->y + $v2->y, $v1->z + $v2->z );
  },
  '==' => sub {
    my ( $v1, $v2 ) = @_;
    return ( $v1->x == $v2->x && $v1->y == $v2->y && $v1->z == $v2->z );
  },
  '-' => sub {
    my ( $v1, $v2 ) = @_;
    vec3->new( $v1->x - $v2->x, $v1->y - $v2->y, $v1->z - $v2->z );
  },
  '*' => sub {
    my ( $v1, $v2 ) = @_;
    if ( ref($v2) eq 'vec3' ) {
        return $v1->x * $v2->x + $v1->y * $v2->y + $v1->z * $v2->z;
    }
    else {
        return vec3->new( $v1->x * $v2, $v1->y * $v2, $v1->z * $v2 );
    }
  },
  '/' => sub {
    my ( $v1, $v2 ) = @_;
    return vec3->new( $v1->x / $v2, $v1->y / $v2, $v1->z / $v2 );
  },
  'x' => sub {
    my ( $v1, $v2 ) = @_;
    return vec3->new(
        $v1->y * $v2->z - $v1->z * $v2->y,
        $v1->z * $v2->x - $v1->x * $v2->z,
        $v1->x * $v2->y - $v1->y * $v2->x
    );
  },
  fallback => 1;

sub len {
    my $self = shift;
    return sqrt( $self * $self );
}

sub normalized {
    my $self = shift;
    my $d    = len($self);

    if ( $d == 0 ) {
        return vec3->new( 0, 0, 0 );
    }
    else {
        return $self / $d;
    }
}

sub as_string {
    my $self = shift;
    return join( ',', $self->x, $self->y, $self->z );
}

1;
