#!/perl -w
# NAME: listobj.pl
# AIM: Given a folder, make a sub-folder list containing *.obj files
# 20/06/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_folder = '';
my $debug_on = 0;
my $def_folder = 'C:\FG';
my $out_val = 1000;

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;
my $tot_cnt = 0;

# forward
sub process_a_folder($$$);

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub is_obj_file($) {
    my ($fil) = shift;
    return 1 if ($fil =~ /\.obj$/i);
    return 0;
}

sub process_folder($) {
    my ($inf) = shift;
    my @list = ();
    if (opendir(DIR,$inf)) {
        my @files = readdir(DIR);
        closedir(DIR);
        $inf .= "\\" if (!($inf =~ /(\\|\/)$/));
        my ($file,$ff);
        foreach $file (@files) {
            next if (($file eq ".")||($file eq ".."));
            $ff = $inf.$file;
            if (-d $ff) {
                push(@list,$ff);
            } elsif ( -f $ff ) {
                if (is_obj_file($file)) {
                    # WHAT TO DO ABOUT ROOT *.obj FILES
                }
            }
        }
    } else {
        prt("ERROR: Unable to open directory [$inf]!\n");
    }
    return \@list;
}

sub process_a_folder($$$) {
    my ($fold,$lev,$rcnt) = @_;
    prt("Process [$fold]") if ($lev == 0);
    my @dirs = ();
    my ($file,$ff,$cnt);
    my $dncnt = 0;
    $cnt = ${$rcnt};
    if ( opendir(DIR,$fold) ) {
        my @files = readdir(DIR);
        closedir(DIR);
        $fold .= "\\" if (!($fold =~ /(\\|\/)$/));
        foreach $file (@files) {
            next if (($file eq ".")||($file eq ".."));
            $ff = $fold.$file;
            $cnt++;
            if ($cnt && (($cnt % $out_val) == 0)) {
                $dncnt = 1;
                prt(".");
            }
            if (-d $ff) {
                push(@dirs,$ff);
            } elsif ( -f $ff ) {
                if (is_obj_file($file)) { # got an OBJ file
                    ${$rcnt} = $cnt;
                    prt("found obj\n");
                    return 1;
                }
            }
        }
    }
    foreach $file (@dirs) {
        if (process_a_folder($file,($lev + 1),$rcnt)) {
            ${$rcnt} = $cnt;
            return 1;
        }
    }
    ${$rcnt} = $cnt;
    prt("\n") if ($lev == 0);
    return 0;
}

sub process_folders($) {
    my ($ra) = shift;
    my $cnt = scalar @{$ra};
    prt("Process $cnt folders...\n");
    my ($i, $ff);
    my @list = ();
    $| = 1;
    for ($i = 0; $i < $cnt; $i++) {
        $ff = ${$ra}[$i];
        if (process_a_folder($ff,0,\$tot_cnt)) {
            push(@list,$ff);
            prt("Added folder [$ff]\n");
        }
    }
    return \@list;
}

sub show_obj_list($) {
    my ($rl) = shift;
    my $cnt = scalar @{$rl};
    prt( "Found $cnt folders, with object files...in $tot_cnt search...\n");
    foreach my $file (@{$rl}) {
        prt("$file\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Processing directory [$in_folder]...\n" );
my $ref_arr = process_folder($in_folder);
my $obj_list = process_folders($ref_arr);
show_obj_list($obj_list);

pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-05-05\n");
    prt("Usage: $pgmname [options] in_folder\n");
    prt("Options:\n");
    prt(" -h (-?)   = this help and exit 0\n");
    prt("Scan the input folder for sub-folder, and list sub-folder with *.ob files...\n")
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have follwoing argument!\n")
        if (!@av);
}

sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /-/);
            if (($sarg =~ /h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_folder = $arg;
            prt("Set input to [$in_folder]\n");
        }
        shift @av;
    }
    if ($debug_on) {
        if (length($in_folder) == 0) {
            $in_folder = $def_folder;
            prt("Set input to DEFAULT [$in_folder]\n");
        }
    }

    if (length($in_folder) == 0) {
        pgm_exit(1,"No input folder found in command!\n");
    }
}

# eof - listobj.pl
