#!/usr/bin/perl -w

use strict;
use CGI qw(:standard);
use XML::XPath;

# initialize the objects and declare the path to the sitemap. 
#my $sitemap = "/usr/local/apache/htdocs/map3.html";
my $sitemap = "tempmap3.html";
my $xp = XML::XPath->new(filename => $sitemap);
my $cgi = new CGI;

# begin CGI output
print $cgi->header();

print $cgi->start_html(-title => 'Site Search');

print $cgi->h2('Search Our Site');

print $cgi->start_form( -method => 'POST',
                        -action => 'mapsearch.cgi');

print $cgi->textfield(-name => 'search_string');
print $cgi->submit(-value => 'Search');
print $cgi->endform;

# if the form has been submitted and the search box was filled in,
# search the keyword, description and titles for the input/
if ($cgi->param('search_string')) {
    my $search_string = $cgi->param('search_string');
    my $match_count = 0;
    foreach my $page ($xp->findnodes('//li')->get_nodelist) {
        my $match_flag = 0;

        foreach my $field ('a', 'description', 'keywords') {
            $match_flag++ if  $page->find($field)->string_value =~ /$search_string/gi;
        }
    
        if ($match_flag > 0) {
            print $cgi->a({href => $page->find('a/@href')}, $page->find('a')->string_value ), $cgi->br;
            $match_count++;
        }

    }

    print $cgi->b("No Matches Found for $search_string") unless $match_count > 0;
}

print $cgi->end_html;
