#!/usr/bin/perl -w

use strict;
use warnings;
use Math::Trig;

my @distances = qw( 9.1  8    7    6    5    4    3.6  3.4  3    2.7 );
my @altitudes = qw( 3700 3350 3030 2710 2390 2080 1960 1880 1760 1650);

# SIMGEAR constants
my $SGD_PI = 3.1415926535;
my $SGD_DEGREES_TO_RADIANS = $SGD_PI / 180.0;
my $SGD_RADIANS_TO_DEGREES = 180.0 / $SGD_PI;
# /** Feet to Meters */
my $SG_FEET_TO_METER = 0.3048;
# /** Meters to Feet */
my $SG_METER_TO_FEET = 3.28083989501312335958;
#/** Meters to Nautical Miles.  1 nm = 6076.11549 feet */
my $SG_METER_TO_NM = 0.0005399568034557235;
#/** Nautical Miles to Meters */
my $SG_NM_TO_METER = 1852;
#/** Meters to Statute Miles. */
my $SG_METER_TO_SM = 0.0006213699494949496;
#/** Statute Miles to Meters. */
my $SG_SM_TO_METER = 1609.3412196;


sub prt($) {
    print shift;
}

sub set_decimal1_stg($) {
    my $r = shift;
    ${$r} =  int((${$r} + 0.05) * 10) / 10;
}
sub set_int_stg($) {
    my $r = shift;
    ${$r} =  int(${$r} + 0.5);
}

sub do_calcs() {
    my ($dist_nm, $alt_ft,$angle);
    my $rd = \@distances;
    my $ra = \@altitudes;
    my $max = scalar @{$rd};
    my ($i,$dist_m,$alt_m,$ang_rad,$ratio);
    for ($i = 0; $i < $max; $i++) {
        $dist_nm = ${$rd}[$i];
        $alt_ft = ${$ra}[$i];
        $dist_m = $dist_nm * $SG_NM_TO_METER;
        $alt_m = $alt_ft * $SG_METER_TO_FEET;
        $ratio = ($alt_m / $dist_m);
        $ang_rad = atan($ratio);
        $angle = $ang_rad * $SGD_RADIANS_TO_DEGREES;

        set_decimal1_stg(\$angle);
        set_int_stg(\$dist_m);
        set_int_stg(\$alt_m);
        prt( "Dist $dist_nm nm ($dist_m m), altitude $alt_ft ($alt_m m), angle $angle degrees ($ratio, $ang_rad)\n");
    }
}

do_calcs();
exit 0;
