#!/usr/bin/perl
#< ms2time.pl
use strict;
use warnings;

sub prt($) { print shift; }

sub ms2time($) {
    my $ms = shift;
    if ($ms =~ /^\d+$/) {
        # ok
    } else {
        prt("Expected an integr value, not [$ms]\n");
        return;
    }
    if ($ms < 1000) {
        prt("$ms ms.\n");
    } else {
        my $sec = int($ms / 1000);
        $ms -= $sec * 1000;
        if ($ms < 10) {
            $ms = '00'.$ms;
        } elsif ($ms < 100) {
            $ms = '0'.$ms;
        }
        if ($sec < 60) {
            prt($sec.".$ms secs\n");
        } else {
            my $mins = int($sec / 60);
            $sec -= $mins * 60;
            $sec = '0'.$sec if ($sec < 10);
            prt("$mins:$sec.$ms mins\n");
        }
    }
}

if (@ARGV) {
    ms2time($ARGV[0]);
} else {
    prt("Given ms to convert to a time...\n");
}