#!/perl -w
# NAME: nasa-srtm-range.pl
# AIM: very specific - search an FTP list, for files within range
# 26/04/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $MIN_LON = 150;
my $MAX_LON = 154;
my $MIN_LAT = -37;
my $MAX_LAT = -30;

my $in_file = "C:\\FG\\27\\terragear-cs\\projects\\msvc\\templist.txt";

sub process_file($) {
   my ($fil) = shift;
   my @arr = ();
   if (open INF, "<$fil") {
      my @lines = <INF>;
      close INF;
      my $lncnt = scalar @lines;
      prt( "Processing $lncnt lines, from $fil...\n" );
      foreach my $line (@lines) {
         chomp $line;
         if ($line =~ /(S|N)(\d{2})(E|W)(\d{3})/) {
            my $ns = $1;
            my $lat = $2;
            my $ew = $3;
            my $lon = $4;
            if ($ns eq 'S') {
               $lat *= -1;
            }
            if ($ew eq 'W') {
               $lon *= -1;
            }
            if (($lat >= $MIN_LAT)&&($lat <= $MAX_LAT)&&($lon >= $MIN_LON)&&($lon <= $MAX_LON)) {
               prt( "lat,lon = $lat, $lon\n" );
               push(@arr, [ $lat, $lon ]);
            }
         }
      }
   } else {
      prt( "ERROR: can not open file $fil\n" );
   }
   return @arr;
}

sub show_list($) {
   my ($rlst) = shift;
   my $cnt = scalar @{$rlst};
   prt( "Got $cnt to show...\n" );
   for (my $i = 0; $i < $cnt; $i++) {
      my $lat = $$rlst[$i][0];
      my $lon = $$rlst[$i][1];
      my $ns = 'N';
      if ($lat < 0.0) {
         $ns = 'S';
         $lat *= -1;
      }
      my $ew = 'E';
      if ($lon < 0.0) {
         $ew = 'W';
         $lon *= -1;
      }
      prt ( "$ns$lat$ew$lon " );
   }
   prt("\n");
}

my @list = process_file( $in_file );
prt( "Got list...\n" );
show_list( \@list );


close_log($outfile,0);
unlink $outfile;
exit(0);

# eof
