#!Perl -w
# NAME: osgvers.pl
# AIM: See if we can FIND the Version strings, of OpenSceneGraph,
# given an INPUT (base) direcotry to check ...
# 11/24/2008 - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;

my $in_folder = '';

my $in_file1 = 'CMakeLists.txt';
# SET(OPENSCENEGRAPH_MAJOR_VERSION 2)
# SET(OPENSCENEGRAPH_MINOR_VERSION 7)
# SET(OPENSCENEGRAPH_PATCH_VERSION 3)
# SET(OPENSCENEGRAPH_SOVERSION 47)

my $in_file2 = 'src\OpenThreads\CMakeLists.txt';
# SET(OPENTHREADS_SOVERSION 11)

my $maj_ver = -1;
my $min_ver = -1;
my $pat_ver = -1;
my $sov_ver = -1;
my $oth_ver = -1;

sub get_args {
	my (@av) = @_;
	while (@av) {
		my $arg = $av[0];
		$in_folder = $arg;
		shift @av;
	}
}

sub check_version {
	my ($inf1, $inf2) = @_;
	my (@lines, $line);
	if (open INF, "<$inf1") {
		@lines = <INF>;
		close INF;
		foreach $line (@lines) {
			chomp $line;
			if ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_MAJOR_VERSION\s+(\d)+\s*\)/ ) {
				$maj_ver = $1;
			} elsif ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_MINOR_VERSION\s+(\d)+\s*\)/ ) {
				$min_ver = $1;
			} elsif ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_PATCH_VERSION\s+(\d)+\s*\)/ ) {
				$pat_ver = $1;
			} elsif ($line =~ /\s*SET\s*\(\s*OPENSCENEGRAPH_SOVERSION\s+(\d\d)+\s*\)/ ) {
				$sov_ver = $1;
			}
			if (($maj_ver != -1)&&($min_ver != -1)&&($pat_ver != -1)&&($sov_ver != -1)) {
				last;	# we found em ALL ;=))
			}
		}
	} else {
		prt("ERROR: Unable to open [$inf1] ... $! ...\n");
	}
	if (open INF, "<$inf2") {
		@lines = <INF>;
		close INF;
		foreach $line (@lines) {
			if ($line =~ /\s*SET\s*\(\s*OPENTHREADS_SOVERSION\s+(\d\d)+\s*\)/) {
				$oth_ver = $1;
				last;
			}
		}
	} else {
		prt("ERROR: Unable to open [$inf2] ... $! ...\n");
	}
}

sub prt {
	my ($txt) = shift;
	print $txt;
}

sub show_version {
	my $dnout = 0;
	# @set TEMPOSGV=47
	# @set TEMPPIV=2.7.3
	# @set TEMPOTV=11
	my $msg = "SUGGEST ";
	$msg .= "set TEMPOSGV=";
	if ($sov_ver != -1) {
		$msg .= "$sov_ver ";
		$dnout++;
	} else {
		$msg .= "not found! ";
	}

	$msg .= "set TEMPPIV=";
	if ($maj_ver != -1) {
		$msg .= "$maj_ver.$min_ver.$pat_ver ";
		$dnout++;
	} else {
		$msg .= "not found! ";
	}

	$msg .= "set TEMPOTV=";
	if ($oth_ver != -1) {
		$msg .= "$oth_ver ";
		$dnout++;
	} else {
		$msg .= "not found! ";
	}
	prt( "$msg.\n");
}

get_args(@ARGV);

if (length($in_folder) == 0) {
	prt( "ERROR: Give name of OSG folder to check ...\n" );
} else {
	if (-d $in_folder) {
		my ($f1, $f2);
		$f1 = $in_folder;
		$f1 .= "\\" if !($f1 =~ /\\$/);
		$f1 .= $in_file1;
		$f2 = $in_folder;
		$f2 .= "\\" if !($f2 =~ /\\$/);
		$f2 .= $in_file2;
		check_version($f1, $f2);
		show_version();
	} else {
		prt("ERROR: Folder [$in_folder] does NOT appear to exist!\n");
	}
}
exit(0);

# eof - osgvers.pl

