#!C:/Perl
# NAME: ref.pl
# AIM: test returning a HASH reference
# 23/01/2008 - geoff mclane
my %hash = get_hash();
foreach my $key (keys %hash) {
	my $r = $hash{$key};
	my ($v);
	my $rf = ref($r);
	if (ref($r) eq "HASH") {
        prt( "$key: r is a reference to a hash.\n" );
		foreach my $k (keys %{$r}) {
			$v = ${%{$r}}{$k};
			prt( " $k=$v" );
		}
		prt("\n");
	} elsif (ref($r) eq "ARRAY") {
        prt( "$key: r is a reference to an array.\n" );
		foreach my $a (@{$r}) {
			prt( " $a" );
		}
		prt("\n");
	} elsif (ref($r) eq "SCALAR") {
		prt( "$key: ".$r." (SCALAR)\n" );
    } else {
		if (!ref($r)) {
			prt( "$key: $r (r is not a reference at all)\n" );
		} else {
			prt( "$key: $r [$rf] (is NOT a HASH or ARRAY reference)\n" );
		}
	}
}
exit(0);

sub foo {
	my $msg = "foo run\n";
	#prt($msg);
	return $msg;
}
sub get_hash {
	my %new_hash = ();
	my %h2 = ();
	my %h3 = ();
	my @arr = ('item1', 'item2', 'item3');
	$new_hash{'this'} = 'test';
	$new_hash{'that'}{'one'} = 'test2';
	$h2{'aaa'} = 'testa';
	$h2{'bbb'} = 'testb';
	$new_hash{'hash'} = \%h2;
	$h3{'ccc'} = 'testc';
	$h3{'ddd'} = 'testd';
	$new_hash{'hash3'} = \%h3;
	$new_hash{'array'} = \@arr;
	$new_hash{'function'} = \foo;
	return %new_hash;
}

sub prt {
	my ($txt) = shift;
	print $txt;
}

# eof - ref.pl
