#!perl -w
# NAME: reg05.pl
# AIM: get ONE entry from the registry ...
# 30/10/2006 geoff mclane http://geoffair.net/mperl
# ##########################################################
use strict;
use warnings;
use Win32::Registry;
my %TYPES = (
  &REG_SZ         =>  "REG_SZ",
  &REG_EXPAND_SZ  =>  "REG_EXPAND_SZ",
  &REG_MULTI_SZ   =>  "REG_MULTI_SZ",
  &REG_DWORD      =>  "REG_DWORD",
  &REG_BINARY     =>  "REG_BINARY"
);
my %REGKEYS = (
  $HKEY_CLASSES_ROOT => "HKEY_CLASSES_ROOT",
  $HKEY_CURRENT_USER => "HKEY_CURRENT_USER",
  $HKEY_LOCAL_MACHINE => "HKEY_LOCAL_MACHINE",
  $HKEY_USERS => "HKEY_USERS",
  $HKEY_CURRENT_CONFIG => "HKEY_CURRENT_CONFIG"
);
require "logfile.pl" or die "ERROR: Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $keyroot = $HKEY_CURRENT_USER;
###my $inipath = 'Software\Microsoft\FrontPage\Explorer\ReplaceMRU';
my $inipath = 'Software\Microsoft\Office\10.0\Common\Open Find\Microsoft Word\Settings\Save As\File Name MRU';

prt( "$0 ... Hello, get registry key - " . get_key_name($keyroot) . "...\n" );

Show_Key( $keyroot, $inipath );

close_log($outfile,1);
exit(0);

sub get_key_name {
	my ($k) = shift;
	if ( defined $REGKEYS{$k} ) {
		return $REGKEYS{$k};
	}
	return 'undefined';
}

sub Show_Key {
	my ($k,$p) = @_;
	my $Key;
	my %Values;
    my @KeyList;
	my @pathlist = split(/\\/, $p);
	my $pcnt = scalar @pathlist;
	my $cnt = 0;
	prt( "Processing " . get_key_name($k) . " with path \n [$p] ...\n" );
	if( $k->Open( $p, $Key ) ) {
		if( $Key->GetValues( \%Values ) ) {
			foreach my $ValueName ( sort( keys( %Values ) ) )
			{
				$cnt++;
				my $Name = $Values{$ValueName}->[0];
				my $Type = $Values{$ValueName}->[1];
				my $Data = $Values{$ValueName}->[2];
				my $tname = $TYPES{$Type};
		        $ValueName = "<Default Class>" if( "" eq $ValueName );
				prt( "$cnt $Name ($tname) Data = [$Data]\n" );
				if ($tname eq 'REG_MULTI_SZ') {
					##my @arr = split( /\x0/, $Data );
					my @arr = split( /\0/, $Data );
					foreach my $fn (@arr) {
						prt( "$fn\n" );
					}
					prt("\n");
				}
			}
		} else {
			prt( "FAILED GetValues ...\n" );
		}

		$Key->Close();
	} else {
		prt( "Open FAILED\n" );
		my $Path = '';
		my $ccnt = 0;
		my $nxtpath = $pathlist[$ccnt];
		my $fnd = 0;
		while ($ccnt < $pcnt) {
			if ( $k->Open( $Path, $Key) ) {
				$fnd = 0;
				$Key->GetKeys( \@KeyList );
				my $pc = scalar @KeyList;
				prt( "Found $pc paths ...\n" );
				$cnt = 0;
				foreach my $p2 (@KeyList) {
					$cnt++;
					if ($p2 =~ /^$nxtpath$/i) {
						prt( "$cnt path=[$p2]\n" );
						$fnd = 1;
						last;
					}
				}
				$Key->Close();
				if ($fnd) {
					$Path .= "\\" unless ("" eq $Path);
					$Path .= $nxtpath;
					$ccnt++;
					$nxtpath = $pathlist[$ccnt] if ($ccnt < $pcnt);
				} else {
					prt( "Path [$nxtpath] NOT found ...\n" );
					last;
				}
			} else {
				prt( "[$Path] open also FAILED\n" );
				last;
			}
		}
	}
}

# eof reg05.pl
