#!/usr/bin/perl -w
# NAME: repltext.pl
# AIM: Open in file and replace -f string with -r string, out to -o out_file
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-10-03";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';
my $find = '';
my $replace = '';
my $no_case = 0;

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub is_same($) {
    my $str = shift;
    $str = lc($str) if ($no_case);
    my $fnd = $find;
    $fnd = lc($fnd) if ($no_case);
    prt("Comp: [$str] with [$fnd]\n") if (VERB9());
    return 1 if ($str eq $fnd);
    return 0;
}

sub replace_string($) {
    my $rl = shift;
    my $len = length(${$rl});
    my $iret = 0;
    my $flen = length($find);
    return 0 if ($len < $flen);
    my $fch = substr($find,0,1);
    $fch = lc($fch) if ($no_case);
    my ($i,$ch,$bgn,$bal,$cch);
    ###$len -= ($flen - 1);
    my $nline = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr(${$rl},$i,1);
        $bal = $len - $i;
        if ($bal >= $flen) {
            $cch = $no_case ? lc($ch) : $ch;
            if ($cch eq $fch) {
                # more compare
                if (is_same(substr(${$rl},$i,$flen))) {
                    #$bgn = $i ? substr(${$rl},0,$i) : '';
                    #$bal = substr(${$rl},$i + $flen);
                    #$cch = $bgn.$replace;
                    $nline .= $replace;
                    $i += $flen - 1;
                    $iret++;
                    next;
                }
            }
        }
        $nline .= $ch;
    }
    ${$rl} = $nline if ($iret);
    return $iret;
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$oline,$ind,$len,$clnn,$tline);
    $lnn = 0;
    my @nlines = ();
    my $changes = 0;
    foreach $line (@lines) {
        chomp $line;
        $tline = trim_all($line);
        $len = length($tline);
        if ($len == 0) {
            push(@nlines,$line);
            next;
        }
        $oline = $line;
        $lnn++;
        if (replace_string(\$line)) {
            $changes++;
            $clnn = sprintf("%4d",$lnn);
            $len = length($clnn);
            $ind = ' ' x $len;
            prt("$clnn: $oline\n$ind: $line\n");
        }
        push(@nlines,$line);
    }
    if ($changes) {
        $line = join("\n",@nlines)."\n";
        if (length($out_file)) {
            rename_2_old_bak($out_file);
            write2file($line,$out_file);
            prt("Changed results written to [$out_file]\n");
        } else {
            prt($line);
            prt("No -o out_file given\n");
        }
    } else {
        prt("Find string [$find] NOT found in file\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } elsif ($sarg =~ /^f/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $find = $sarg;
                prt("Set the find string to [$find].\n") if (VERB1());
            } elsif ($sarg =~ /^r/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $replace = $sarg;
                prt("Set the replace string to [$replace].\n") if (VERB1());
            } elsif ($sarg =~ /^n/) {
                $no_case = 1;
                prt("Set case insensative compare [$no_case].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if ((length($in_file) ==  0) && $debug_on) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
    if (length($find) == 0) {
        pgm_exit(1,"No -f string to find!\n");
    }
    if (length($replace) == 0) {
        pgm_exit(1,"No -r string to replace!\n");
    }
    #$find = path_d2u($find);
    #$replace = path_d2u($replace);
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt(" --find string (-f) = String to find in the file.\n");
    prt(" --repl string (-r) = String to replace above.\n");
    prt(" --nocase      (-n) = Ignore case.\n");

}

# eof - template.pl
