#!/Perl -w
use strict;
### from : http://www.stupidsimple.org/code/netflix/?f=parser
my $html_dir    = 'c:/Gtools/Perl';
my $lib_dir     = $html_dir; ### '/home/jgray/lib/netflix';
my $html_out    = "$lib_dir/netflix-queue.html";
my $cookies     = "$lib_dir/netflix-cookies.txt";
my $queue_url   = 'http://www.netflix.com/Queue';
my $site_url    = 'http://www.stupidsimple.org/';
my $email       = 'john@brainpipe.com';
my $rss_new     = "$lib_dir/netflix-queue.xml.new";
my $rss_orig    = "$html_dir/netflix-queue.xml";

qx( wget -O $html_out --load-cookies $cookies $queue_url );

open RSS, "> $rss_new" or die( "Could not open $rss_new for writing: $!\n" );

print RSS "<?xml version=\"1.0\"?>\n";
print RSS "<rss version=\"2.0\">\n";
print RSS "\t<channel>\n";
print RSS "\t\t<title>Netflix Queue RSS</title>\n";
print RSS "\t\t<link>$site_url</link>\n";
print RSS "\t\t<description>Netflix RSS proof-of-concept</description>\n";

print RSS "\t\t<webMaster>$email</webMaster>\n";

open HTML, "< $html_out" or die( "Could not open $html_out for writing: $!\n" );
while( my $line = <HTML> ){
    chomp $line;
    if( $line =~ /(<a\ href=")(http:\/\/www.netflix.com\/MovieDisplay?)(.*?&)(movieid=.+?)(">)(.+?)(<\/a>)/ ){
        print RSS "\t\t<item>\n";
        print RSS "\t\t\t<title>$6</title>\n";
        print RSS "\t\t\t<link>$2$4</link>\n";
        print RSS "\t\t</item>\n";
    }
}
close HTML;

print RSS "\t</channel>\n";
print RSS "</rss>\n";

if( ! -e $rss_orig ){
    qx( mv $rss_new $rss_orig );
}
elsif( qx(diff $rss_new $rss_orig) ){
    qx( mv $rss_orig $rss_orig.bak );
    qx( mv $rss_new $rss_orig );
}

close RSS;


