#!/perl

# server0.pl 
#-------------------- 

use strict; 
use Socket; 

my $start_time = time();
# use port 7890 as default 
my $port = shift || 7890; 
my $proto = getprotobyname('tcp'); 
my $msg;

# create a socket, make it reusable 
print "SERVER: server0.pl starting at " . localtime($start_time) . " ...\n";
print "SERVER: Creating socket ...\n";
socket(SERVER, PF_INET, SOCK_STREAM, $proto) or die "socket: $!"; 
print "SERVER: Setting socket re-use ...\n";
setsockopt(SERVER, SOL_SOCKET, SO_REUSEADDR, 1) or die "setsock: $!"; 

# grab a port on this machine 
print "SERVER: grab an address, on this machine ... using port $port ...\n";
my $paddr = sockaddr_in($port, INADDR_ANY); 

# bind to a port, then listen 
print "SERVER: binding to $paddr, on port $port ...\n"; 
bind(SERVER, $paddr) or die "bind: $!"; 
print "SERVER: listen to $paddr, on port $port ...\n"; 
listen(SERVER, SOMAXCONN) or die "listen: $!"; 
print "SERVER: started on port $port ..\n"; 

# accepting a connection 
my $client_addr; 
print "SERVER: waiting for a connection ...\n";
while ($client_addr = accept(CLIENT, SERVER)) { 
	# find out who connected 
	my ($client_port, $client_ip) = sockaddr_in($client_addr); 
	my $client_ipnum = inet_ntoa($client_ip); 
	my $client_host = gethostbyaddr($client_ip, AF_INET); 
	# print who has connected 
	$msg = "SERVER: Got a connection from [$client_host]\n ipnum [$client_ipnum] port [$client_port] ip [$client_ip]";
	print "$msg\n";
	# send them a message, close connection 
	print "SERVER: Sending message to client ...\n";
	print CLIENT "Hello $msg -\n *** Smile from the server ***"; 
	print "SERVER: Closing CLIENT ...\n";
	close CLIENT;
	print "SERVER: waiting for a connection ...\n";
} 

