#!/usr/bin/perl
#server
use strict;
use warnings;

use IO::Socket;

$| = 1;
my $nonblocking = 1;


my $sock = new IO::Socket::INET(
    LocalHost   => "localhost",
    LocalPort   => 7890,
    Proto       => "tcp",
    Listen      => SOMAXCONN,
    Reuse       => 1,
    Timeout     => 20,
);

if ($sock) {
   print "A socket created on LocalHost listening on LocalPort\n";
} else {
   die "Error - no listening socket created : $!";
}
my $flush = 1;

while (my ($new_sock,$c_addr) = $sock->accept()) {
    my ($client_port, $c_ip) = sockaddr_in($c_addr);
    my $client_ipnum = inet_ntoa($c_ip);
    my $client_host = gethostbyaddr($c_ip, AF_INET);
    print "Got a connection from: $client_host"," [$client_ipnum] \n";
    print "Created new socket for reading or writing data to Client\n";

    $new_sock->blocking(1);
    my $buf;

    $buf = $new_sock->getline();
    chomp($buf);
    print "Recieved 1 '$buf'\n";

    $new_sock->say($buf);
    $buf = $new_sock->getline();
    chomp($buf);

    print "Recieved 2 '$buf', say('12')\n";
    $new_sock->say("12");
}

print "exiting...\n";
