#!/usr/bin/perl -w
# NAME: showuncommented.pl
# AIM: Read an asterisk 'config' file, and just show 'uncommented line = do not start ';'
# 17/06/2012 - Allow multiple files, and add output
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2012-06-17";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_dir = '';
my @in_files = ();

### program variables
my @warnings = ();
my $cwd = cwd();

# debug
my $debug_on = 0;
my $def_file = 'def_file';

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    my $odlen = length($out_dir);
    my ($name,$dir) = fileparse($inf);
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$len);
    $lnn = 0;
    my @vlines = ();
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        next if ($line =~ /^\s*;/);
        prt("$line\n") if ($odlen == 0);
        push(@vlines,$line);
    }
    $len = scalar @vlines;
    if ($odlen && $len) {
        $inc = $out_dir.$PATH_SEP.$name."-current";
        $line = "; contents of $inf - by $pgmname - ".lu_get_YYYYMMDD_hhmmss(time())."\n";
        $line .= join("\n",@vlines)."\n";
        $line .= "; eof\n";
        write2file($line,$inc);
        prt("Output written to [$inc]\n");
    } elsif (($odlen == 0) && $len) {
        prt("Found $len valid lines, but no output directory given. Use -o dir\n");
    } else {
        prt("Found no valid lines in [$inf]\n");
    }
}

sub process_in_files($) {
    my $ra = shift;
    my ($fil);
    foreach $fil (@{$ra}) {
        process_in_file($fil);
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_files(\@in_files);
pgm_exit(0,"");
########################################
sub got_wild($) {
    my $fil = shift;
    return 1 if ($fil =~ /\*/);
    return 1 if ($fil =~ /\?/);
    return 0;
}
sub glob_wild($) {
    my $fil = shift;
    my @files = glob($fil);
    my $cnt = scalar @files;
    if ($cnt) {
        prt("Adding $cnt files, from [$fil] input.\n");
        push(@in_files,@files);
        $in_file = $files[0];
    } else {
        pgm_exit(1,"ERROR: Got no files, from [$fil] input.\n");
    }
}

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                $load_log = 1;
                prt("Set to load log at end.\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_dir = $sarg;
                if (-d $out_dir) {
                    prt("Set output directory to [$out_dir].\n") if (VERB1());
                } else {
                    pgm_exit(1,"ERROR: Output directory [$out_dir] does NOT exist!\n");
                }
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            if (got_wild($arg)) {
                glob_wild($arg);
            } else {
                $in_file = $arg;
                if (-f $in_file) {
                    push(@in_files,$in_file);
                    prt("Added input [$in_file]\n") if (VERB1());
                } else {
                    pgm_exit(1,"ERROR: Unable to locate [$in_file]!\n");
                }
            }
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on && length($def_file) && (-f $def_file)) {
        $in_file = $def_file;
        prt("Set DEFAULT input to [$in_file]\n");
        push(@in_files,$in_file);
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file [in-file2[ ...]]\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <dir>   (-o) = Write output to this directory, as in-file-current.\n");
}

# eof - showuncommented.pl
