#!/usr/bin/perl -w
# NAME: showvcincs.pl
# AIM: To find the MSVC 'INCLUDE' direcories
# 04/12/2010 - review
# 14/09/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl'! Check if exist, and the \@INC global...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';

my $debug_on = 0;
my $def_file = 'def_file';
###my %files_searched_nc = ();

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;
my $verbosity = 0;

sub VERB1() { return ($verbosity > 0); }
sub VERB2() { return ($verbosity > 1); }
sub VERB5() { return ($verbosity > 4); }
sub VERB9() { return ($verbosity > 8); }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        #prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

########################################################
### DIRECTORY SCANNING ###
sub ac_do_dir_scan($$$);

sub do_dir_scan($$$) {
    my ($rparams,$dir,$lv) = @_;
    my $rda = ${$rparams}{'CURR_DIR_SCAN'};
    $dir .= "\\" if !($dir =~ /(\\|\/)$/);
    $dir = path_u2d($dir);
    my ($file,$ff,$n,$d);
    my @dirs = ();
    prt("Moment, doing full directory scan of [$dir]...\n") if (($lv == 0) && VERB9());
    if (opendir(DIR,$dir)) {
        my @files = readdir(DIR);
        closedir(DIR);
        foreach $file (@files) {
            next if (($file eq '.')||($file eq '..'));
            $ff = $dir.$file;
            if (-d $ff) {
                push(@dirs,$ff);
                next;
            }
            #             0     1   2 3
            push(@{$rda},[$file,$ff,0,0]);
        }
    } else {
        prtw("WARNING: FAILED to OPEN [$dir]\n");
    }
    if (@dirs) {
        foreach $file (@dirs) {
            do_dir_scan($rparams,$file,$lv+1);
        }
    }
    if ($lv == 0) {
        $file = scalar @{$rda};
        prt("Done scan... got $file files...\n") if (VERB9());
        ${$rparams}{'CURR_DONE_SCAN'} = 1;
        ${$rparams}{'CURR_FILE_COUNT'} = $file;
    }
}

sub get_anon_hash() {
    my %h = ();
    return \%h;
}

sub get_dir_scan_rh($) {
    my ($dir) = @_;
    my $rparams = get_anon_hash();
    ${$rparams}{'CURR_DONE_SCAN'} = 0;
    ${$rparams}{'CURR_DIR_SCAN'} = [];
    do_dir_scan($rparams,$dir,0);
    return $rparams;
}

#########################################
### MAIN ###
parse_args(@ARGV);
# prt( "$pgmname: in [$cwd]: Hello, World...\n" );
# process_in_file($in_file);
my $id = '';
my ($insdir);
if (vc_get_include_dirs2(\$insdir,0) ) {
    my $cnt = scalar @{$insdir};
    # prt("OK got $cnt\n");
    my @vc8 = ();
    my %dirs = ();
    my $rd = \%dirs;
    my ($dir,$min,$len);
    foreach $dir (@{$insdir}) {
        if (-d $dir) {
            if ( add_to_files_lc($dir,$rd) ) {
                # already in LIST
            } else {
                push(@vc8,$dir);
            }
        }
    }
    if (@vc8) {
        $cnt = scalar @vc8;
        prt("Got $cnt 'MSVC' directories... using vcvarsall.bat\n") if (VERB1());
        $min = 0;
        foreach $dir (@vc8) {
            $len = length($dir);
            $min = $len if ($len > $min);
        }
        foreach $dir (@vc8) {
            if (VERB1()) {
                my $rh = get_dir_scan_rh($dir);
                $cnt = ${$rh}{'CURR_FILE_COUNT'};
                $dir .= " " while (length($dir) < $min);
                prt("$dir - with $cnt files...\n");
            } else {
                prt(" [$dir]\n");
            }
        }
    }
} else {
    prt("Failed to get include directories!\n");
}

#if (get_vs_install_dir(\$id)) {
#    prt("Got [$id]\n");
#} else {
#    prt("Failed to get Visual Studio installed directory!\n");
#}

pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
    prt(" --verbose    (-v) = Bump verbosity.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/i) {
                if ($sarg =~ /^v(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/i) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Set verbosity to $verbosity\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            #$in_file = $arg;
            #prt("Set input to [$in_file]\n") if (VERB1());
            pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
        }
        shift @av;
    }

#    if ((length($in_file) ==  0) && $debug_on) {
#        $in_file = $def_file;
#    }
#    if (length($in_file) ==  0) {
#        pgm_exit(1,"ERROR: No input files found in command!\n");
#    }
#    if (! -f $in_file) {
#        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
#    }
}

# eof - showvcincs.pl
