#!/perl -w
# *NAME* split_words.pl
# AIM: To take a joind word like "ApplePieCustardTart"
# and split it out to "Apple Pie Custard Tart"
# Note combined word HAS TO START with a CAPITAL LETTER - A-Z ...
# Nice taste of iterative calling to complete the job ;=))
# goeff mclane - http://geoffmclane.com - 20070209
#################################################################
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
prt( split_words("Apple")."\n" );
prt( split_words("ApplePie")."\n" );
prt( split_words("ApplePieCustard")."\n" );
prt( split_words("ApplePieCustardTart")."\n" );
prt( split_words("willFail")."\n" );
prt( split_words("ABCIsSPlit")."\n" );
close_log($outfile,1);
exit(0);


sub split_words {
	my ($hw) = shift;
	my ($tmp, $off);
	if ($hw =~ /^[A-Z]/) {
		$tmp = substr($hw,1); # remove initial capital
		if ($tmp =~ /([A-Z])/) { # if we have other capital(s)
			$off = index($tmp, $1);	# get index of CAPITAL
			###if (($off != -1)&&($off > 1)) { # use this to NOT split "AB"
			if ($off != -1) {
				$hw = substr($hw,0,$off+1).' '.split_words(substr($hw,$off+1));
			}
		}
	}
	return $hw;
}

# eof
