#!/perl -w
# NAME: test-bucket2.pl
# AIM: Final debug on Bucket2.pm
# 18/11/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use Bucket2; # see Bucket2.pm
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
#prt( "$0 ... Hello, World ...\n" );

my $in_lon = -122.38;
my $in_lat =   37.62;

sub show_bucket($$) {
   my ($lon,$lat) = @_;
   my $bucket = Bucket2->new;
   prt("Using lon=$lon, lat=$lat\n");
   $bucket->set_bucket($lon,$lat);
   prt( "Bucket info = [".$bucket->bucket_info()."]\n" );
   prt( "Base path = ". $bucket->gen_base_path() . "\n" );
}

show_bucket($in_lon,$in_lat);
close_log($outfile,0);
exit(0);

# eof
