#!/usr/bin/perl
#< test-type.pl

sub prt($) { print shift }

my %freq_types = (
    'GRD' => 'GROUND',
    'GND' => 'GROUND',
    'TWR' => 'TOWER',
    'APP' => 'APPROCH',
    'DEP' => 'DEPARTURE',
    'ATIS' => 'ATIS',
    'ZONE' => 'ZONE',
    'INFO' => 'INFORMATION',
    'DEL' => 'DELIVERY',
    'VORTAC' => 'VOR-DME',
    'VOR-DME' => 'VORTAC',
    'RDR' => 'APPROACH'
    );

my %full_types = (
    'INFORMATION' => 'ATIS',
    'TOWER' => 'TWR',
    'RADAR' => 'APP',
    'GROUND' => 'GND',
    'DELIVERY' => 'GND',
    'VORTAC' => 'VOR-DME',
    'VOR-DME' => 'VORTAC',
    'DIRECTOR' => 'APP',
    'INFORMATION' => 'ATIS',
    'APPROACH' => 'APP'
    );

sub same_base_type($$);
sub same_base_type($$) {
    my ($t1,$t2) = @_;
    return 1 if ($t1 eq $t2);
    my @a1 = split(/\s+/,$t1);
    my @a2 = split(/\s+/,$t2);
    my $l1 = scalar @a1;
    my $l2 = scalar @a2;
    my %h = ();
    my $same = 0;
    my ($tmp,$tmp2);
    if ($l1 > $l2) {
        foreach $tmp (@a1) {
            $h{$tmp} = 1;
            if (defined $full_types{$tmp}) {
                $tmp = $full_types{$tmp};
                $h{$tmp} = 1;   # add short name to list
            }
        }
        foreach $tmp (@a2) {
            if (defined $h{$tmp}) {
                $same++;
                $same++ if (defined $freq_types{$tmp});
            } elsif (defined $full_types{$tmp}) {
                $tmp2 = $full_types{$tmp};
                $same++ if (defined $freq_types{$tmp2});
            }
        }
    } else {
        foreach $tmp (@a2) {
            $h{$tmp} = 1;
            if (defined $full_types{$tmp}) {
                $tmp = $full_types{$tmp};
                $h{$tmp} = 1;   # add short name to list
            }
        }
        foreach $tmp (@a1) {
            if (defined $h{$tmp}) {
                $same++;
                $same++ if (defined $freq_types{$tmp});
            } elsif (defined $full_types{$tmp}) {
                $tmp2 = $full_types{$tmp};
                $same++ if (defined $freq_types{$tmp2});
            }
        }
    }
    return 1 if ($same > 1);
    if ((($l1 + $l2) <= 4) && $same) {
        return $same;
    }
    my $chg = 0;
    if ($t1 =~ /\//) {
        $t1 =~ s/\// /;
        $chg++;
    }
    if ($t2 =~ /\//) {
        $t2 =~ s/\// /;
        $chg++;
    }
    if ($chg) {
        return same_base_type($t1,$t2);
    }
    return 0; # not same
}


my $t1 = 'TORONTO GND';
my $t2 = 'GND';

if (same_base_type($t1,$t2)) {
    prt("SAME $t1 vs $t2\n");
} else {
    prt("DIFF $t1 vs $t2\n");
}

$t1 = 'MANSTON TOWER';
$t2 = 'APP RADAR';
if (same_base_type($t1,$t2)) {
    prt("SAME $t1 vs $t2\n");
} else {
    prt("DIFF $t1 vs $t2\n");
}

$t1 = 'SUMBURGH INFORMATION';
$t2 = 'ATIS';
if (same_base_type($t1,$t2)) {
    prt("SAME $t1 vs $t2\n");
} else {
    prt("DIFF $t1 vs $t2\n");
}

#YXU N [LONDON VOR-DME] vs [LONDON VORTAC]
$t1 = 'LONDON VOR-DME';
$t2 = 'LONDON VORTAC';
if (same_base_type($t1,$t2)) {
    prt("SAME $t1 vs $t2\n");
} else {
    prt("DIFF $t1 vs $t2\n");
}

# YZP N [SANDSPIT VOR-DME] vs [SANDSPIT VORTAC]
$t1 = 'SANDSPIT VOR-DME';
$t2 = 'SANDSPIT VORTAC';
if (same_base_type($t1,$t2)) {
    prt("SAME $t1 vs $t2\n");
} else {
    prt("DIFF $t1 vs $t2\n");
}

$t1 = "STRING TWR";
$t2 = substr($t1,0,-1);
prt("stg [$t1] became [$t2]\n");

sub same_base_name($$);
# AGGL N [SANTA CRUZ/GRACIOSA BAY/LUOVA] vs [SANTA CRUZ] 
# AU14 N [LAIDER'S STRIP] vs [LAIDERS STRIP] 
# EDDF N [FRANKFURT AM MAIN] vs [FRANKFURT-MAIN] 
sub same_base_name($$) {
    my ($t1,$t2) = @_;
    return 1 if ($t1 eq $t2);
    my @a1 = split(/\s+/,$t1);
    my @a2 = split(/\s+/,$t2);
    my $l1 = scalar @a1;
    my $l2 = scalar @a2;
    my %h = ();
    my $same = 0;
    my ($tmp);
    if ($l1 > $l2) {
        foreach $tmp (@a1) {
            $h{$tmp} = 1;
        }
        foreach $tmp (@a2) {
            if (defined $h{$tmp}) {
                $same++;
                $same++ if (defined $freq_types{$tmp});
            }
        }
    } else {
        foreach $tmp (@a2) {
            $h{$tmp} = 1;
        }
        foreach $tmp (@a1) {
            if (defined $h{$tmp}) {
                $same++;
                $same++ if (defined $freq_types{$tmp});
            }
        }
    }
    return 1 if ($same > 1);
    my $mod = 0;
    if ($t1 =~ /\//) {
        $t1 =~ s/\// /g;
        $mod++;
    }
    if ($t2 =~ /\//) {
        $t2 =~ s/\// /g;
        $mod++;
    }
    if ($t1 =~ /\'/) {
        $t1 =~ s/\'//g;
        $mod++;
    }
    if ($t2 =~ /\'/) {
        $t2 =~ s/\'//g;
        $mod++;
    }
    if ($t1 =~ /-/) {
        $t1 =~ s/-/ /g;
        $mod++;
    }
    if ($t2 =~ /-/) {
        $t2 =~ s/-/ /g;
        $mod++;
    }
    if ($mod) {
        return same_base_name($t1,$t2);
    }
    return 0; # not same
}

$t1 = 'SANTA CRUZ/GRACIOSA BAY/LUOVA';
$t2 = 'SANTA CRUZ';

if (same_base_name($t1,$t2)) {
    prt("SAME $t1 vs $t2\n");
} else {
    prt("DIFF $t1 vs $t2\n");
}
