#!perl -w
# test4.pl
# AIM: To use my own zip8.bat to get the list of files, within a zip file
# This zip8.bat just uses the command line addin of WINZIP
# @set TEMPWZ="C:\Program Files\WinZip\WZZIP.EXE"
# @%TEMPWZ% %1 %2 %3 %4 %5 %6 %7 %8 %9
# #########################################################
use File::stat; # to get the file date
require "logfile.pl" or die "ERROR: Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

$pline = ' IgnoreDefaultLibraryNames="libcd"';
$igl = 'IgnoreDefaultLibraryNames="(\\w+)"';
if ($pline =~ /$igl/) {
	prt( "Got [$1] ...\n" );
} else {
	prt( "NOT GOT\n" );
}

##$file = 'F:\FGCVS\fltk-1.1\vc2005\arc.vcproj';
##$ofile = 'tempout.txt';
##open IF, "<$file" or die "Failed to OPEN $file ...\n";
##@lines = <IF>;
##close IF;
##print "Got ".scalar @lines." lines ...\n";
##open OF, ">$ofile" or die "Failed to CREATE $ofile ...\n";
##foreach my $line (@lines) {
##	print OF $line;
##}
##close OF;

$my_folder = 'C:\HOMEPAGE\P26\fg';
$file = 'C:\HOMEPAGE\P26\fg\fgfs-01.zip';
$txt = '   10234   10234   0%  25/01/2005  01:40  fg098-FlightGear.zip';
$txt = substr($txt,1) while ($txt =~ /^\s/);
@arr = split(/\s+/,$txt);
prt( "Line has been split into ".scalar @arr." components ...\n" );
foreach $cn (@arr) { prt( "[$cn]\n" ); }
$sn = subactdir($file);

prt( "Dir [$file][$sn]\n" );
$sb = stat($file);
$dtt = YYYYMMDD($sb->mtime);
prt( "$dtt from ".scalar localtime($sb->mtime)."\n" );
prt( "current = ". YYYYMMDD(time()) . " or " . scalar localtime(time()) . " ...\n" );
$res = get_zip_txt($file);
prt( "Results are\n" );
prt( $res );
@zarr = split("\n",$res);
$cnt = scalar @zarr;
prt("Got $cnt lines ...\n");
foreach $ln (@zarr) {
	# note on split ...
	# the perl documentation suggests
	#@zlarr = split(/ /,$ln);  # will split on ALL forms of 'space', \n, \t, etc included
	# but it add lots of blanks, if say splitting
	# eg '   10234   10234   0%  25/01/2005  01:40  fg098-FlightGear.zip'
	# will split into 16 'pieces', which is difficult
	# using 
	# @zlarr = split(/\s+/,$ln); # will reduce the above to 7 pieces, the first being a 'nothing'
	# so it is necessary to 'trim' leading spaces away
	while ($ln =~ /^\s/) { $ln = substr($ln,1); }
	@zlarr = split(/\s+/,$ln); # will reduce the above to 6 pieces, as desired 6 pieces
	$lcnt = scalar @zlarr;
	prt("Got $lcnt pieces ... last=[$zlarr[-1]]... \n");
	for (my $i = 0; $i < $lcnt; $i++) {
		$msg = ' ' . ($i + 1) . ' ';
		$msg .=  '[' . $zlarr[$i] . ']';
		prt( "$msg\n" );
	}
}
close_log($outfile,1);
exit(1);

# eg '    5168    1312  75%  30/01/2005  12:10  Atlas/Map/Map.vcproj';
sub get_zip_txt($) {
	my ($f) = shift;
	my $rd = "tempzips.txt";
	if ( -f $rd) {
		#prt("Removing [$rd] ...\n");
		unlink $rd;
	}
	my @zargs = ('zip8','-vb',$f, '>', $rd);
	my $result = system(@zargs);
	open ZIN, "<$rd" or die "Unable to open $rd ...\n";
	my @arr = <ZIN>;
	close ZIN;
	my $inblk = 0;
	my $rmsg = '';
	##print "Got ".scalar @arr." lines ...\n";
	foreach my $ln (@arr) {
		chomp $ln;
		$ln =~ s/\r$//;
		###print "$ln\n";
		if ($ln =~ /-----\s+----/) {
			if ($inblk) {
				$inblk = 0;
			} else {
				$inblk = 1;
			}
		} elsif ($inblk) {
			$rmsg .= "$ln\n";
		}
	}
	return $rmsg;
}

sub dos_2_unix($) {
	my ($du) = shift;
	print "Got $du ...\n";
	$du =~ s,\\,\/,g;
	return $du;
}

# sub root folder from full name
sub subactdir($) {
	my ($d) = shift;
	my $rt = dos_2_unix($my_folder);
	print "In d=[$d] rt=[$rt] \n";
	$d = dos_2_unix($d);
	print "Unix [$d] ...\n";
	$d =~ s,^$rt,,;
	if (length($d)) {
		$d =~ s,^/,,;
	}
	return $d;
}

################################################
# My particular time 'translation' - replaced date_string
sub YYYYMMDD {
	#  0    1    2     3     4    5     6     7     8
	my ($tm) = shift;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($tm);
	$year += 1900;
	$mon += 1;
	my $ymd = "$year/";
	if ($mon < 10) {
		$ymd .= '0'.$mon.'/';
	} else {
		$ymd .= "$mon/";
	}
	if ($mday < 10) {
		$ymd .= '0'.$mday;
	} else {
		$ymd .= "$mday";
	}
    print "s=$sec,m=$min,h=$hour,md=$mday,m=$mon,y=$year,wd=$wday,yd=$yday,id=$isdst\n";
	return $ymd;
}

