#!/perl -w
# NAME: testdsphdrs.pl
# AIM: To test how to implement new headers, and options
# 8/19/2009 - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use File::Basename;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $fil = '..\..\src\file.c';

my ($nm,$dr,$ex) = fileparse( $fil, qr/\.[^.]*/ );

my %options = (
	'CompileAs' => 2
	);

my %compileas = (
	0 => "",
	1 => "TC",
	2 => "TP"
	);

prt( "Got [$nm] [$dr] [$ex]\n" );

sub get_common_header() {
	my $com_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

EOF
	return $com_head;
}

sub get_common_body() {
	my $com_body = <<EOF;

CFG=-NEW_PROJECT_NAME- - Win32 Release
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
EOF
	return $com_body;
}

sub get_orig_header() {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Console Application" 0x0103

CFG=-NEW_PROJECT_NAME- - Win32 Release
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
EOF
	return $dsp_head;
}

sub get_new_header($) {
	my ($ropt) = shift;
	my $nh = get_common_header();
	$nh .= "# TARGTYPE \"Win32 (x86) Console Application\" 0x0103\n";
	$nh .= get_common_body();
	foreach my $k (keys %$ropt) {
		my $v = $$ropt{$k};
		if ($k eq 'CompileAs') {
			if (defined $compileas{$v} ) {
				my $flag = $compileas{$v};
				prt( "Option: $k, value $v, flag /$flag\n" );
			} else {
				prt( "Option: $k, value $v FLAG UNKNOWN\n" );
			}
		} else {
			prt( "Option: $k, value $v\n" );
		}
	}
	return $nh;
}

my $nh = get_new_header(\%options);
my $oh = get_orig_header();
if ($nh ne $oh) {
	prt("Different!\n");
} else {
	prt("Same ;=))\n");
}


close_log($outfile,0);
exit(0);

# eof
