#!/Perl


require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file and some other utility subs
require "htmltools.pl" or die "Missing htmltools.pl ...\n";
require "currencyISO.pl" or die "Missing currencyISO.pl ...\n";

# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';

# test ISO to Currency ...
open_log($outfile);
prt( "$0...Hello, World...\n" );
my $add_table = 0;
my $mult_test = 0;
prt( "ISO AED = ".ISO2Currency('AED')."\n");

if ($mult_test) {
	my %test = Currency2ISO('dollar');
	my $cnt = keys %test;
	if ($cnt) {
		$cnt = 0;
		foreach my $k (keys %test) {
			$cnt++;
			prt( "$cnt $k ISO ".$test{$k}."\n");
		}
	}
}

if ($add_table) {
	my $file = 'tempiso.htm';
	my $msg = "<html>\n";
	$msg .= "<head>\n";
	$msg .= "<title>ISO Currency Table</title>\n";
	$msg .= "</head>\n";
	$msg .= "<body>\n";
	$msg .= "<p>\n";
	$msg .= RetISOTableText();
	$msg .= "</p>\n";
	$msg .= "</html>\n";
	write2file( $msg, $file );
	system($file);
}

prt( "ISO AED = Country [".ISO2Country('AED')."]\n" );
prt( "ISO ZW = Country [".ISO2Country('ZW')."]\n" );

my $country1 = 'Australia';
my $country2 = 'Australian';
my $iso = '';
my $curr = '';
my $cc = '';
my $code = '';
my %c2i = ();
my $kcnt = 0;
my ($k, $v);
my $rc2i;
my %donecurr = ();
prt( "ISO ".Country2ISO($country1)." for $country1 \n");
prt( "ISO ".Country2ISO($country2)." for $country2 \n");

my @ctrys = ('Australian', 'Brazilian',
'British', 'Canadian', 'Chinese', 'Danish', 'Euro', 'Hong Kong',
'Indian', 'Japanese', 'Malaysian', 'Mexican', 'New Zealand',
'Norwegian', 'Singapore', 'South African', 'South Korean',
'Sri Lanka', 'Swedish', 'Swiss', 'Taiwan', 'Thai',
'Venezuelan' );

foreach my $ct (@ctrys) {
	$iso = Country2ISO($ct);
	$cc = ISO2Currency($iso);
	$curr = ISO2CurrencyOnly($iso);
	##%c2i = Currency2ISO($curr);
	$rc2i = Currency2ISO($curr);
	prt( "ISO [$iso] for $ct ... $cc ... Currency = $curr\n");
	###$kcnt = keys %c2i;
	$kcnt = keys %$rc2i;
	if ($kcnt) {
		if (defined $donecurr{$curr}) {
			prt( "   $kcnt, as given above ...\n" );
		} else {
			$donecurr{$curr} = 1;
			prt( "   $kcnt use this currency ...\n" );
			$kcnt = 0;
			###foreach $k (%c2i) {
			##foreach $k (%$rc2i) {
			##	##$v = $c2i{$k};
			##	$v = $rc2i{$k};
			##	$kcnt++;
			##	prt( "   $kcnt [$k] => [$v]\n" );
			##}
			while (($k, $v) = each %$rc2i) {
				$kcnt++;
				prt( "   $kcnt [$k] => [$v]\n" );
			}
		}
	} else {
		prt( "WARNING: Appears NO countries use this currency!\n" );
	}
}

close_log($outfile,1);


# testiso.pl

