#!/Perl

# ISO' => 'Country'
my %CurrencyISO = (
'AED' => 'United Arab Emirates Dirhams',
'AUD' => 'Australia Dollars',
'AWG' => 'Aruba Guilders',
'BBD' => 'Barbados Dollars',
'BMD' => 'Bermuda Dollars' );

print "test ISO to Currency ...\n";
print "ISO AWG = ".ISO2Currency('AWG')."\n";
print "test Currency to ISO ...\n";
my $ref_test = Currency2ISO('dollar');
my $cnt = keys %$ref_test;
if ($cnt) {
	while (my ($k, $v) = each %$ref_test) {
		print "ISO [$k] => [$v]\n";
	}
} else {
	print "FAILED\n";
}
exit(0);

sub ISO2Currency {
	my ($iso) = shift;
	my $v = '';
	foreach my $k (keys %CurrencyISO) {
		if ($k eq $iso) {
			$v = $CurrencyISO{$k};
			return $v;
		}
	}
	return "NOT FOUND $iso";
}

sub Currency2ISO {
	my ($cur) = shift;
	my %aa = ();
	my $v = '';
	foreach my $k (keys %CurrencyISO) {
		$v = $CurrencyISO{$k};
		if ($v =~ /$cur/i) {
			###print "Added [$k] [$v]\n";
			$aa{$k} = $v;
		}
	}
	return \%aa;	# return a reference
}
# testiso2.pl