#!/perl -w
# NAME: toclipboard.pl
# AIM: Copy the command given to the clipboard. If no command, show clipboard
use strict;
use warnings;
use Win32::Clipboard;
### use Clipboard;

sub prt($) { print shift; }

my $copyto = '';
my ($tmp);

foreach $tmp (@ARGV) {
    $copyto .= ' ' if (length($copyto));
    $copyto .= $tmp;
}

my $CLIP = Win32::Clipboard();

if (length($copyto)) {
    prt( "Copying [$copyto] to the clipboard...\n" );
    $CLIP->Set($copyto);
} else {
    prt("Getting the clipboard...\n");
    my $cont = Win32::Clipboard::GetText();
    if ($cont =~ /^Win32::Clibboard/) {
        prt( "Clipboard: is EMPTY!\n");
    } else {
        prt( "Clipboard: [$cont]\n");
    }
}

exit(0);

# eof
