#!/usr/bin/perl -w
#< unix-time.pl
use strict;
use warnings;

sub prt($) { print shift }

#my $time = time;    # or any other epoch timestamp 
my @months = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

sub show_local_time($) {
    my $time = shift;
    my ($sec, $min, $hour, $day,$month,$year) = (localtime($time))[0,1,2,3,4,5]; 
    # You can use 'gmtime' for GMT/UTC dates instead of 'localtime'
    prt( "Unix time ".$time." converts to ".$months[$month]." ".$day.", ".($year+1900) );
    prt( " ".$hour.":".$min.":".$sec." LOCAL " );
    ($sec, $min, $hour, $day,$month,$year) = (gmtime($time))[0,1,2,3,4,5]; 
    # You can use 'gmtime' for GMT/UTC dates instead of 'localtime'
    prt( "and ".$months[$month]." ".$day.", ".($year+1900) );
    prt( " ".$hour.":".$min.":".$sec." UTC\n" );
}

show_local_time(time());

if (@ARGV) {
    my @av = @ARGV;
    my ($tm);
    while (@av) {
        show_local_time($av[0]);
        shift @av;
    }
} else {
    prt("Give unix epoch time to convert...\n");
}