#!/perl -w
# NAME: vc8config.pl
# AIM: To read a config.h.in file, and write a config.h, using
# the include PATH of MSVC8
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my @headers = ();
my $hcnt = 0;
my $vc8_inc = "C:\\Program Files\\Microsoft Visual Studio 8\\VC\\INCLUDE";
my $cfg_in = "C:\\FG\\FGCOM\\libtheora\\config.h.in";
my @vc8includes = ();
my $vc8cnt = 0;
# debug
my $dbg1 = 0;	# show includes, as found ...
my $dbg2 = 0;	# show config.h.in decode as found ...

load_includes( $vc8_inc );
$vc8cnt = scalar @vc8includes;
prt( "Got $vc8cnt include from [$vc8_inc]...\n" );
load_cfg_in( $cfg_in );
$hcnt = scalar @headers;
prt( "Found $hcnt items ...\n" );
find_headers();

close_log($outfile,1);
exit(0);

########################################
####### subs

sub load_includes {
	my ($dir) = shift;
	if ( opendir(DH, $dir) ) {
		my @files = readdir(DH);
		closedir(DH);
		foreach my $fil (@files) {
			next if ($fil eq '.');
			next if ($fil eq '..');
			my $ff = $dir;
			$ff .= "\\" if ( !($fil =~ /[\\\/]$/) );
			$ff .= $fil;
			if ( -d $ff) {
				load_includes($ff);
			} else {
				my $sf = substr($ff, length($vc8_inc));
				$sf =~ s/^[\\\/]//;
				prt( "$sf\n" ) if ($dbg1);
				push(@vc8includes, $sf);
			}
		}
	} else {
		prt( "WARNING: FAILED TO OPEN [$dir] ...\n" );
	}
}

sub load_cfg_in {
	my ($fil) = shift;
	if (open(INF, "<$fil")) {
		my @lines = <INF>;
		close INF;
		my $lnc = scalar @lines;
		my $inc = '';
		my $def = '';
		my $val = '';
		my $comln = '';
		prt( "Processing $lnc lines from [$fil] ...\n" );
		foreach my $ln (@lines) {
			chomp $ln;
			$ln = trim_all($ln);
			if ($ln =~ /\/\*\s+(.*)\*\//) {
				$comln = $ln;
				my $com = $1;
				#prt( "Comment [$ln] ...\n" );
				prt( "Comment [$com] ...\n" ) if ($dbg2);
				if ($com =~ /<([\w\/\\\.-]+)>/) {
					$inc = $1;
					prt( "Find [$inc] ...\n" ) if ($dbg2);
				}
				push(@headers, [$inc, $def, $val, $comln, $ln]); # if length($inc);
			} elsif ($ln =~ /^#(\w+)\s+(.*).*/) {
				$def = $1;
				$val = $2;
				prt( "$def = $val\n" ) if ($dbg2);
				push(@headers, [$inc, $def, $val, $comln, $ln]); # if length($inc);
				$inc = '';
				$comln = '';
		    } else {
				$def = '';
				$val = '';
				push(@headers, [$inc, $def, $val, $comln, $ln]); # if length($inc);
			}
		}
	} else {
		prt( "WARNING: Failed to open [$fil] ... $! ...\n" );
	}
}

sub dos_2_unix {
	my ($p) = shift;
	$p =~ s/\\/\//g;
	return $p;
}

sub in_vc8include {
	my ($f1) = shift;
	my $vc = scalar @vc8includes;
	my $uf1 = lc(dos_2_unix($f1));
	for (my $j = 0; $j < $vc; $j++) {
		my $uf2 = lc(dos_2_unix($vc8includes[$j]));
		if ($uf1 eq $uf2) {
			return 1;
		}
	}
	return 0;
}

sub find_headers {
	my ($hinc, $hdef, $hval, $hcom, $hln);
	# push(@headers, [$inc, $def, $val]) if length($inc);
	for (my $i = 0; $i < $hcnt; $i++) {
		$hinc = $headers[$i][0];
		$hdef = $headers[$i][1];
		$hval = $headers[$i][2];
		$hcom = $headers[$i][3];
		$hln = $headers[$i][4];
		if (length($hdef) && length($hval)) {
			if (length($hinc)) {
				if (in_vc8include($hinc)) {
					prt( "#define $hval 1\n" );
				} else {
					prt( "#undef $hval\n" );
				}
			} else {
				prt( "#$hdef $hval\n" );
			}
		} else {
			prt( "$hln\n" );
		}
	}
}


# eof - vc8config.pl
