#!/perl -w
# NAME: vcproj03.pl
# AIM: Parse a VCPROJ file - get_xml_source() is the service in sln2dsw.pl
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'relative.pl' or die "Unable to load relative.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_file = 'C:\FG\FGRUN\fgrunplib\fgrun.vcproj';
##my $in_file = 'C:\Projects\pcre\pcre4grep\pcre4grep.vcproj';
#my $in_file = 'C:\FG\19\pthreads\pthread.vcproj';
##my $in_file = 'C:\FG\19\OpenAL\OpenAL-Windows\Alu\ALu.vcproj';
##my $in_file = 'C:\FG\19\OpenAL\OpenAL-Windows\OpenAL32\OpenAL32.vcproj';
# Options
my $killfilt = 1;	# kill the filter name and type on </Filter>

my @dsp_base_defs_rel = qw( WIN32 NDEBUG _WINDOWS _MBCS );
my @dsp_base_defs_dbg = qw( WIN32 _DEBUG _WINDOWS _MBCS );
my @dsp_base_libs_rel = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );
my @dsp_base_libs_dbg = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );

# default items for Application (windows and console)
my $def_runtime_rel = '/MT';
my $def_runtime_dbg = '/MTd';
my $def_defines_dbg = '/D "_CRT_SECURE_NO_WARNINGS"';
my $def_defines_rel = '/D "_CRT_SECURE_NO_WARNINGS"';
my $def_libs_rel = 'comctl32.lib Msimg32.lib Winmm.lib';
my $def_libs_dbg = 'comctl32.lib Msimg32.lib Winmm.lib';

# program variables
my $dsp_runtime_dbg = '';
my $dsp_runtime_rel = '';
my $dsp_defines_dbg = '';
my $dsp_defines_rel = '';
my $dsp_libs_rel = '';
my $dsp_libs_dbg = '';

# debug
my $dbg_src1 = 0;
my $dbg_src10 = 1;
my $dbg_src11 = 0;
my $dbg_src12 = 0;
my $dbg_src13 = 0;
my $dbg_src12a = 0;
my $dbg_src14 = 1;
my $dbg_src15 = 1;
my $dbg_src16 = 0;
my $dbg_src2 = 0;
my $dbg_src3 = 0;
my $dbg_src4 = 0;
my $dbg_src5 = 0;
my $dbg_src6 = 0;
my $dbg_src7 = 0;
my $dbg_src8 = 1;
my $dbg_src9 = 0;
my $dbg_srcc = 0;
my $dbg_srcv = 0;
my $dbg11 = 0;
my $act_vcproj = '';
my @warnings = ();

# maybe _WINDOWS => 'Application'
# ie # TARGTYPE "Win32 (x86) Application" 0x0101 in a DSP file
# but then Alu.vcproj only has -
# PreprocessorDefinitions="NDEBUG;WIN32;AL_BUILD_LIBRARY"
my %v8_defines = ( '_CONSOLE' => 'Console Application',
 '_USRDLL' => 'Dynamic-Link Library',
 '_LIB' => 'Static Library' );
my $typelse = 'Application';
my @special_typing = qw( libpng zlib visualc6 );	# make these STATIC LIBRARIES

my $TYP_OPEN = 1;
my $TYP_CLOSE = 2;
my $TYP_OPENCLOSE = 3;
my $TYP_VERSION = 4;

my $v8_cfgexp = '<Configuration\\s+.*Name=\\"(\\S+)\\"\\s';
my $v8_toolexp = '<Tool\\s+.?\\s*Name=\\"(\\S+)\\"\\s';
my $v8_prepexp = '\\s+PreprocessorDefinitions=\\"(\\S+)\\"';
my %v8_apptyp = ();	# application TYPE, per project name
my %v8_depend = ();	# linker addtional dependencies, by configuration
my %v8_link = ();	# compiler definitions, by configuration
##                  relnm full  group      filter          project
##	push(@v8_srcs, [$src, $ff, $filtname, $filttype, 0, 0, $projname] );
my @v8_srcs = ();	# source found in VCPROJ file

###set_all_debugs();
$act_vcproj = $in_file;
get_xml_sources( $in_file );

close_log($outfile,1);
exit(0);

#################################################

#################################################
##### VCPROJ XML PARSING #####
#################################################
sub get_xml_tag {
	my ($lin) = shift;
	my $len = length($lin);
	my $tag = '';
	my $pch = '';
	for (my $t = 0; $t < $len; $t++) {
		my $ch = substr($lin,$t,1);
		if ($ch eq '<') {
			prtw( "WARNING: Second TAG in line! ($lin)\n" ) if (length($tag));
			$tag = '';
			$t++;
			for ( ; $t < $len; $t++) {
				$ch = substr($lin,$t,1);
				if ($ch =~ /\s/) {
					# end of tag
					$t++;
					for ( ; $t < $len; $t++) {
						$ch = substr($lin,$t,1);
						if ($ch eq '>') {
							$tag .= $pch if ($pch eq '/');
							prtw( "WARNING: Premature CLOSE! ($lin)(1)\n" ) if (($t +1) < $len);
							last;	# end of TAG
						}
						$pch = $ch;	# keep last
					}
					last;
				} elsif ($ch eq '>') {
					prtw( "WARNING: Premature CLOSE! ($lin)(2)\n" ) if (($t +1) < $len);
					last;
				}
				$tag .= $ch;
			}
		}
	}
	return $tag;
}

sub tag_typ_2_stg {
	my ($typ) = shift;
	if ($typ == $TYP_OPEN) {
		return "OPEN";
	} elsif ($typ == $TYP_CLOSE) {
		return "CLOSE";
	} elsif ($typ == $TYP_OPENCLOSE) {
		return "OPENCLOSE";
	} elsif ($typ == $TYP_VERSION) {
		return "VERSION";
	}
	return "UNKNOWN";
}

sub get_tag_typ {
	my ($xt) = shift;
	my $typ = $TYP_OPEN;
	if ($xt =~ /^\//) {
		$typ = $TYP_CLOSE;
	} elsif ($xt =~ /\/$/) {
		$typ = $TYP_OPENCLOSE;
	} elsif ($xt eq '?xml') {
		$typ = $TYP_VERSION;
	}
	###prt( "For [$xt] returning [$typ] ...\n" );
	return $typ;
}

# get application type
# one of Console Application, Application, static library, dynamic library
sub get_app_type {
	my ($defs) = shift;
	my ($def, $key);
	my @arr = split(';',$defs);
	foreach $def (@arr) {
		foreach $key (keys %v8_defines) {
			if ($def eq $key) {
				return $v8_defines{$key};
			}
		}
	}
	# ok, nothing found - TRY HARDER
	foreach $def (@arr) {
		if ($def =~ /BUILD_LIBRARY/) {
			return $v8_defines{'_LIB'};
		} elsif ($def =~ /STATIC/) {
			return $v8_defines{'_LIB'};
		}
	}
	# UGH - still NOT FOUND - provide overrides for
	foreach $def (@special_typing) {
		if ($act_vcproj =~ /$def/) {
			return $v8_defines{'_LIB'};
		}
	}
	prtw( "Warning: String [$defs] does not give clue to TYPE!!!\n$act_vcproj - return def $typelse ??? CHECK ME\n" );
	return $typelse;
}

# split_space - space_split - like split(/\s/,$txt), but honour double inverted commas
sub space_split {
	my ($txt) = shift;
	my $len = length($txt);
	my ($k, $ch, $tag, $incomm);
	my @arr = ();
	$tag = '';
	$incomm = 0;
	for ($k = 0; $k < $len; $k++) {
		$ch = substr($txt,$k,1);
		if ($incomm) {
			$incomm = 0 if ($ch eq '"');
			$tag .= $ch;
		} elsif ($ch =~ /\s/) {
			push(@arr, $tag) if (length($tag));
			$tag = '';
		} else {
			$tag .= $ch;
			$incomm = 1 if ($ch eq '"');
		}
	}
	push(@arr, $tag) if (length($tag));
	if ($dbg_src13) {
		prt( "space_split (".scalar @arr.") of [$txt]\n" );
		foreach $tag (@arr) {
			prt( " $tag\n" );
		}
	}
	return @arr;
}

sub array_2_hash_on_equals {
	my (@inarr) = @_;
	my %hash = ();
	my ($itm, @arr, $key, $val, $al, $a);
	foreach $itm (@inarr) {
		@arr = split('=',$itm);
		$al = scalar @arr;
		$key = $arr[0];
		$val = '';
		for ($a = 1; $a < $al; $a++) {
			$val .= '=' if length($val);
			$val .= $arr[$a];
		}
		if (defined $hash{$key}) {
			prt( "WARNING: Duplicate KEY: $key ...\n" );
			$hash{$key} .= "@".$val;
		} else {
			$hash{$key} = $val;
		}
	}
	return %hash;
}

# @arr = split_conf( $dsp_defines_dbg );
sub split_conf {
	my ($cc) = shift;
	my $ln = length($cc);
	my @ar = ();
	my $itm = '';
	for (my $p = 0; $p < $ln; $p++) {
		my $ch = substr($cc,$p,1);
		if ($ch eq '"') {
			$p++;
			$itm = '';
			for (; $p < $ln; $p++) {
				$ch = substr($cc,$p,1);
				if ($ch eq '"') {
					last;
				}
				$itm .= $ch;
			}
			push(@ar,$itm) if length($itm);
		}
	}
	return @ar;
}

sub is_in_skip_conf_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_rel) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_conf_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_dbg) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}

sub is_in_skip_lib_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_rel) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_lib_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_dbg) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}

sub set_runtime_dbg { $dsp_runtime_dbg = shift; }
sub set_runtime_rel { $dsp_runtime_rel = shift; }

# get_xml_source
# process the XML project file (*.vcproj) and
# extract the SOURCE file list,
# but do lots MORE than that ...
sub get_xml_sources {
	my ($in) = shift;
	##my $in_fd = file_dirname($in);
	my ($name,$in_fd,$suffix) = fileparse($in);
	my ($src, $ff, $pline);
	my $stf = '<File\\s+RelativePath=\\"([\\.\\\\\\w-]+)+\\"+(.)+';
	#my $filt = '^<Filter\\s+Name=\\"([\\w\\s]+)\\"\\s+Filter=\\"([\\w;]+)\\"';
	my @lines = ();
	my $line = '';
	my $filtname = '';
	my $filttype = '';
	my $conf = '';
	my $tname = '';
	my $version = '';
	my $projname = '';
	my $srccount = 0;
	my @xmltags = ();
	my $xmltag = '';
	my $tagtyp = 0;
	my $lnnum = 0;
	my $bgn = 0;
	my $end = 0;
	my $ll = 0;
	my $ch = '';
	my $bgnend = '';
	my $inconfigs = 0;
	my $ppdefs = '';
	my $apptype = '';
	my $adddeps = '';
	my @attribs = ();
	my %atthash = ();
	my $ctype = 0;
	my $def = '';
	my ($func, $itm, $ffnr);
	prt( "Loading [$in] file in directory [$in_fd] ...\n" );
	open FH, "<$in" or mydie( "ERROR: Can not open [$in] ... aborting ...\n" );
	@lines = <FH>; # slurp the whole file
	close( FH );
	my $fline = '';
	prt( "Processing ".scalar @lines." lines in $in ...\n" );
	my $hadver = 0;
	foreach $line (@lines) {
		$lnnum++;
		$line = trim_all($line);
		$ll = length($line);
		if ($ll) {
			if (length($fline)) {
				$fline .= ' '.$line;
			} else {
				$ch = substr($line,0,1);
				$fline .= $line;
				if ($ch eq '<') {
					$bgn = $lnnum;
				}
			}
		} else {
			next;
		}
		if ($fline =~ />/) {
			$bgnend = "$bgn-$lnnum";
			$bgn = -1;
			$xmltag = get_xml_tag($fline);
			$tagtyp = get_tag_typ($xmltag);
			prt( "$bgnend: $xmltag ".tag_typ_2_stg($tagtyp). " ($tagtyp)\n" ) if ($dbg_src9);
			if ($fline =~ /<VisualStudioProject\s+/) {
				if ($fline =~ /.+Version="(\d+\.{1}\d+)+".+/ ) {
					$version = $1;
				}
				if ($fline =~ /.+Name="(\w+)".+/) {
					$projname = $1;
				}
				##prt( "$fline\n" );
				prt( "Project=$projname, v=$version\n" ) if ($dbg_src11);
			} elsif ($fline =~ /$stf/) {
				# <File RelativePath="src\FDM\SP\ACMS.cxx" >
				$src = $1;
				$ff = $in_fd . $src;
				$ffnr = fix_rel_path($ff);
				$itm = "MISSING";
				if (-f $ffnr) {
					$itm = "ok";
					prt( "SRC: [$ffnr] $itm\n" ) if ($dbg_src16);
				} else {
					$itm .= " [$src][$ff] CHECKME!";
					prt( "SRC: [$ffnr] $itm\n" );	# always SHOW MISSING if ($dbg_src16);
				}
				if (is_c_source($src)) {
					prt("SOURCE=[$src]\n") if ($dbg_src1);
					#push(@csrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} elsif (is_h_source($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
					#push(@hsrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} elsif (is_h_special($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
					#push(@hsrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} else {
					prt("OTHER=[$src]\n") if ($dbg_src3);
					#push(@osrc_array, [$src, $ff, $filtname, $filttype, 0] );
				}
				$srccount++;
				#                0    1      2          3          4  5  6
				push(@v8_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname] );
				prt( "$srccount v8_srcs: $src, $ffnr, $filtname, $filttype, 0, 0, $projname);\n" ) if ($dbg11);

			} elsif ($fline =~ /<Filter\s+(.*)/) {
				# <Filter Name="Source Files" Filter="cpp;c;cxx;rc;def;r;odl;idl;hpj;bat">
				$filtname = ''; # = NO FILTER NAME, like Source Files
				$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				if ($fline =~ /\s+Name=\"([\w\s]+)\"[\s>]+/) {
					$filtname = $1; # = Source Files
				}
				if ($fline =~ /\s+Filter=\"([\w;,]+)\"[\s>]+/) {
					$filttype = $1; # = cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
				prt("FILTNAME=[$filtname] [$filttype]\n") if ($dbg_src4);
			} elsif ($fline =~ /$v8_cfgexp/ ) {
				##if ($fline =~ /<Configuration\s+.*Name=\"(\S+)\"\s/ ) {
				$conf = $1;
				prt( "Got configuration $conf\n" ) if ($dbg_src6);
			} elsif ($fline =~ /<Tool\s+(.*)$/ ) {
				#} elsif ($fline =~ /$v8_toolexp/ ) {
				$pline = $1;
				#prt( "Got Tool $pline\n" ) if ($dbg_src7);
				if ($pline =~ /\s*Name=\"*(\w+)\"*/) {
					$tname = $1;
					prt( "Got Tool name $tname ($pline)\n" ) if ($dbg_src7);
					if ($tname eq 'VCCLCompilerTool') {
						# <Tool
						# Name="VCCLCompilerTool"
						# Optimization="0"
						# AdditionalIncludeDirectories="../lib,../lib/curl_transport,...
						# PreprocessorDefinitions="_DEBUG;WIN32;_LIB;ABYSS_WIN32;CURL_STATICLIB" 
						# MinimalRebuild="true" 
						# BasicRuntimeChecks="3" 
						# RuntimeLibrary="1" 
						# PrecompiledHeaderFile=".\Debug\xmlrpccpp/xmlrpccpp.pch" 
						# AssemblerListingLocation=".\Debug\xmlrpccpp/" 
						# ObjectFile=".\Debug\xmlrpccpp/" 
						# ProgramDataBaseFileName=".\Debug\xmlrpccpp/" 
						# WarningLevel="3" 
						# SuppressStartupBanner="true" 
						# DebugInformationFormat="4" />]
						$ctype = 0;
						$def = '<UNKNOWN>';
						if ($conf =~ /^Debug\|/) {
							$ctype = 1;
							$def = $dsp_runtime_dbg;
							$func = \&set_runtime_dbg;
						} elsif ($conf =~ /^Release\|/) {
							$ctype = 2;
							$def = $dsp_runtime_rel;
							$func = \&set_runtime_rel;
						}
						prt( "Is compiler tool ...[$fline] ... $conf ($ctype)\n" ) if ($dbg_src14);
						@attribs = space_split($fline);
						%atthash = array_2_hash_on_equals(@attribs);
						if ($dbg_src15) {
							prt( "\nShowing ALL \%atthash keys and values ... [$conf]($ctype)\n" );
							foreach $ppdefs (keys %atthash) {
								prt( "dbg_src15: [$ppdefs] = [$atthash{$ppdefs}] ...\n" );
								if ($ppdefs =~ /RuntimeLibrary/i) {
									prt( "RUNTIME [$ppdefs] = [$atthash{$ppdefs}] ...\n" );
								}
							}
						}

						if ( defined $atthash{'PreprocessorDefinitions'} ) {
							$ppdefs = strip_quotes(trim_all($atthash{'PreprocessorDefinitions'}));
							if ($inconfigs) {
								$apptype = get_app_type($ppdefs);
								prt( "Setting DEFS: $conf [$ppdefs] $apptype ($ctype)\n" ) if ($dbg_src8);
								$v8_link{$conf} = $ppdefs;
								if (defined $v8_apptyp{$projname}) {
									if ($v8_apptyp{$projname} ne $apptype) {
										prtw( "WARNING: ALREADY HAVE $projname with ".$v8_apptyp{$projname}." which is NOT $apptype!!!\n" );
									}
								} else {
									$v8_apptyp{$projname} = $apptype;
								}
							} elsif (length($ppdefs)) {
								prt( "Got DEFS: $conf [$1] OUTSIDE Configurations!\n" ) if ($dbg_src10);
							}
						}
						if ( defined $atthash{'RuntimeLibrary'} ) {
							$ppdefs = strip_quotes(trim_all($atthash{'RuntimeLibrary'}));
							$itm = get_runtime_stg($ppdefs);
							if (($ctype == 1)||($ctype == 2)) {
								if ($itm eq $def) {
									prt( "Got RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm (= $def)\n" );
								} else {
									$func->($itm);
									prt( "Set RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm (was $def)\n" );
								}
							} else {
								prt( "CHECKME:  RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm ($def)\n" );
							}
						}
						prt( "Done atthash for $conf ...\n" )  if ($dbg_src15);
					} elsif ($tname eq 'VCLinkerTool') {
						# <Tool
						# Name="VCLinkerTool"
						# AdditionalDependencies="comctl32.lib Msimg32.lib Winmm.lib"
						# LinkIncremental="1"
						# GenerateDebugInformation="true"
						# SubSystem="2"
						# OptimizeReferences="2"
						# EnableCOMDATFolding="2"
						# TargetMachine="1"
						# />
						prt( "Is linker tool ...[$fline]\n" ) if ($dbg_src7);
						@attribs = space_split($fline);
						%atthash = array_2_hash_on_equals(@attribs);
						if ($dbg_src12a) {	# DEBUG ONLY
							prt( "Split of attribs [$fline] ...\n" );
							foreach $adddeps (@attribs) {
								prt( " $adddeps\n" );
							}
							prt( "Show of HASH ...\n" );
							foreach $adddeps (keys %atthash) {
								prt( " $adddeps = ".$atthash{$adddeps}."\n" );
							}
						}
						if (defined $atthash{'AdditionalDependencies'} ) {
							$adddeps = strip_quotes(trim_all($atthash{'AdditionalDependencies'}));
							prt( "Setting ADDS: $conf [$adddeps]\n" ) if ($dbg_src12);
							$v8_depend{$conf} = $adddeps;
						}
					}
				} else {
					prtw( "WARNING: FAILED Name [$fline]\n" );
				}
			} elsif ($fline =~ /<\/Filter>/) {
				if ($killfilt) {
					$filtname = ''; # = NO FILTER NAME, like Source Files
					$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
			} elsif ($fline =~ /<Platforms/) {
				# 8-8: LINE=[<Platforms>]
			} elsif ($fline =~ /<Platform/) {
				# 9-11: LINE=[<Platform Name="Win32" />]
			} elsif ($fline =~ /<ToolFiles/) {
				# 13-13: LINE=[<ToolFiles>]
			} elsif ($fline =~ /<Configurations/) {
				# 15-15: LINE=[<Configurations>]
				$inconfigs = 1;
				prt( "Enter Configurations ... ($fline)\n" ) if ($dbg_src10);
			} elsif ($fline =~ /<References/) {
				# 167-167: LINE=[<References>]
			} elsif ($fline =~ /<Files/) {
				# 169-169: LINE=[<Files>]
			} elsif ($fline =~ /<FileConfiguration/) {
				# 177-179: LINE=[<FileConfiguration Name="Debug|Win32" >]
			} elsif ($fline =~ /<Globals/) {
				# 591-591: LINE=[<Globals>]
			} else {
				if ($tagtyp == $TYP_VERSION) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcv);
				} elsif ($tagtyp == $TYP_CLOSE) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcc);
				} else {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_src5);
				}
			}
			if ($tagtyp == $TYP_OPEN) {
				push(@xmltags,$xmltag);
			} elsif ($tagtyp == $TYP_CLOSE) {
				if (@xmltags) {
					my $tmptag = pop @xmltags;
					$xmltag = substr($xmltag,1);
					if ($tmptag ne $xmltag) {
						prtw( "WARNING: Closing TAG [$xmltag] not last [$tmptag]! $bgnend\n" );
					}
					if ($xmltag eq 'Configurations') {
						$inconfigs = 0;
						prt( "Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
					}
				} else {
					prtw( "WARNING: CLOSE TAG NOT OPEN! [$fline]\n" );
				}
			}
			$fline = '';
		}
	}

	###prt( "Project: $projname, as $apptype\n" ); # eg 'Project: gshhs, as Console Application'
	my (@att2, @disc, @arr);
	foreach $conf (keys %v8_depend) {
		$ctype = 0;
		if ($conf =~ /^Debug\|/) {
			$ctype = 1;
			$func = \&is_in_skip_lib_dbg;
		} elsif ($conf =~ /^Release\|/) {
			$ctype = 2;
			$func = \&is_in_skip_lib_rel;
		} else {
			$func = \&is_in_skip_lib_rel;
		}
		$ppdefs = $v8_depend{$conf};
		@attribs = split(/ /,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}
		prt( "\nLINK:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" );
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" );
		if ($ctype == 1) {	# ($conf =~ /^Debug\|/)
			$def = $dsp_libs_dbg;
			@arr = split(/ /,$dsp_libs_dbg);
			@disc = ();
			prt( "Debug VERSION ... $conf ... [ @arr ]\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_dbg .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_dbg) ...\n");
			prt( "To      $dsp_libs_dbg, discarding [ @disc ], as already there ...\n" );
		} elsif ($ctype == 2) {	# $conf =~ /^Release\|/)
			$def = $dsp_libs_rel;
			@arr = split(/ /, $dsp_libs_rel );
			prt( "Release VERSION ... $conf ... @arr\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_rel .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_rel) ...\n" );
			prt( "To      $dsp_libs_rel, discarding [ @disc ], as already there ...\n" );
		} else {
			prt( "CHECKME: VERSION NOT DEBUG OR RELEASE??? ... $conf ...\n" );
		}
	}

	foreach $conf (keys %v8_link) {
		$ctype = 0;
		if ($conf =~ /^Debug\|/) {
			$ctype = 1;
			$func = \&is_in_skip_conf_dbg;
		} elsif ($conf =~ /^Release\|/) {
			$ctype = 2;
			$func = \&is_in_skip_conf_rel;
		} else {
			$func = \&is_in_skip_conf_rel;
		}
		$ppdefs = $v8_link{$conf};
		@attribs = split(/;/,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}
		@arr = ();
		prt( "\nDEFS:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" );
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" );
		if ($ctype == 1) {	# ($conf =~ /^Debug\|/)
			$def = $dsp_defines_dbg;
			@arr = split_conf( $dsp_defines_dbg );
			@disc = ();
			prt( "Debug VERSION ... $conf ... @arr\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_dbg .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_dbg) ...\n" );
			prt( "To      $dsp_defines_dbg, discarding [ @disc ], as already there ...\n" );
		} elsif ($ctype == 2) {	# $conf =~ /^Release\|/)
			$def = $dsp_defines_rel;
			@arr = split_conf( $dsp_defines_rel );
			prt( "Release VERSION ... $conf ... @arr\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_rel .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_rel) ...\n");
			prt( "To      $dsp_defines_rel, discarding [ @disc ], as already there ...\n" );
		} else {
			prt( "\nCHECKME: VERSION NOT DEBUG NOR RELEASE??? ... $conf ...\n\n" );
		}

	}

	my $new_srcs = scalar @v8_srcs;
	prt( "Project: $projname, as $apptype\n" ); # eg 'Project: gshhs, as Console Application'
	prt( "Got new $new_srcs C/C++ files, header files, and others \n" );
}

######################################################################
### other services

sub strip_quotes {
	my ($ln) = shift;
	if ($ln =~ /^".*"$/) {
		$ln = substr($ln,1,length($ln)-2);
	}
	return $ln;
}

sub prtw {
	my ($wmsg) = shift;
	prt($wmsg);
	push(@warnings,$wmsg);
}

sub show_warnings {
	if (@warnings) {
		prt( "WARNING: Got ".scalar @warnings." warnings messages ...\n" );
		foreach my $wm (@warnings) {
			prt($wm);
		}
	} else {
		prt( "No warning or error messages ...\n" );
	}
}

sub get_runtime_stg {
	my ($rtn) = shift;
	if ($rtn == 0) {
		return "/MT";
	} elsif ($rtn == 1) {
		return "/MTd";
	} elsif ($rtn == 2) {
		return "/MD";
	} elsif ($rtn == 3) {
		return "/MDd";
	}
	return "/MT";
}

sub fix_rel_path {
	my ($path) = shift;
	$path = path_u2d($path);	# ENSURE DOS PATH SEPARATOR (in relative.pl)
	my @a = split(/\\/, $path);
	my $npath = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				prtw( "WARNING: Got relative .. without previous!!! path=$path\n" );
			}
		} else {
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}

### utitlity subs
sub is_c_source {
	my $f = shift;
	if ( ($f =~ /\.c$/i) || ($f =~ /\.cpp$/i) || ($f =~ /\.cxx$/i) ) {
		return 1;
	}
	##if (!is_h_source($f)) {
	##	prt( "Item [$f] IS NOT C/C++ SOURCE!\n" );
	##}
	return 0;
}

sub is_h_special {
	my $f = shift;
	if (($f =~ /osg/i)||($f =~ /OpenThreads/i)||($f =~ /Producer/i)) {
		return 1;
	}
	return 0;
}

sub is_h_source {
	my $f = shift;
	if ( ($f =~ /\.h$/i) || ($f =~ /\.hpp$/i) || ($f =~ /\.hxx$/i) ) {
		return 1;
	}
	##if (!is_c_source($f)) {
	##	prt( "Item [$f] IS NOT C/C++ SOURCE!\n" );
	##}
	return 0;
}

###########################

sub is_in_array {
	my ($itm, @arr) = @_;
	my $max = scalar @arr;
	for (my $k = 0; $k < $max; $k++) {
		if ($arr[$k] eq $itm) {
			return 1;
		}
	}
	return 0;
}

sub is_in_array_nc {
	my ($itm, @arr) = @_;
	foreach my $val (@arr) {
		if ($val =~ /$itm/i) {
			return 1;
		}
	}
	return 0;
}

##################
sub set_all_debugs {
	$dbg_src1 = 1;
	$dbg_src10 = 1;
	$dbg_src11 = 1;
	$dbg_src12 = 1;
	$dbg_src13 = 1;
	$dbg_src12a = 1;
	$dbg_src14 = 1;
	$dbg_src15 = 1;
	$dbg_src16 = 1;
	$dbg_src2 = 1;
	$dbg_src3 = 1;
	$dbg_src4 = 1;
	$dbg_src5 = 1;
	$dbg_src6 = 1;
	$dbg_src7 = 1;
	$dbg_src8 = 1;
	$dbg_src9 = 1;
	$dbg_srcc = 1;
	$dbg_srcv = 1;
	$dbg11 = 1;
}

# eof - vcporj03.pl
