#!/Perl
# MODULE: XML07.PL
# USE: Get sources from MSVC8 *.VCPROJ file,
# and display those source

# use module
use XML::Simple;
use Data::Dumper;
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);

# create object
# $xml = new XML::Simple (ForceArray => 1);
$xml2 = new XML::Simple;
my $fl1 = 'Files';
my $fl2 = 'File';
my $fl3 = 'RelativePath';
my $fl4 = 'Filter';
my $cnt = 0;
my $in_proj = 'c:\FG\18\flightgear\projects\VC8\flightgear.vcproj';
#my $in_proj = 'F:\FG0910-4\flightgear\projects\VC8\flightgear.vcproj';
if (! -f $in_proj) {
	mydie( "ERROR: Can NOT locate [$in_proj] ...\n" );
}
# create XML document - this is how it LOOKS
$raw2 = <<EOF;
<?xml version="1.0" encoding="Windows-1252"?>
<VisualStudioProject
	ProjectType="Visual C++"
	Version="8,00"
	Name="FlightGear"
	ProjectGUID="{0E698D36-EA1C-434F-A524-21A673C19F2E}"
	Keyword="Win32Proj"
	>
	<Platforms>
		<Platform
			Name="Win32"
		/>
	</Platforms>
	<ToolFiles>
	</ToolFiles>
	<Configurations>
		<Configuration
			Name="Debug|Win32"
			OutputDirectory="Debug"
			IntermediateDirectory="Debug"
			ConfigurationType="1"
			>
			<Tool
				Name="VCPreBuildEventTool"
			/>
			<Tool
				Name="VCCustomBuildTool"
			/>
			<Tool
				Name="VCXMLDataGeneratorTool"
			/>
			<Tool
				Name="VCWebServiceProxyGeneratorTool"
			/>
			<Tool
				Name="VCMIDLTool"
			/>
			<Tool
				Name="VCCLCompilerTool"
				Optimization="0"
				AdditionalIncludeDirectories="../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim"
				PreprocessorDefinitions="WIN32;_DEBUG;_WINDOWS;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;NOMINMAX;FREEGLUT_STATIC"
				MinimalRebuild="true"
				BasicRuntimeChecks="3"
				RuntimeLibrary="1"
				UsePrecompiledHeader="0"
				WarningLevel="3"
				Detect64BitPortabilityProblems="false"
				DebugInformationFormat="4"
			/>
			<Tool
				Name="VCManagedResourceCompilerTool"
			/>
			<Tool
				Name="VCResourceCompilerTool"
			/>
			<Tool
				Name="VCPreLinkEventTool"
			/>
			<Tool
				Name="VCLinkerTool"
				AdditionalDependencies="FlightgearLib.lib Simgear.lib fnt_d.lib js_d.lib net_d.lib psl_d.lib puAux_d.lib pui_d.lib pw_d.lib sg_d.lib sl_d.lib ssg_d.lib ssgAux_d.lib ul_d.lib pthreadvc2.lib Alut.lib openal32.lib zlibd.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib"
				LinkIncremental="2"
				AdditionalLibraryDirectories="&quot;FG$(IntDir)&quot;;../../../plib/;&quot;../../../Simgear/Projects/VC8/$(IntDir)&quot;;&quot;../../../freeglut-2.4.0/$(IntDir)Static&quot;;&quot;../../../Pre-Built.2/lib&quot;;&quot;../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_$(IntDir)&quot;;../../../al/lib"
				GenerateDebugInformation="true"
				SubSystem="2"
				TargetMachine="1"
			/>
			<Tool
				Name="VCALinkTool"
			/>
			<Tool
				Name="VCManifestTool"
			/>
			<Tool
				Name="VCXDCMakeTool"
			/>
			<Tool
				Name="VCBscMakeTool"
			/>
			<Tool
				Name="VCFxCopTool"
			/>
			<Tool
				Name="VCAppVerifierTool"
			/>
			<Tool
				Name="VCWebDeploymentTool"
			/>
			<Tool
				Name="VCPostBuildEventTool"
			/>
		</Configuration>
		<Configuration
			Name="Release|Win32"
			OutputDirectory="Release"
			IntermediateDirectory="Release"
			ConfigurationType="1"
			>
			<Tool
				Name="VCPreBuildEventTool"
			/>
			<Tool
				Name="VCCustomBuildTool"
			/>
			<Tool
				Name="VCXMLDataGeneratorTool"
			/>
			<Tool
				Name="VCWebServiceProxyGeneratorTool"
			/>
			<Tool
				Name="VCMIDLTool"
			/>
			<Tool
				Name="VCCLCompilerTool"
				AdditionalIncludeDirectories="../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim"
				PreprocessorDefinitions="WIN32;NDEBUG;_CONSOLE;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;_USE_MATH_DEFINES;NOMINMAX;FREEGLUT_STATIC"
				StringPooling="true"
				RuntimeLibrary="0"
				UsePrecompiledHeader="0"
				WarningLevel="3"
				Detect64BitPortabilityProblems="false"
				DebugInformationFormat="3"
			/>
			<Tool
				Name="VCManagedResourceCompilerTool"
			/>
			<Tool
				Name="VCResourceCompilerTool"
			/>
			<Tool
				Name="VCPreLinkEventTool"
			/>
			<Tool
				Name="VCLinkerTool"
				AdditionalDependencies="FlightgearLib.lib Simgear.lib fnt.lib js.lib net.lib psl.lib puAux.lib pui.lib pw.lib sg.lib sl.lib ssg.lib ssgAux.lib ul.lib pthreadvc2.lib Alut.lib openal32.lib zlib.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib"
				LinkIncremental="2"
				AdditionalLibraryDirectories="&quot;FG$(IntDir)&quot;;../../../plib/;&quot;../../../Simgear/Projects/VC8/$(IntDir)&quot;;&quot;../../../freeglut-2.4.0/$(IntDir)Static&quot;;&quot;../../../Pre-Built.2/lib&quot;;&quot;../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_$(IntDir)&quot;;../../../al/lib"
				GenerateDebugInformation="true"
				SubSystem="2"
				OptimizeReferences="2"
				EnableCOMDATFolding="2"
				TargetMachine="1"
			/>
			<Tool
				Name="VCALinkTool"
			/>
			<Tool
				Name="VCManifestTool"
			/>
			<Tool
				Name="VCXDCMakeTool"
			/>
			<Tool
				Name="VCBscMakeTool"
			/>
			<Tool
				Name="VCFxCopTool"
			/>
			<Tool
				Name="VCAppVerifierTool"
			/>
			<Tool
				Name="VCWebDeploymentTool"
			/>
			<Tool
				Name="VCPostBuildEventTool"
			/>
		</Configuration>
	</Configurations>
	<References>
	</References>
	<Files>
		<Filter
			Name="Header Files"
			Filter="h;hpp;hxx;hm;inl;inc;xsd"
			UniqueIdentifier="{93995380-89BD-4b04-88EB-625FBE52EBFB}"
			>
			<File
				RelativePath="..\\..\\src\\main\\fg_commands.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_init.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_io.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_os.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_props.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\globals.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\logger.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\main.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\options.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\renderer.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\splash.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\util.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewer.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewmgr.hxx"
				>
			</File>
		</Filter>
		<Filter
			Name="Resource Files"
			Filter="rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe;resx"
			UniqueIdentifier="{67DA6AB6-F800-4c08-8B7A-83BB121AAD01}"
			>
		</Filter>
		<Filter
			Name="Source Files"
			Filter="cpp;c;cc;cxx;def;odl;idl;hpj;bat;asm;asmx"
			UniqueIdentifier="{4FC737F1-C7A5-4376-A066-2A32D752A2FF}"
			>
			<File
				RelativePath="..\\..\\src\\main\\bootstrap.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_commands.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_init.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_io.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_os.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_props.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\globals.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\logger.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\main.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\options.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\renderer.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\splash.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\util.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewer.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewmgr.cxx"
				>
			</File>
		</Filter>
	</Files>
	<Globals>
	</Globals>
</VisualStudioProject>
EOF

my @xmlkeys = ();
my @srcfls = ();
my @hdrfls = ();
# read XML file
#$data2 = $xml2->XMLin($raw2);
$data2 = $xml2->XMLin($in_proj);
# access XML data
prt( "Output of [$in_proj]...\nNOT using (ForceArray => 1) ...\n" );
#prt( Dumper($data2) );
$cnt = 0;
foreach my $key (keys %{$data2}) {
	$cnt++;
	##prt( "$cnt $key\n" );
	push(@xmlkeys, $key);
}
$cnt = 0;
##my $txt = Dumper($data2);
#prt( $txt );
##my @arr = split(/\n/,$txt);
##my $line;
##foreach $line (@arr) {
##	prt( "# $line\n" );
##}
## my @xkeys = keys %{$data2};
## prt( Dumper(@xkeys) );
## prt( Dumper(@xmlkeys) );
my $cnt1 = 0;
foreach my $k (@xmlkeys) {
	$cnt1++;
	###prt( "\n$cnt1 $k\n" );
	my $data = $data2->{$k};
	###prt( Dumper($data) );
	if ($k eq 'Version') {
		prt( "File Version = ".$data."\n" );
	} elsif ($k eq 'Files') {
		prt( "Enumerating Files ...\n" );
		my $cnt2 = 0;
		foreach my $k2 (keys %{$data}) {
			$cnt2++;
			my $data3 = $data->{$k2};
			##prt( "$cnt2 $k2 ...\n" );
			my $cnt3 = 0;
			my $hadsrc = 0;
			my $hadhdr = 0;
			foreach my $k3 (@{$data3}) {
				$cnt3++;
				###prt( "  $cnt3\n".Dumper($k3) );
				$hadsrc = 0;
				$hadhdr = 0;
				foreach my $k4 (keys %{$k3}) {
					###prt( "   $k4\n" );
					if ($k4 =~ /Name/i) {
						my $vnm = $k3->{$k4};
						###prt( "Name is [$vnm]\n" );
						if ($vnm =~ /^Source\s+Files/i) {
							$hadsrc = 1;
						} elsif ($vnm =~ /^Header\s+Files/i) {
							$hadhdr = 1;
						}
					}
				}
				if ($hadsrc || $hadhdr) {
					if ($hadsrc) {
						prt( "Found SOURCE FILES ...\n" );
					} else {
						prt( "Found HEADER FILES ...\n" );
					}
					my $sh = $k3->{'File'};
					###prt( Dumper($sh) );
					foreach my $k5 (@{$sh}) {
						###prt( "$k5\n" );
						foreach my $k6 (keys %{$k5}) {
							my $src = $k5->{$k6};
							prt( "$k6=$src\n" );
							if ($hadsrc) {
								push(@srcfls, $src);
							} else {
								push(@hdrfls, $src);
							}
						}
					}
				}
			}
		}
	}
}

close_log($outfile,1);

# list of keys found
#1 Configurations
#2 ToolFiles
#3 Globals
#4 ProjectType
#5 Version
#6 References
#7 ProjectGUID
#8 Keyword
#9 Name
#10 Files
#11 Platforms
# the DUMPER data ...
# $VAR1 = {
#           'Configurations' => {
#                                 'Configuration' => [
#                                                      {
#                                                        'ConfigurationType' => '1',
#                                                        'Tool' => [
#                                                                    {
#                                                                      'Name' => 'VCPreBuildEventTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCCustomBuildTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCXMLDataGeneratorTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCWebServiceProxyGeneratorTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCMIDLTool'
#                                                                    },
#                                                                    {
#                                                                      'UsePrecompiledHeader' => '0',
#                                                                      'Optimization' => '0',
#                                                                      'Detect64BitPortabilityProblems' => 'false',
#                                                                      'PreprocessorDefinitions' => 'WIN32;_DEBUG;_WINDOWS;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;NOMINMAX;FREEGLUT_STATIC',
#                                                                      'AdditionalIncludeDirectories' => '../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim',
#                                                                      'MinimalRebuild' => 'true',
#                                                                      'WarningLevel' => '3',
#                                                                      'BasicRuntimeChecks' => '3',
#                                                                      'Name' => 'VCCLCompilerTool',
#                                                                      'DebugInformationFormat' => '4',
#                                                                      'RuntimeLibrary' => '1'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCManagedResourceCompilerTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCResourceCompilerTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCPreLinkEventTool'
#                                                                    },
#                                                                    {
#                                                                      'LinkIncremental' => '2',
#                                                                      'SubSystem' => '2',
#                                                                      'GenerateDebugInformation' => 'true',
#                                                                      'AdditionalDependencies' => 'FlightgearLib.lib Simgear.lib fnt_d.lib js_d.lib net_d.lib psl_d.lib puAux_d.lib pui_d.lib pw_d.lib sg_d.lib sl_d.lib ssg_d.lib ssgAux_d.lib ul_d.lib pthreadvc2.lib Alut.lib openal32.lib zlibd.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib',
#                                                                      'Name' => 'VCLinkerTool',
#                                                                      'AdditionalLibraryDirectories' => '"FG0IntDir)";../../../plib/;"../../../Simgear/Projects/VC8/0IntDir)";"../../../freeglut-2.4.0/0IntDir)Static";"../../../Pre-Built.2/lib";"../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_0IntDir)";../../../al/lib',
#                                                                      'TargetMachine' => '1'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCALinkTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCManifestTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCXDCMakeTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCBscMakeTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCFxCopTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCAppVerifierTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCWebDeploymentTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCPostBuildEventTool'
#                                                                    }
#                                                                  ],
#                                                        'OutputDirectory' => 'Debug',
#                                                        'Name' => 'Debug|Win32',
#                                                        'IntermediateDirectory' => 'Debug'
#                                                      },
#                                                      {
#                                                        'ConfigurationType' => '1',
#                                                        'Tool' => [
#                                                                    {
#                                                                      'Name' => 'VCPreBuildEventTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCCustomBuildTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCXMLDataGeneratorTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCWebServiceProxyGeneratorTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCMIDLTool'
#                                                                    },
#                                                                    {
#                                                                      'UsePrecompiledHeader' => '0',
#                                                                      'Detect64BitPortabilityProblems' => 'false',
#                                                                      'PreprocessorDefinitions' => 'WIN32;NDEBUG;_CONSOLE;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;_USE_MATH_DEFINES;NOMINMAX;FREEGLUT_STATIC',
#                                                                      'AdditionalIncludeDirectories' => '../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim',
#                                                                      'WarningLevel' => '3',
#                                                                      'DebugInformationFormat' => '3',
#                                                                      'RuntimeLibrary' => '0',
#                                                                      'Name' => 'VCCLCompilerTool',
#                                                                      'StringPooling' => 'true'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCManagedResourceCompilerTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCResourceCompilerTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCPreLinkEventTool'
#                                                                    },
#                                                                    {
#                                                                      'LinkIncremental' => '2',
#                                                                      'GenerateDebugInformation' => 'true',
#                                                                      'AdditionalDependencies' => 'FlightgearLib.lib Simgear.lib fnt.lib js.lib net.lib psl.lib puAux.lib pui.lib pw.lib sg.lib sl.lib ssg.lib ssgAux.lib ul.lib pthreadvc2.lib Alut.lib openal32.lib zlib.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib',
#                                                                      'EnableCOMDATFolding' => '2',
#                                                                      'OptimizeReferences' => '2',
#                                                                      'TargetMachine' => '1',
#                                                                      'SubSystem' => '2',
#                                                                      'Name' => 'VCLinkerTool',
#                                                                      'AdditionalLibraryDirectories' => '"FG0IntDir)";../../../plib/;"../../../Simgear/Projects/VC8/0IntDir)";"../../../freeglut-2.4.0/0IntDir)Static";"../../../Pre-Built.2/lib";"../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_0IntDir)";../../../al/lib'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCALinkTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCManifestTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCXDCMakeTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCBscMakeTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCFxCopTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCAppVerifierTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCWebDeploymentTool'
#                                                                    },
#                                                                    {
#                                                                      'Name' => 'VCPostBuildEventTool'
#                                                                    }
#                                                                  ],
#                                                        'OutputDirectory' => 'Release',
#                                                        'Name' => 'Release|Win32',
#                                                        'IntermediateDirectory' => 'Release'
#                                                      }
#                                                    ]
#                               },
#           'ToolFiles' => {},
#           'Globals' => {},
#           'ProjectType' => 'Visual C++',
#           'Version' => '8,00',
#           'References' => {},
#           'ProjectGUID' => '{0E698D36-EA1C-434F-A524-21A673C19F2E}',
#           'Keyword' => 'Win32Proj',
#           'Name' => 'FlightGear',
#           'Files' => {
#                        'Filter' => [
#                                      {
#                                        'Filter' => 'h;hpp;hxx;hm;inl;inc;xsd',
#                                        'UniqueIdentifier' => '{93995380-89BD-4b04-88EB-625FBE52EBFB}',
#                                        'File' => [
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_commands.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_init.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_io.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_os.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_props.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\globals.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\logger.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\main.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\options.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\renderer.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\splash.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\util.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\viewer.hxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\viewmgr.hxx'
#                                                    }
#                                                  ],
#                                        'Name' => 'Header Files'
#                                      },
#                                      {
#                                        'Filter' => 'rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe;resx',
#                                        'UniqueIdentifier' => '{67DA6AB6-F800-4c08-8B7A-83BB121AAD01}',
#                                        'Name' => 'Resource Files'
#                                      },
#                                      {
#                                        'Filter' => 'cpp;c;cc;cxx;def;odl;idl;hpj;bat;asm;asmx',
#                                        'UniqueIdentifier' => '{4FC737F1-C7A5-4376-A066-2A32D752A2FF}',
#                                        'File' => [
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\bootstrap.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_commands.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_init.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_io.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_os.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\fg_props.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\globals.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\logger.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\main.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\options.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\renderer.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\splash.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\util.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\viewer.cxx'
#                                                    },
#                                                    {
#                                                      'RelativePath' => '..\\..\\src\\main\\viewmgr.cxx'
#                                                    }
#                                                  ],
#                                        'Name' => 'Source Files'
#                                      }
#                                    ]
#                      },
#           'Platforms' => {
#                            'Platform' => {
#                                            'Name' => 'Win32'
#                                          }
#                          }
#         };
