#!/perl -w
# NAME: xmlfgair.pl
# AIM: Read FG AirCraft -set.xml file, and show details...
# 16/04/2013 - Further improvments, more outputs from XML
# 19/02/2013 - Add help and imporve UI and output
# 06/02/2013 - Add 'author' and 'rating'
# 13/01/2010 - Initial cut
use strict;
use warnings;
# References
# http://www.perl.com/lpt/a/3 # http://www.xml.com/pub/a/98/09/xml-perl.html
# use XML::Parser
# Install
# shell> perl -MCPAN -e shell
# cpan> install XML::Simple
#   require XML::Parser::Expat;
#  $VERSION = '2.36';
#  die "Parser.pm and Expat.pm versions don't match"
#    unless $VERSION eq $XML::Parser::Expat::VERSION;
# http://sourceforge.net/projects/expat/
# References
# http://search.cpan.org/dist/XML-Simple/lib/XML/Simple.pm
use XML::Simple;
use File::Basename;     # to split path into ($name, $dir) = fileparse($ff); or ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
use Data::Dumper;
use File::Spec; # File::Spec->rel2abs($rel);
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# features
my $VERS = "0.0.4 2013-04-16";
#my $VERS = "0.0.3 2013-02-19";
my $load_log = 0;
my $out_file = '';
my $out_text = '';
my $load_include_files = 1;

my @in_files = ();
my @in_dirs = ();
my %exclude_files = ();
my $temp_file_list = $temp_dir.$PATH_SEP.'temp_list.txt';
my $temp_xclude_list = $temp_dir.$PATH_SEP.'temp_xclude.txt';
my $verbosity = 0;

my @aero_list = ();

# debug
my $dbg_01 = 0; # prt("[dbg_01] Processing directory [$dir]...\n") if ($dbg_01);
my $debug_on = 0;
my $def_file = 'C:\FG\fgdata\Aircraft\Boeing314\Boeing314-set.xml';
#my $def_file = 'C:\FG\27\data\Aircraft\A380\A380-set.xml';
#my $def_file = 'C:\FG\fgdata\Aircraft\c172p\c172p-set.xml';
#my $def_file = 'C:\FG\fgdata\Aircraft\ZLT-NT\ZLT-NT-copilot-set.xml';
my $def_dir = 'C:\FG\fgdata\Aircraft';

### program variables
my @warnings = ();
my $cwd = cwd();

# forward references
sub process_dir($);


sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
   my ($val,$msg) = @_;
   show_warnings($val);
   if (length($msg)) {
      $msg .= "\n" if (!($msg =~ /\n$/));
      prt($msg);
   }
   close_log($outfile,$load_log);
   exit($val);
}

sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub is_in_excluded($) {
   my ($fil) = shift;
   foreach my $test (keys %exclude_files) {
      if ($fil eq $test) {
         return 1;
      }
   }
   return 0;
}

sub get_parent_dir($) {
    my $path = shift;
    my $test = path_d2u($path);
    my ($n,$d) = fileparse($test);
    if ($d =~ /^\.(\\|\/)$/) {
        return $path;
    }
    my @arr = split("/",$d);
    my $len = scalar @arr;
    if ($len == 1) {
        return $d;
    }
    #prt("Split [$d] len $len\n");
    #foreach $d (@arr) {
    #    prt("[$d]\n");
    #}
    return $arr[-1];
}

sub is_decimal($) {
    my $num = shift;
    return 1 if ($num =~ /^[-+]?[0-9]*\.?[0-9]+$/);
    return 0;
}

my %ref_hash_keys = ();

sub get_fg_xml_data($$$); # my ($fil,$rha,$frh) = @_;
sub process_file($$);

#####################################################################
### Loaded using XML::Simple
### Do NOT create an entry if a value is NOT found
#####################################################################
sub get_fg_xml_data($$$) {
    my ($fil,$rha,$frh) = @_;
    my ($msg,$v,$rh,$tmp,$rating,$item);
    my ($key,$val,$hkey,$sim,$isok,$cnt,$i);
    my ($hpath);
    ###my %file_hash = ();
    ###my $frh = \%file_hash;
    my @hkeys = qw( aero status flight-model description aircraft-version author rating );
    my $hkcnt = scalar @hkeys;
    my ($fname,$fdir) = fileparse($fil);
    my $par = get_parent_dir($fil);
    ##$tmp = Dumper($rha);
    ##prt("$tmp\n");
    $tmp = ref($rha);
    prt("FG Information: for [$fil]... [$par]\n") if (VERB1());
    if (( $tmp ne "REF")&&($tmp ne "HASH")) {
       prt("NOT a HASH reference! Got [$tmp]\n");
       $msg = Dumper($rha);
       prt("$msg\n");
       prt("NOT a HASH REFERENCE! Got [$tmp]\n");
       return $frh;
    }
    # get the <sim> tag
    $hpath = '';
    if (defined $rha->{'sim'}) {
        $hpath = "{'sim'}";
        $sim = $rha->{'sim'};    # get the 'sim' reference
        $tmp = ref($sim);
        $isok = 1;
        if ($tmp ne "HASH") {
           if ($tmp eq "ARRAY") {
               $isok = 0;
               $v = scalar @{$sim};
               $hkey = '';
               $msg = '';
               foreach $item (@{$sim}) {
                   $val = ref($item);
                   if ($val eq "HASH") {
                       $cnt = 0;
                       foreach $key (@hkeys) {
                           $cnt++ if (defined $item->{$key});
                       }
                       if ($cnt > 3) {
                           $sim = $item;
                           $isok = 1;
                           last;
                       }
                   }
                   $hkey .= ' ' if (length($hkey));
                   $hkey .= ref($item);
                   $msg .= Dumper($item);
                   $msg .= "\n==========================================================\n";
               }
               if ($isok == 0) {
                   prt("Can NOT process [$tmp] content with [$v] elements... $hkey\n");
                   prt("$msg\n");
               }
           } else {
               prt("Can NOT process [$tmp] content...\n");
               $msg = Dumper($sim);
               prt("$msg\n");
               prt("Can NOT process [$tmp] content...\n");
           }
           if ($isok == 0) {
               return $frh;
           }
       }

      # =======================================================
      $msg = "Aero        :";
      $hkey = 'aero';
      $key = 'aircraft';
      $ref_hash_keys{$key} = 1;
      $val = '';    # nothing
      if (defined $sim->{$hkey}) {
         $v = $sim->{$hkey};
         if (ref($v) eq "HASH") {
            foreach $key (keys %{$v}) {
                if ($key eq 'content') {
                    $val = ${$v}{$key};
                    $msg .= " $val";
                }
            }
            prt("$msg\n") if (VERB9());
         } else {
             prt("$msg $v\n" ) if (VERB9());
             $val = $v;
         }
      } else {
          # No 'aero'
          $v = "$par".'?';
          prt("$msg $v\n") if (VERB5());
          $val = $v;
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================
      $msg = "Status      :";
      $hkey = 'status';
      $key = 'status';
      $ref_hash_keys{$key} = 1;
      $val = '';    # nothing
      if (defined $sim->{$hkey}) {
         $v = $sim->{$hkey};
         if (ref($v) eq "HASH") {
            foreach $key (keys %{$v}) {
                if ($key eq 'content') {
                    $val = ${$v}{$key};
                    $msg .= " $val";
                }
            }
            prt("$msg\n") if (VERB9());
         } else {
             prt("$msg $v\n" ) if (VERB9());
             $val = $v;
         }
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================

      $msg = "Flight Model:";
      $hkey = 'flight-model';
      $key = 'flight-model';
      $val = '';
      $ref_hash_keys{$key} = 1;
      if (defined $sim->{$hkey}) {
         $v = $sim->{$hkey};
         if (ref($v) eq "HASH") {
            foreach $key (keys %{$v}) {
                if ($key eq 'content') {
                    $val = ${$v}{$key};
                    $msg .= " $val";
                }
            }
            prt("$msg\n") if (VERB9());
         } else {
             prt("$msg $v\n" ) if (VERB9());
             $val = $v;
         }
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================

      $msg = "Description :";
      $hkey = 'description';
      $key = 'description';
      $val = '';
      $ref_hash_keys{$key} = 1;
      if (defined $sim->{$hkey}) {
         $v = $sim->{$hkey};
         if (ref($v) eq "HASH") {
            foreach $key (keys %{$v}) {
                if ($key eq 'content') {
                    $val = ${$v}{$key};
                    $msg .= " $val";
                    last;
                }
            }
            prt("$msg\n") if (VERB9());
         } else {
             prt("$msg $v\n" ) if (VERB9());
             $val = $v;
         }
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================

      $msg = "Version     :";
      $hkey = 'aircraft-version';
      $key = $hkey;
      $val = '';
      $ref_hash_keys{$key} = 1;
      if (defined $sim->{$hkey}) {
         $v = $sim->{$hkey};
         if (ref($v) eq "HASH") {
            foreach $key (keys %{$v}) {
                if ($key eq 'content') {
                    $val = ${$v}{$key};
                    $msg .= " $val";
                    last;
                }
            }
            prt("$msg\n") if (VERB9());
         } else {
             prt("$msg $v\n" ) if (VERB9());
             $val = $v;
         }
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================

      $msg = "Author      :";
      $hkey = 'author';
      $key = $hkey;
      $val = '';
      $ref_hash_keys{$key} = 1;
      if (defined $sim->{$hkey}) {
         $v = $sim->{$hkey};
         if (ref($v) eq "HASH") {
            foreach $key (keys %{$v}) {
                if ($key eq 'content') {
                    $val = ${$v}{$key};
                    $msg .= " $val";
                    last;
                }
            }
            prt("$msg\n") if (VERB9());
         } else {
             prt("$msg $v\n" ) if (VERB9());
             $val = $v;
         }
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================

      $msg = "Rating      :";
      $rating = '';
      $hkey = 'rating';
      $key = 'rating';
      $val = '';
      $ref_hash_keys{$key} = 1;
      if (defined $sim->{$hkey}) {
         $rh = $sim->{$hkey};
         ##prt("$msg $v\n" );
         $item = "FDM";
         if (defined ${$rh}{$item}->{'content'}) {
             $v = trim_all(${$rh}{$item}->{'content'});
             #$tmp = Dumper($v);
             #$msg .= " FDM=$v";
             #$msg .= " FDM=$tmp";
         } else {
             $v = 'nf';
             #$msg .= " FDM=nf";
         }
         $rating .= "$item=$v";
         $item = "systems";
         if (defined ${$rh}{$item}->{'content'}) {
             $v = trim_all(${$rh}{$item}->{'content'});
         } else {
             $v = 'nf';
         }
         $rating .= " $item=$v";
         $item = "cockpit";
         if (defined ${$rh}{$item}->{'content'}) {
             $v = trim_all(${$rh}{$item}->{'content'});
         } else {
             $v = 'nf';
         }
         $rating .= " $item=$v";
         $item = "model";
         if (defined ${$rh}{$item}->{'content'}) {
             $v = trim_all(${$rh}{$item}->{'content'});
         } else {
             $v = 'nf';
         }
         $rating .= " $item=$v";
         prt("$msg $rating\n") if (VERB9());
         $val = $rating;
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================
      $msg = "Model       :";
      my $model = '';
      $hkey = 'model';
      $key = 'model-path';
      $val = '';
      $ref_hash_keys{$key} = 1;
      if (defined $sim->{$hkey}) {
         $rh = $sim->{$hkey};
         if (ref($rh) eq "HASH") {
            $hkey = 'path';
            if (defined ${$rh}{$hkey}) {
                $tmp = ${$rh}{$hkey};
                if (ref($tmp) eq 'HASH') {
                    if (defined ${$tmp}{'content'}) {
                        $v = ${$tmp}{'content'};
                        $v = path_u2d($v) if ($os =~ /win/i);
                        prt("$msg $v\n") if (VERB9());
                        $val = $v;
                    } else {
                        $v = Dumper($tmp);
                         prt("$msg $v\n");
                    }
                } else {
                    $tmp = path_u2d($tmp) if ($os =~ /win/i);
                    prt("$msg $tmp\n") if (VERB9());
                    $val = $tmp;
                }
            } else {
                prt("$msg {model}{path} not found\n") if (VERB5());
            }
         } else {
             $tmp = Dumper($rh);
             prt("$msg $tmp\n");
         }
      } else {
         prt("$msg <not found>\n") if (VERB5());
      }
      ${$frh}{$key} = $val if (length($val));
      # =======================================================
   } else {
      prt("Error: Can not locate 'sim' entry. Maybe NOT an aircraft set file!\n");
   }
    # ===================================
    # check refuel
    #  <systems>
    #  <refuel>
    #  <serviceable type="bool">true</serviceable>
    #  <type>probe</type>
    #  </refuel>
    # </systems>
    $msg = "Refuel      :";
    $key = 'refuel-type';
    $val = '';
    $hkey = 'systems';
    $ref_hash_keys{$key} = 1;
    if (defined $rha->{$hkey}) {
     $rh = $rha->{$hkey};
     if (ref($rh) eq "HASH") {
        $hkey = 'refuel';
        if (defined $rh->{$hkey}) {
            $tmp = $rh->{$hkey};
            if (ref($tmp) eq "HASH") {
                $hkey = 'type';
                if (defined $tmp->{$hkey}) {
                    $v = $tmp->{$hkey};
                    if (ref($v) eq 'HASH') {
                        if (defined $v->{'content'}) {
                            $val = $v->{'content'};
                        } else {
                            prt("$msg FAILED1\n");
                            prt(Dumper($v));
                        }
                    } else {
                        $val = $v;
                    }
                }
            }
        } else {
            if (VERB9()) {
                prt("$msg {systems}{$hkey} not found\n");
                prt(Dumper($rh));
            }
        }
     } else {
         $tmp = Dumper($rh);
         prt("$msg rh NOT HASH! $tmp\n");
     }
    } else {
         prt("$msg <not found 'systems'>\n") if (VERB5());
    }
    ${$frh}{$key} = $val if (length($val));
    # =======================================================

    # ===================================
    $item = 'include';
    $msg = "Include     :";
    $key = 'include';
    $val = '';
    if (defined $rha->{$item}) {
        $v = $rha->{$item};
        ###$hash{'include'} = $v;
        $val = trim_all($v);
    } else {
        $v = "<none found>";
    }
    prt("$msg $v\n") if (VERB9());
    if (length($val)) {
        if (defined ${$frh}{$key}) {
            ${$frh}{$key} .= ";$val";
        } else {
            ${$frh}{$key} = $val;
        }
        if ($load_include_files) {
            my ($ff);
            # wow, see if can FIND the 'include' file
            # sometimes it is 'relative', so use
            # my ($fname,$fdir) = fileparse($fil);
            prt("Loading INCLUDE file [$val]\n");
            $ff = $fdir.$val;
            if (-f $ff) {
                # Ok, go with this
                # sub get_fg_xml_data($$$) {
                # my ($fil,$rha,$frh) = @_;
                process_file($ff,$frh);
            } else {
                # my $par = get_parent_dir($fil);
                prtw("WARNING: Unable to load [$val] [$ff] from [$fil]\n");
            }

        }
    }

    return $frh;
}

sub process_file($$) {
   my ($fil,$rh) = @_;
   if (! -f $fil) {
      prt("ERROR: Can NOT locate file [$fil]!\n");
      return $rh;
   }
   my ($nm,$dir) = fileparse($fil);
   if (is_in_excluded($nm) ) {
      prt("Excluding file [$fil]...\n") if (VERB2());
   } else {
      prt("Loading file [$fil]...\n") if (VERB2());
      my $xml = new XML::Simple; # (ForceArray => 0);
      my $data = $xml->XMLin($fil);
      $rh = get_fg_xml_data($fil,$data,$rh);
   }
   return $rh;
}

sub process_files($$$) {
   my ($rfa,$tfl,$txl) = @_;
   my ($file,$msg,$cnt,$rh);
   my %hash = ();
   if (length($tfl)) {
      $msg = '';
      $cnt =0;
      foreach $file (@{$rfa}) {
         $msg .= "$file\n";
         $cnt++;
      }
      write2file($msg,$tfl);
      prt("File list $cnt, written to $tfl...\n") if (VERB9());
   }

   if (length($txl)) {
      $msg = '';
      $cnt =0;
      foreach $file (keys %exclude_files) {
         $msg .= "$file\n";
         $cnt++;
      }
      write2file($msg,$txl);
      prt("File list $cnt, written to $txl...\n") if (VERB9());
   }

   foreach $file (@{$rfa}) {
       my %h = ();
       $rh = \%h;
       $rh = process_file($file,$rh);
       $hash{$file} = $rh;
   }
   return \%hash;
}

sub process_dir($) {
   my ($dir) = shift;
   my @dirs = ();
   prt("[dbg_01] Processing directory [$dir]...\n") if ($dbg_01);
   if (opendir(DIR,$dir)) {
      my @fils = readdir(DIR);
      closedir(DIR);
      ut_fix_directory(\$dir);
      foreach my $fil (@fils) {
         next if (($fil eq '.')||($fil eq '..'));
         my $ff = $dir.$fil;
         if (-d $ff) {
            push(@dirs,$ff);
         } elsif ($fil =~ /-set\.xml$/) {
            push(@in_files,$ff);
         }
      }
      foreach my $d (@dirs) {
         process_dir($d);
      }
   } else {
      prt("WARNING: Unable to open directory [$dir]\n");
   }
}

sub process_dirs($) {
   my ($rda) = shift;
   my ($dir);
   my $cnt = scalar @in_files;
   foreach $dir (@{$rda}) {
      process_dir($dir);
   }
   my $ncnt = scalar @in_files;
   if ($ncnt > $cnt) {
      prt("Directory processing added ".($ncnt - $cnt)." files...\n") if (VERB5());
   }
}

#################################################################
### Show the results of the SCAN
sub show_ref_hash($) {
   my ($rh) = shift;
   my ($fil,$key,$msg,$val,$cnt,$rh2,$min,$len);
   $cnt = 0;
   my @arr = sort keys %{$rh};
   $min = 0;
   foreach $key (keys %ref_hash_keys) {
       $ref_hash_keys{$key} = 0; # clear keys
   }
   foreach $fil (@arr) { # (keys %{$rh}) {
        $rh2 = $rh->{$fil};
        foreach $key (keys %{$rh2}) {
            $len = length($key);
            $min = $len if ($len > $min);
        }
   }
   $min += 2;
   ###foreach $fil (keys %{$rh}) {
   foreach $fil (@arr) {
      $rh2 = $rh->{$fil};
      #$rh2 = ${$rh}{$fil};
      $cnt++;
      $msg = "";
      my @arr2 = sort keys(%{$rh2});
      ###foreach $key (keys %{$rh2}) {
      foreach $key (@arr2) {
         $val = trim_all(${$rh2}{$key});
         $ref_hash_keys{$key} = 1; # SET key
         if ($key eq 'aero') {
             push(@aero_list,$val);
         }
         $msg .= ",\n" if length($msg);
         $key = '"'.$key.'"';
         $key .= ' ' while (length($key) < $min);
         if (is_decimal($val)) {
             $msg .= " $key : $val";
         } else {
             $msg .= " $key : \"$val\"";
         }
      }
       $val = '';
       foreach $key (keys %ref_hash_keys) {
           if ($ref_hash_keys{$key} == 0) { # not found
               $val .= ';' if (length($val));
               $val .= $key;
           }
       }
       if (length($val)) {
           $key = '"NOT_FOUND"';
           $key .= ' ' while (length($key) < $min);
           $msg .= ",\n" if length($msg);
           $msg .= " $key : \"$val\"";
       }

      $msg = "\n{\"number\":$cnt, \"set_file\": \"$fil\",\n$msg}";
      $out_text .= "$msg\n";
   }
}

sub write_outputs() {
    if (length($out_file) && length($out_text)) {
        my ($aero,$tmp);
        my %h = ();
        foreach $aero (@aero_list) {
            next if (defined $h{$aero});
            $h{$aero} = 1;
        }
        my @arr = sort keys(%h);
        $aero = scalar @arr;
        $out_text .= "\nAlphabetic aero list... $aero aircraft...\n";
        $out_text .= join("\n",@arr)."\n";
        write2file($out_text,$out_file);
        prt("Contents written to $out_file\n");
    } elsif (length($out_text)) {
         prt("No out file (-o file) given...\n") if (VERB2());
         prt("$out_text\n");
    }
}

# #####################################
# ### MAIN ###
parse_args(@ARGV);
process_dirs(\@in_dirs);   # process directory input...
my $ref_hash = process_files(\@in_files,$temp_file_list,$temp_xclude_list);
show_ref_hash($ref_hash);
write_outputs();
pgm_exit(0,"");
# #####################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
   my (@av) = @_;
   my ($arg,$cnt,@arr,$tmp);
   $cnt = scalar @av;
   #prt("Processing $cnt arguments...\n");
   while (@av) {
      my $arg = $av[0];
      if ($arg =~ /^-/) {
         my $sarg = substr($arg,1);
         $sarg = substr($sarg,1) while ($sarg =~ /^-/);
         if (($sarg =~ /^\?/)||($sarg =~ /^h/)) {
             give_help();
             pgm_exit(0,"");
         }

         if ($sarg =~ /^l/i) {
            if ($sarg =~ /^ll/) {
                $load_log = 2;
            } else {
                $load_log = 1;
            }
            prt("Set load log at end. $load_log\n") if (VERB1());
         } elsif ($sarg =~ /^v/) {
            if ($sarg =~ /^v.*(\d+)$/) {
                $verbosity = $1;
            } else {
                while ($sarg =~ /^v/) {
                    $verbosity++;
                    $sarg = substr($sarg,1);
                }
            }
            prt("Verbosity = $verbosity\n") if (VERB1());
         } elsif ($sarg =~ /^x:(.+)$/) {
            $sarg = $1;
            @arr = split(":",$sarg);
            foreach $tmp (@arr) {
               if ( defined $exclude_files{$tmp} ) {
                  prt("File $tmp already excluded!\n") if (VERB1());
               } else {
                  $exclude_files{$tmp} = 1;
                  prt("Added file [$tmp] to excluded.\n") if (VERB1());
               }
            }
         } elsif ($sarg =~ /^o/) {
             need_arg(@av);
             shift @av;
             $sarg = $av[0];
             $out_file = $sarg;
             prt("Set output file to [$out_file]\n") if (VERB1());
         } else {
             # options???
             pgm_exit(1,"ERROR: Unknown arg [$arg] Try -? for list.\n");
         }
      } else {
          $tmp = File::Spec->rel2abs($arg);   # get ABSOLUTE path of input
         if (-d $tmp) {
            push(@in_dirs,$tmp);
            prt("Added input directory [$tmp]...\n") if (VERB1());
         } elsif (-f $tmp) {
            push(@in_files,$tmp);
            prt("Added input file [$tmp]...\n") if (VERB1());
         } else {
            pgm_exit(1,"ERROR: [$arg] NOT directory or file! Aborting.");
         }
      }
      shift @av;
   }
   if ($debug_on) {
       prtw("WARNING: DEBUG is ON!\n");
       if ( !@in_files && !@in_dirs ) {
           push(@in_files,$def_file);
           prt("Added DEFAULT input file [$def_file]...\n");
           #push(@in_dirs,$def_dir);
           #prt("Added DEFAULT input directory [$def_dir]...\n");
       }
       ###$load_log = 1;
   }
   if ( !@in_files && !@in_dirs ) {
      pgm_exit(1,"Error: No input file to process! Aborting.\n");
   }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file [in-dir [...]]\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt("If given a directory, or directories, process ALL *-set.xml files found\n");
    prt("in a resursive directory search. And if given a file, or files, process each\n");
    prt("showing the model, author, rating etc, found in that *-set.xml file.\n");

}

# eof - xmlfgair.pl
