#!/perl -w
# NAME: xmlfix01.pl
# AIM: Read an XML file, and add a title from the split of the file name
# 
use strict;
use warnings;
use XML::Simple;
use Data::Dumper;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
###my $in_file = 'C:\Documents and Settings\Geoff McLane\My Documents\Louis\banan\myP2\BananAlbum.xml';
my $in_file = 'Banan.xml';
my $out_file = 'tempxml.xml';
###my $xml = new XML::Simple;
my $xml = XML::Simple->new(ForceArray => 1);
###my $xml = XML::Simple->new();
my @xmlkeys = ();
my $cnt = 0;
prt( "Loading [$in_file] ...\n" );
my $data = $xml->XMLin($in_file);
# access XML data
#prt( Dumper($data) );
my $data2 = $data->{'slide'};
#prt( Dumper($data2) );
foreach my $dat (@{$data2}) {
	$cnt++;
	my $sfn = '';
	my $fil = '';
	my $lab = '';
	my $file = '';
	my ($key);
	##prt( Dumper($dat) );
	my $img = $dat->{'image'};	#->{'content'};
	prt( Dumper($img) );
	foreach $key (@{$img}) {
		prt( "Key = ".Dumper($key) ); # \n" ); # .${%{$img}}{$key}."\n" );
		$file = $key->{'content'};
		prt( "The file [$file]\n" );
	}
	my $file2 = ${@{$img}}[0];
	prt( "The file name [$file2]\n" );
	prt( Dumper($file2) );

#	my $file = ${@{$img}}{'content'};
#	my $file = $img->{'content'};
#	prt( Dumper($file) );
#	my $fil = $file->{'content'};
#	prt( "$fil\n" );
	$fil = substr($file,7);
#	my $fil = substr($file,7);
#	$fil = substr($file,7);
	my $ch = substr($fil,0,1);
	while (($ch =~ /\d/)||($ch eq '_')) {
		$fil = substr($fil,1);	# eat numbers and under score
		$ch = substr($fil,0,1);
	}
	$sfn = split_file_name($fil);
	$dat->{'label'} = $sfn;
	$lab = $dat->{'label'};
	prt( Dumper($lab) );
	prt( "$cnt [$fil] [$sfn] [$lab]\n" );
#	my $labs = join('', @{$lab});
#	prt( "$cnt [$fil] [$sfn] [$labs]\n" );
	prt( "\n" );
}

#my %nhash = makeNewHash($data);
#prt( Dumper( %nhash ) );

my $xml2 = XML::Simple->new();
##my $xmlstg = $xml2->XMLout( $xml, RootName => 'BananAlbum version="v5.1.2" generator=""' );
##my $xmlstg = $xml2->XMLout( \%{$data}, RootName => 'BananAlbum' );
my $xmlstg = $xml2->XMLout( \%{$data}, RootName => 'BananAlbum', ForceArray => 1 );
write2file($xmlstg,$out_file);

close_log($outfile,1);
exit(0);

################################
#### subs
sub split_file_name {
	my ($fil) = shift;
	my $len = length($fil);
	my $sfn = '';
	my $pch = '';
	my $inn = 0;
	for (my $i = 0; $i < $len; $i++) {
		my $ch = substr($fil,$i,1);
		if ($ch eq '.') {
			last;
		}
		my $val = ord($ch);
		if ( !$inn ) {
			if ($ch =~ /\d/) {
				$sfn .= '|' if (length($sfn));
				$inn = 1;
			} elsif (($val >= 65) && ($val <= 90)) {
				$sfn .= '|' if (length($sfn));
			}
		}
		$sfn .= $ch;
		$pch = $ch;
	}
	if ($sfn =~ /^F\|\S/) {
		$sfn = 'FS'.substr($sfn,3);
	}
	$sfn =~ s/\|/ /g;
	return $sfn;
}

sub makeNewHash {
    my $hashRef = shift;
    my %oldHash = %$hashRef;
    my %newHash = ();
    while ( my ($key, $innerRef) = each %oldHash ) {
        $newHash{$key} = @$innerRef[0];
    }
    return \%newHash;
}

# eof - xmlfix01.pl
