#!perl -w
#NAME: ExtUtils01.pl
#AIM: To explore some items in ExtUtils::MakeMaker::Config;
use strict;

use ExtUtils::MakeMaker::Config;
use File::Basename;
use File::Spec;
use ExtUtils::MakeMaker qw( neatvalue );
use vars qw(@ISA $VERSION);

my $BORLAND = 1 if $Config{'cc'} =~ /^bcc/i;
my $GCC     = 1 if $Config{'cc'} =~ /^gcc/i;
my $MSCC    = 1 if $Config{'cc'} =~ /^cl/i;

if ($MSCC) {
    prt( "is ms\n" );
} else {
    prt( "NO MS\n" );
}

if ($Config{ivsize} == 4 && $Config{cc} eq 'cl' and $Config{ccversion} =~ /^(\d+)/ and $1 >= 14) {
    prt( "IS MSVC8 or higher ...\n" );
} else {
    prt( "FAILED internal test for MSVC8 or above ...\n" );
    prt( "Config size ".$Config{ivsize}."\n" );
    prt( "Config cc   ".$Config{cc}."\n" );
    prt( "ccversion   ".$Config{ccversion}."\n" );
    $Config{ccversion} =~ /^(\d+)/;
    prt( " number     ".$1."\n" );

}

sub prt {
    my ($txt) = shift;
    print $txt;
}
